/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;
import ru.bitel.oss.systems.inventory.resource.server.bean.PhoneCategoryDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.PhoneResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.PhoneResourceSubscriptionDao;

@WebService(endpointInterface="ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService")
public class PhoneResourceServiceImpl
extends AbstractService
implements PhoneResourceService {
    private PhoneResourceDao phoneResourceDao = null;
    private PhoneResourceSubscriptionDao phoneResourceSubscriptionDao = null;
    private PhoneCategoryDao phoneCategoryDao = null;

    @PostConstruct
    void init() {
        this.phoneResourceDao = new PhoneResourceDao(this.getConnection(), this.moduleId);
        this.phoneResourceSubscriptionDao = new PhoneResourceSubscriptionDao(this.getConnection(), this.moduleId);
        this.phoneCategoryDao = new PhoneCategoryDao(this.getConnection(), this.moduleId);
    }

    public List<PhoneCategory> phoneCategoryList() throws Exception {
        return this.phoneCategoryDao.listPhoneCategory();
    }

    public PhoneCategory phoneCategoryRoot() throws Exception {
        return this.phoneCategoryDao.root();
    }

    public int phoneCategoryUpdate(PhoneCategory category) throws Exception {
        this.phoneCategoryDao.update(category);
        return category.getId();
    }

    public void phoneCategoryDelete(int id) throws Exception {
        if (this.phoneResourceDao.list(id).size() > 0) {
            throw new BGMessageException(" \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u0443 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e, \u0442\u0430\u043a \u043a\u0430\u043a \u0432 \u043d\u0435\u0439 \u0435\u0441\u0442\u044c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b");
        }
        this.phoneCategoryDao.delete(id);
    }

    public List<PhoneResource> phoneResourceList(int categoryId) throws Exception {
        return categoryId > 0 ? this.phoneResourceDao.list(categoryId) : this.phoneResourceDao.list();
    }

    public void phoneResourceDelete(int id) throws Exception {
        List<PhoneResourceSubscription> list = this.phoneResourceSubscriptionDao.list(id, null, null);
        if (list.size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438 ");
        }
        this.phoneResourceDao.delete(id);
    }

    public int phoneResourceUpdate(PhoneResource resource) throws Exception {
        List<PhoneResourceSubscription> subList;
        PhoneResource oldRes;
        List<PhoneResource> list = this.phoneResourceDao.list(resource.getCategoryId());
        for (PhoneResource r : list) {
            if (r.getId() == resource.getId() || r.getPhoneFrom() > resource.getPhoneTo() || r.getPhoneTo() < resource.getPhoneFrom() || r.getDateFrom() != null && resource.getDateTo() != null && r.getDateFrom().compareTo(resource.getDateTo()) > 0 || r.getDateTo() != null && resource.getDateFrom() != null && r.getDateTo().compareTo(resource.getDateFrom()) < 0) continue;
            throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0434\u0440\u0443\u0433\u043e\u0438\u043c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c \u0432 \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438!");
        }
        if (resource.getId() > 0 && ((oldRes = (PhoneResource)this.phoneResourceDao.get(resource.getId())).getDateFrom() == null ^ resource.getDateFrom() == null || oldRes.getDateFrom() != null && oldRes.getDateFrom().compareTo(resource.getDateFrom()) != 0 || oldRes.getDateTo() == null ^ resource.getDateTo() == null || oldRes.getDateTo() != null && oldRes.getDateTo().compareTo(resource.getDateTo()) != 0 || oldRes.getPhoneFrom() != resource.getPhoneFrom() || oldRes.getPhoneTo() != resource.getPhoneTo()) && (subList = this.phoneResourceSubscriptionDao.list(resource.getId(), null, null)).size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438 ");
        }
        this.phoneResourceDao.update(resource);
        return resource.getId();
    }

    public Result<PhoneResourceSubscription> phoneSubscriptionList(int phoneResourceId, Date dateFrom, Date dateTo, Page page) throws Exception {
        return this.phoneResourceSubscriptionDao.list(phoneResourceId, dateFrom, dateTo, page);
    }

    /*
     * Exception decompiling
     */
    public List<Long> phoneFreeList(Integer categoryId, Set<Integer> resourceIds, Date date, String numberFilter, int maxCount) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean phoneResourceSubscribe(long phone, int subscriberId, String subscriberTitle, Date dateFrom, Date dateTo) throws Exception {
        PhoneResourceSubscription subcripton = new PhoneResourceSubscription();
        this.phoneResourceSubscriptionDao.deleteBySubscriberId(subscriberId);
        List<PhoneResource> sources = this.phoneResourceDao.list(dateFrom, dateTo);
        int resourceId = -1;
        for (PhoneResource resource : sources) {
            if (resource.getPhoneFrom() > phone || phone > resource.getPhoneTo()) continue;
            List<PhoneResourceSubscription> list = this.phoneResourceSubscriptionDao.list(resource.getId(), dateFrom, dateTo, phone);
            if (list.size() > 0) {
                throw new BGMessageException("\u042d\u0442\u043e\u0442 \u043d\u043e\u043c\u0435\u0440 \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442 ");
            }
            if (resourceId != -1) continue;
            resourceId = resource.getId();
        }
        if (resourceId == -1) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u043e\u043c\u0435\u0440\u0430");
        }
        subcripton.setSubscriberId(subscriberId);
        subcripton.setSubscriberTitle(subscriberTitle);
        subcripton.setPhone(phone);
        subcripton.setPhoneResourseId(resourceId);
        subcripton.setDateFrom(dateFrom);
        subcripton.setDateTo(dateTo);
        this.phoneResourceSubscriptionDao.update(subcripton);
        return true;
    }

    public void phoneResourceUnsubscribe(int subscriberId) throws Exception {
        this.phoneResourceSubscriptionDao.deleteBySubscriberId(subscriberId);
    }

    public void phoneResourceImport(int categoryId, String importData) throws Exception {
        this.phoneResourceDao.importData(categoryId, importData);
    }

    private static /* synthetic */ Long lambda$phoneFreeList$3(PhoneResourceSubscription a) {
        return a.getPhone();
    }

    private /* synthetic */ void lambda$phoneFreeList$2(List subResult, Date date, PhoneResource a) throws Exception {
        subResult.addAll(this.phoneResourceSubscriptionDao.list(a.getId(), date, date));
    }
}

