/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.editor;

import bitel.billing.module.common.ModTreeNode;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.editor.ContractRuleEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class DlinkContractRuleEditor
extends ContractRuleEditorPanel {
    private BGTable ipPortTable = new BGTable();

    public DlinkContractRuleEditor() {
        this.jbInit();
        this.ipPortTable.setHeader(this.rb_name, this.moduleDoc, this.getTableName());
    }

    private void jbInit() {
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.setLayout(new GridBagLayout());
        this.add(new JPanel(new GridBagLayout()), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.addRulePanel();
        this.add((Component)okCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    protected void addRulePanel() {
        JPanel rulePanel = new JPanel(new GridBagLayout());
        rulePanel.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0430\u0432\u0438\u043b\u043e "));
        rulePanel.add((Component)new JScrollPane((Component)this.ipPortTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(rulePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() throws Exception {
        Request request = new Request().setModule(this.module).setAction("AddressContractInfo").setModuleId(this.getModuleId()).setContractId(this.getContractId()).setAttribute("date", new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
        Document mainDoc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)mainDoc)) {
            String data = "";
            if (!"0".equals(this.id)) {
                request = new Request();
                request.setModule(this.module);
                request.setAction("GetContractRule");
                request.setModuleId(this.getModuleId());
                request.setAttribute("id", this.id);
                request.setContractId(this.getContractId());
                Document doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Element rule = XMLUtils.getElement((Document)doc, (String)"rule");
                    data = this.getRule(ClientUtils.linesToString((Element)rule));
                }
            }
            HashMap<String, String> ipDataMap = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(data, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int pos = token.lastIndexOf(58);
                if (pos <= 0) continue;
                ipDataMap.put(token.substring(pos + 1), token.substring(0, pos));
            }
            this.ipPortTable.removeRows();
            for (Element row : XMLUtils.selectElements((Node)mainDoc.getDocumentElement(), (String)"/data/table/data/row")) {
                String addressRange = row.getAttribute("address_range");
                String comment = row.getAttribute("comment");
                String[] addresses = addressRange.split("\\s+\\-\\s+");
                if (addresses.length != 2) continue;
                long address1 = IPUtils.convertStringIPtoLong((String)addresses[0].trim(), (long)0L);
                long address2 = IPUtils.convertStringIPtoLong((String)addresses[1].trim(), (long)0L);
                if (addresses[0].trim().equals("0.0.0.0") || addresses[1].trim().equals("255.255.255.255")) continue;
                ModTreeNode rangeNode = new ModTreeNode();
                rangeNode.setAttribute("id", (Object)"0");
                rangeNode.setEn(true);
                rangeNode.setText(addressRange + " [" + comment + "]");
                rangeNode.setIcon("closed");
                if (address2 - address1 > 200L) {
                    address2 = address1 + 200L;
                }
                for (long address = address1; address <= address2; ++address) {
                    String addressString = IPUtils.convertLongIpToString((long)address);
                    String ipData = (String)ipDataMap.get(addressString);
                    Vector<String> rowData = new Vector<String>(2);
                    rowData.add(addressString);
                    if (ipData != null) {
                        for (String param : ipData.split(":")) {
                            rowData.add(param);
                        }
                    }
                    this.ipPortTable.addRow(rowData);
                }
            }
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            StringBuilder rule = new StringBuilder();
            int size = this.ipPortTable.getRowCount();
            for (int i = 0; i < size; ++i) {
                String addr = (String)this.ipPortTable.getValueAt(i, 0);
                String port = (String)this.ipPortTable.getValueAt(i, 1);
                String mac = null;
                if (this.ipPortTable.getColumnCount() > 2) {
                    mac = (String)this.ipPortTable.getValueAt(i, 2);
                    if (!Utils.checkMacAddres((String)(mac = mac.replace(':', '-')))) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 MAC \u0430\u0434\u0440\u0435\u0441");
                        return;
                    }
                }
                if (!Utils.notBlankString((String)port) || Utils.parseInt((String)port) <= 0) continue;
                if (rule.length() > 0) {
                    rule.append(";");
                }
                rule.append(port);
                if (Utils.notBlankString((String)mac)) {
                    rule.append(":");
                    rule.append(mac);
                }
                rule.append(":");
                rule.append(addr);
            }
            Request req = new Request();
            req.setModule(this.module);
            req.setAction(this.getUpdateAction());
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.id);
            req.setContractId(this.getContractId());
            req.setAttribute("fwid", this.gateId);
            req.setAttribute("rtid", "0");
            req.setAttribute("rule", rule.toString());
            if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
                this.contractGates.showGates();
            }
        } else {
            this.contractGates.showGates();
        }
    }

    protected String getUpdateAction() {
        return "UpdateDlinkContractRule";
    }

    protected String getRule(String rule) {
        return rule;
    }

    protected String getTableName() {
        return "dlink_ip_port";
    }
}

