/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.service;

import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxCharge;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxClientPairData;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxTariff;
import ru.bitel.bgbilling.modules.vidimax.common.service.VidimaxService;
import ru.bitel.bgbilling.modules.vidimax.server.bean.VidimaxChargeDao;
import ru.bitel.bgbilling.modules.vidimax.server.bean.VidimaxClientPairDataDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.EyelessSSLSocketFactory;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.vidimax.common.service.VidimaxService")
public class VidimaxServiceImpl
extends AbstractService
implements VidimaxService {
    public List<Charge> getTransactions(int contractId, Period period) throws Exception {
        int chargeTypeId = this.getModuleSetup().getInt("charge.type.id", -1);
        return new ChargeDao(this.getConnection()).getChargeList(contractId, chargeTypeId, period, 1).getList();
    }

    public VidimaxClientPairData clientPairDataGet(int contractId) throws Exception {
        try (VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(this.getConnection(), this.moduleId);){
            VidimaxClientPairData vidimaxClientPairData = pairDataDao.getByContractid(contractId);
            return vidimaxClientPairData;
        }
    }

    public void updateClientPairData(VidimaxClientPairData pairData) throws Exception {
        try (VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(this.getConnection(), this.moduleId);){
            pairDataDao.update(pairData);
        }
    }

    public void deleteClientPairData(int contractId) throws Exception {
        try (VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(this.getConnection(), this.moduleId);){
            VidimaxClientPairData pairData = pairDataDao.getByContractid(contractId);
            if (pairData.isPair()) {
                throw new BGMessageException("\u0423\u0434\u0430\u043b\u044f\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
            }
            pairDataDao.deleteByContractId(contractId);
        }
    }

    public List<VidimaxCharge> chargeList(int contractId, Period period, Page page, Holder<BigDecimal> holderTotalSum) throws Exception {
        if (TimeUtils.dateBefore((Date)period.getDateTo(), (Date)period.getDateFrom())) {
            period = new Period(period.getDateTo(), period.getDateFrom());
        }
        Calendar timeFrom = period.getDateFromCalendar();
        Calendar timeTo = period.getDateToCalendar();
        ArrayList<VidimaxCharge> list = new ArrayList<VidimaxCharge>();
        if (timeFrom == null) {
            return list;
        }
        if (timeTo == null) {
            period.setDateTo(new Date());
            timeTo = period.getDateToCalendar();
        }
        do {
            VidimaxChargeDao chargeDao = new VidimaxChargeDao(this.getConnection(), this.moduleId, timeFrom.getTime());
            if (TimeUtils.monthsDelta((Calendar)timeFrom, (Calendar)period.getDateFromCalendar()) != 0) {
                timeFrom.set(5, 1);
            }
            if (TimeUtils.monthsDelta((Calendar)timeFrom, (Calendar)timeTo) > 0) {
                timeTo.set(5, timeTo.getActualMaximum(5));
            } else {
                timeTo = period.getDateToCalendar();
            }
            Holder holderSum = new Holder((Object)BigDecimal.ZERO);
            list.addAll(chargeDao.getChargeList(contractId, period, page, (Holder<BigDecimal>)holderSum));
            if (holderTotalSum != null && holderTotalSum.value != null) {
                holderTotalSum.value = ((BigDecimal)holderTotalSum.value).add((BigDecimal)holderSum.value);
            }
            timeFrom.add(2, 1);
        } while (TimeUtils.monthsDelta((Calendar)timeFrom, (Calendar)timeTo) > -1);
        return list;
    }

    public List<VidimaxTariff> activeTariffList(int contractId, boolean tv) throws Exception {
        ArrayList<VidimaxTariff> list;
        block16: {
            list = new ArrayList<VidimaxTariff>();
            Random rand = new Random();
            Object activeTariffsUrl = this.getModuleSetup().get("url.tariff.active", null);
            if (Utils.isBlankString((String)activeTariffsUrl)) {
                String mess = "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0442\u0430\u0440\u0438\u0444\u043e\u0432( url.tariff.active )";
                this.getLogger().error(mess);
                throw new BGMessageException(mess);
            }
            String operationId = contractId + "_" + new Date().getTime() + "_" + this.userId + "_" + rand.nextInt(10000);
            VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(this.getConnection(), this.moduleId);
            VidimaxClientPairData pairData = pairDataDao.getByContractid(contractId);
            pairDataDao.close();
            if (pairData == null || !pairData.isPair()) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a Vidimax");
            }
            try {
                String operatorSecret = this.getModuleSetup().get("operator.secret", "");
                String secretString = "customerId:" + pairData.getCustomerId() + ",operationId:" + operationId + "{" + operatorSecret + "}";
                MessageDigest md = MessageDigest.getInstance("md5");
                String sign = Utils.bytesToHexString((byte[])md.digest(secretString.toString().getBytes()));
                activeTariffsUrl = (String)activeTariffsUrl + (tv ? "listActiveTariffsTv" : "listActiveTariffsVod");
                activeTariffsUrl = (String)activeTariffsUrl + "?operationId=" + URLEncoder.encode(operationId, "UTF-8");
                activeTariffsUrl = (String)activeTariffsUrl + "&customerId=" + URLEncoder.encode(pairData.getCustomerId(), "UTF-8");
                activeTariffsUrl = (String)activeTariffsUrl + "&sign=" + URLEncoder.encode(sign, "UTF-8");
                URL url = new URL((String)activeTariffsUrl);
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                try {
                    con.setSSLSocketFactory(EyelessSSLSocketFactory.INSTANCE);
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                con.setHostnameVerifier((HostnameVerifier)EyelessHostnameVerifier.INSTANCE);
                con.setRequestMethod("GET");
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String vidimaxBasicLogin = this.getModuleSetup().get("vidimax.basic.auth.login", null);
                if (vidimaxBasicLogin == null) {
                    throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 vidimax.basic.auth.login");
                }
                String vidimaxBasicPassword = this.getModuleSetup().get("vidimax.basic.auth.password", null);
                if (vidimaxBasicPassword == null) {
                    throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 vidimax.basic.auth.password");
                }
                String userPassword = vidimaxBasicLogin + ":" + vidimaxBasicPassword;
                String encoding = Base64.encodeUTF8((String)userPassword);
                con.setRequestProperty("Authorization", "Basic " + encoding);
                JSONObject jsonAnswer = null;
                if (con.getResponseCode() == 200) {
                    byte[] d = Utils.readByBlock((InputStream)con.getInputStream());
                    jsonAnswer = new JSONObject(new String(d, "UTF-8"));
                    this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u043f\u043e\u043b\u0443\u0447\u0435\u043d.");
                } else {
                    this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 Vidimax. Code - " + con.getResponseCode());
                }
                if (jsonAnswer == null) {
                    return list;
                }
                if (jsonAnswer.getInt("resultCode") == 0) {
                    JSONArray tariffList = (JSONArray)jsonAnswer.get("activeTariffsList");
                    int tariffsTotal = tariffList.length();
                    for (int i = 0; i < tariffsTotal; ++i) {
                        JSONObject jsonTariff = (JSONObject)tariffList.get(i);
                        VidimaxTariff tariff = new VidimaxTariff();
                        tariff.setId(jsonTariff.getInt("id"));
                        tariff.setTitle(jsonTariff.getString("name"));
                        tariff.setPrimary(jsonTariff.getInt("primary") == 1);
                        tariff.setSum(new BigDecimal(jsonTariff.getLong("price")).divide(new BigDecimal(100)));
                        if (this.getParamLong(jsonTariff, "startCurrentPeriod") != -1L) {
                            tariff.setStartCurrentPeriod(new Date(this.getParamLong(jsonTariff, "startCurrentPeriod")));
                        }
                        if (this.getParamLong(jsonTariff, "stopCurrentPeriod") != -1L) {
                            tariff.setStopCurrentPeriod(new Date(jsonTariff.getInt("stopCurrentPeriod")));
                        }
                        if (this.getParamLong(jsonTariff, "expirationDate") != -1L) {
                            tariff.setExpirationDate(new Date(this.getParamLong(jsonTariff, "expirationDate")));
                        }
                        tariff.setPricePeriod(jsonTariff.optString("pricePeriod", null));
                        tariff.setDescription(jsonTariff.optString("description"));
                        list.add(tariff);
                    }
                    break block16;
                }
                throw new BGMessageException(jsonAnswer.getString("resultMessage"));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new BGException((Throwable)e);
            }
        }
        return list;
    }

    public List<IdTitle> tariffsForPair() throws Exception {
        List listIds = Utils.toIntegerList((String)this.getModuleSetup().get("tariffsIds.available", null));
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        for (Integer id : listIds) {
            result.add(new IdTitle(id.intValue(), this.getModuleSetup().get("tariff." + id + ".title")));
        }
        return result;
    }

    public MapHolder<Integer, IdTitle> serviceMap() throws Exception {
        List listIds = Utils.toIntegerList((String)this.getModuleSetup().get("serviceIds", null));
        HashMap<Integer, IdTitle> result = new HashMap<Integer, IdTitle>();
        int defaultService = this.getModuleSetup().getInt("account.default.serviceId", -1);
        for (Integer id : listIds) {
            int idService = this.getModuleSetup().getInt("service." + id + ".accountServiceId", -1);
            String title = this.getModuleSetup().get("service." + id + ".title", null);
            result.put(id, new IdTitle(idService == -1 ? defaultService : idService, (String)(title == null ? "" + id : title)));
        }
        return new MapHolder(result);
    }

    public MapHolder<Integer, String> tariffMap() throws Exception {
        List listIds = Utils.toIntegerList((String)this.getModuleSetup().get("tariffsIds", null));
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        for (Integer id : listIds) {
            String title = this.getModuleSetup().get("tariff." + id + ".title");
            result.put(id, title == null ? "" + id : title);
        }
        return new MapHolder(result);
    }

    private long getParamLong(JSONObject jsonTariff, String param) {
        long res = -1L;
        try {
            res = jsonTariff.getLong(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

