package ru.bitel.bgbilling.modules.tv.dyn.smarty;

import bitel.billing.server.util.Config;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public class SmartyConf
    extends Config
{
    final String clientId, secretKey, serverUrl, modulePrefix;
    final int paramEmailId, paramPhoneId, paramFirstnameId, paramMiddlenameId, paramLastnameId, connectTimeout, readTimeout;
    
    public SmartyConf( int moduleId, ParameterMap moduleSetup, Setup serverSetup )
    {
        super( moduleId, moduleSetup, serverSetup );

        clientId = moduleSetup.get( "om.smarty.client.id" );
        modulePrefix = moduleSetup.get( "om.smarty.module.prefix", "bg" );
        paramEmailId = moduleSetup.getInt( "om.smarty.email.id", 0 );
        paramPhoneId = moduleSetup.getInt( "om.smarty.phone.id", 0 );
        paramFirstnameId = moduleSetup.getInt( "om.smarty.firstname.id", 0 );
        paramMiddlenameId = moduleSetup.getInt( "om.smarty.middlename.id", 0 );
        paramLastnameId = moduleSetup.getInt( "om.smarty.lastname.id", 0 );
        secretKey = moduleSetup.get( "om.smarty.secret.key" );
        serverUrl = moduleSetup.get( "om.smarty.server.url" );
        readTimeout = moduleSetup.getInt( "om.smarty.read.timeout", 1000 );
        connectTimeout = moduleSetup.getInt( "om.smarty.connect.timeout", 1000 );
    }
}
