/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeCache;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDetailDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.bean.ProductRejectCause;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;

public class TvTarifficationManager
extends BGLogger {
    private static final Logger logger = LogManager.getLogger();
    private final Setup setup;
    private final ConnectionSet connectionSet;
    private final int moduleId;
    private BalanceDao balanceDao;
    private PoolEventPublisher<ContractBalanceChangedEvent> balanceEP;
    private final Calendar utilCalendar = new GregorianCalendar();
    private int _dd = -1;
    private int _mm = -1;
    private int _yy = -1;
    private PreparedStatement insertDetailPS;
    private final int balanceRoundingScale = 5;
    private final RoundingMode balanceRoundingMode = RoundingMode.HALF_EVEN;

    public TvTarifficationManager(Setup setup, ConnectionSet connectionSet, int moduleId) {
        this.setup = setup;
        this.connectionSet = connectionSet;
        this.moduleId = moduleId;
    }

    public TvTarifficationManager(Setup setup, ConnectionSet connectionSet, int moduleId, PoolEventPublisher<ContractBalanceChangedEvent> balanceEP) {
        this.setup = setup;
        this.connectionSet = connectionSet;
        this.moduleId = moduleId;
        this.balanceEP = balanceEP;
    }

    private BalanceDao getBalanceDao() {
        if (this.balanceDao == null) {
            this.balanceDao = new BalanceDao(this.connectionSet.getConnection());
        }
        return this.balanceDao;
    }

    private static TvTariffRequest tarifficate(TvTariffContext tariffContext, TvTariffWorkerContext workerContext, int moduleId, ConnectionSet connectionSet, ContractRuntime contractRuntime, int contractId, TvAccountRuntime tvAccountRuntime, int tvAccountId, List<Integer> contractLabelIds, List<TariffModuleTreeSet.Entry> treeList, BigDecimal balance, BigDecimal limit, ContractTariffOptionList contractTariffOptions, List<TvServiceCost> tvServiceCostList, Calendar tariffRequestTime) throws BGException {
        TvTariffRequest tvTariffRequest = new TvTariffRequest(contractRuntime.getDomainId(), moduleId, contractId, contractLabelIds, tvAccountId, 0L);
        tvTariffRequest.setConnectionSet(connectionSet);
        tvTariffRequest.setTime(tariffRequestTime);
        tvTariffRequest.setBalance(balance);
        tvTariffRequest.setLimit(limit);
        tvTariffRequest.setContractTariffOptions(contractTariffOptions);
        tvTariffRequest.setContractProductPeriodRuntimeList(contractRuntime.getContractProductPeriods(tariffRequestTime.getTime()));
        if (tvAccountId != 0) {
            tvTariffRequest.setProductPeriodRuntimeList(tvAccountRuntime.getProductPeriodRuntimeList());
        }
        for (TvServiceCost tvServiceCost : tvServiceCostList) {
            tvTariffRequest.addServiceCost(tvServiceCost);
        }
        int size = treeList.size();
        for (int i = 0; i < size; ++i) {
            TariffModuleTreeSet.Entry entry = treeList.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug("TariffRequest:\n" + tvTariffRequest);
            }
            tvTariffRequest.setTariffTreeSetEntry(entry);
            entry.getTree().execute((AbstractTariffRequest)tvTariffRequest, (TariffContext)tariffContext, (ThreadContext)workerContext);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Executed TariffRequest:\n" + tvTariffRequest);
        }
        return tvTariffRequest;
    }

    private TvTariffRequest tarifficateOfferings(int contractId, int accountId, List<TariffModuleTreeSet.Entry> treeList, List<ProductOffering> productOfferingList, Date date, Calendar calendar) throws Exception {
        ProductOffering productOffering;
        ArrayList<TvServiceCost> serviceCostList = new ArrayList<TvServiceCost>();
        HashMap<CallSite, ProductOfferingActivationMode> activationModeMap = new HashMap<CallSite, ProductOfferingActivationMode>();
        ProductSpecRuntimeMap productSpecRuntimeMap = ProductSpecRuntimeMap.getInstance(this.connectionSet);
        this.getLogger().trace(String.format("tarifficateOfferings. contractId=%s, accountId=%s, productOfferingList size=%s, date=%s", contractId, accountId, productOfferingList.size(), TimeUtils.formatFullDate((Date)date)));
        int size = productOfferingList.size();
        for (int i = 0; i < size; ++i) {
            productOffering = productOfferingList.get(i);
            int productSpecId = productOffering.getProductSpec().getId();
            List activationModeList = productOffering.getActivationModeList();
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(productSpecId);
            int jsize = activationModeList.size();
            for (int j = 0; j < jsize; ++j) {
                ProductOfferingActivationMode activationMode = (ProductOfferingActivationMode)activationModeList.get(j);
                int activationModeId = activationMode.getProductSpecActivationMode().getId();
                TvServiceCost serviceCost = TvServiceCost.builder().setServiceId(-productSpecId).setProductId(0).setProductSpecRuntime(productSpecRuntime).setActivationModeId(activationModeId).setActivationTime(date).setServiceStart(calendar).setAmount(1L).build();
                serviceCostList.add(serviceCost);
                activationModeMap.put((CallSite)((Object)(productSpecId + "_" + activationModeId)), activationMode);
            }
        }
        this.getLogger().trace("serviceCostList size = " + serviceCostList.size());
        TvTariffRequest req = this.tarifficate(contractId, null, accountId, treeList, serviceCostList, date, calendar);
        for (TvServiceCost serviceCost : req.getServiceCostList()) {
            int serviceId = serviceCost.getServiceId();
            BigDecimal price = serviceCost.getCost();
            if (serviceId <= 0 || price == null) continue;
            ProductOfferingActivationMode.builder((ProductOfferingActivationMode)((ProductOfferingActivationMode)activationModeMap.get(serviceCost.getProductSpecRuntime().getProductSpec().getId() + "_" + serviceCost.getActivationModeId()))).setActivationPrice(serviceCost.activationPrice).setPrice(price).setPeriodMode(serviceCost.periodMode).setPeriodAmount(serviceCost.periodAmount).build();
        }
        Iterator<ProductOffering> productOfferingIter = productOfferingList.iterator();
        while (productOfferingIter.hasNext()) {
            productOffering = productOfferingIter.next();
            List activationModeList = productOffering.getActivationModeList();
            int periodMode = -1;
            int periodAmount = -1;
            BigDecimal price = null;
            boolean priceEq = true;
            boolean periodEq = true;
            Iterator activationModeIter = activationModeList.iterator();
            while (activationModeIter.hasNext()) {
                ProductOfferingActivationMode activationMode = (ProductOfferingActivationMode)activationModeIter.next();
                BigDecimal activationModePrice = activationMode.getPrice();
                if (activationModePrice == null || activationMode.getActivationPrice() == null) {
                    activationModeIter.remove();
                    continue;
                }
                if (price == null) {
                    price = activationModePrice;
                } else if (price.compareTo(activationModePrice) != 0) {
                    priceEq = false;
                }
                if (periodMode == -1) {
                    periodMode = activationMode.getPeriodMode();
                    periodAmount = activationMode.getPeriodAmount();
                    continue;
                }
                if (periodMode == activationMode.getPeriodMode() && periodAmount == activationMode.getPeriodAmount()) continue;
                periodEq = false;
            }
            if (activationModeList.size() == 0) {
                productOfferingIter.remove();
                continue;
            }
            if (priceEq) {
                productOffering.setPrice(price);
            }
            if (!periodEq) continue;
            productOffering.setPeriodMode(periodMode);
            productOffering.setPeriodAmount(periodAmount);
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvTariffRequest tarifficate(int contractId, TvAccountRuntime tvAccountRuntime, Date date) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(this.connectionSet.getConnection());
        TariffModuleTreeSet treeSet = treeSetDao.getTariffTreeSetForDay(contractId, (Calendar)calendar, "tv", this.moduleId, this.moduleId, tvAccountRuntime.tvAccountId);
        treeSetDao.close();
        List treeList = treeSet.getEntryList(calendar.getTimeInMillis());
        tvAccountRuntime.lock();
        try {
            List<TvServiceCost> serviceCostList = TvUtils.createServiceCostList(ProductSpecRuntimeMap.getInstance(this.connectionSet), tvAccountRuntime, date.getTime());
            TvTariffRequest tvTariffRequest = this.tarifficate(contractId, tvAccountRuntime, tvAccountRuntime.tvAccountId, treeList, serviceCostList, date, calendar);
            return tvTariffRequest;
        }
        finally {
            tvAccountRuntime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvTariffRequest tarifficate(int contractId, TvAccountRuntime tvAccountRuntime, int accountId, List<TariffModuleTreeSet.Entry> treeList, List<TvServiceCost> serviceCostList, Date date, Calendar calendar) throws Exception {
        TvTariffRequest req;
        TvTariffContext tariffContext = new TvTariffContext(this.connectionSet, this.moduleId, calendar.getTime(), TvTariffContext.TvTariffMode.realtime);
        TvTariffWorkerContext workerContext = new TvTariffWorkerContext(this.setup, this.moduleId);
        try {
            BigDecimal limit;
            BigDecimal balance;
            ContractRuntime contractRuntime = contractId == 0 ? ContractRuntime.STUB : ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(contractId));
            ContractTariffOptionList contractTariffOptions = contractRuntime.getTariffOptions(calendar.getTime());
            Map tariffOptionsMap = null;
            if (contractTariffOptions != null) {
                long millis = calendar.getTimeInMillis();
                tariffOptionsMap = contractTariffOptions.map(millis, millis);
            }
            this.getLogger().debug("TariffOptionMap: " + tariffOptionsMap);
            if (contractId == 0) {
                balance = BigDecimal.ZERO;
                limit = BigDecimal.ZERO;
            } else {
                ConvergenceBalance convergenceBalance = ConvergenceBalanceManager.getInstance().getBalance(this.connectionSet, Integer.valueOf(contractId), date.getTime());
                balance = convergenceBalance.getBalance();
                limit = convergenceBalance.getLimit();
            }
            if (tvAccountRuntime == null) {
                tariffContext.getTvAccountRuntimeMap().load(this.connectionSet, contractId);
                tvAccountRuntime = tariffContext.getTvAccountRuntimeMap().get(accountId);
            }
            List contractLabelIds = new ContractLabelManager(this.connectionSet.getConnection()).getContractLabelIds(contractId);
            req = TvTarifficationManager.tarifficate(tariffContext, workerContext, this.moduleId, this.connectionSet, contractRuntime, contractId, tvAccountRuntime, accountId, contractLabelIds, treeList, balance, limit, contractTariffOptions, serviceCostList, calendar);
        }
        finally {
            workerContext.recycle();
        }
        return req;
    }

    public TvTariffRequest tarifficateOfferings(int contractId, int accountId, List<ProductOffering> productOfferingList, Date date) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(this.connectionSet.getConnection());
        TariffModuleTreeSet treeSet = treeSetDao.getTariffTreeSetForDay(contractId, (Calendar)calendar, "tv", this.moduleId, this.moduleId, accountId);
        treeSetDao.close();
        List treeList = treeSet.getEntryList(calendar.getTimeInMillis());
        return this.tarifficateOfferings(contractId, accountId, treeList, productOfferingList, date, calendar);
    }

    public TvTariffRequest tarifficateOfferings(Connection con, int tariffPlanId, List<ProductOffering> productOfferingList, Date date) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date);
        int treeId = new TariffPlanDao(con).getTariffPlanTreeId(tariffPlanId);
        AtomicReference tree = TariffTreeCache.getInstance().getModuleTree(con, treeId, this.moduleId, "tv");
        if (tree.get() == null) {
            this.getLogger().info("Tariff module tree not found for tariffPlanId:" + tariffPlanId + " and moduleId:" + this.moduleId);
            return null;
        }
        List<TariffModuleTreeSet.Entry> treeList = Collections.singletonList(new TariffModuleTreeSet.Entry(tree, 0, 0L, 0L));
        return this.tarifficateOfferings(0, 0, treeList, productOfferingList, date, calendar);
    }

    private boolean init(int yy, int mm, int dd) throws SQLException {
        if (this._dd == dd) {
            if (this._mm == mm && this._yy == yy) {
                return false;
            }
        } else {
            this._dd = dd;
            if (this._mm == mm && this._yy == yy) {
                this.insertDetailPS.setInt(5, this._dd);
                return false;
            }
        }
        this._mm = mm;
        this._yy = yy;
        if (this.insertDetailPS != null) {
            this.insertDetailPS.close();
            this.insertDetailPS = null;
        }
        Connection con = this.connectionSet.getConnection();
        GregorianCalendar month = new GregorianCalendar(this._yy, this._mm - 1, 1);
        String detailTable = ServerUtils.getModuleMonthTableName((String)"tv_account_detail", (Date)month.getTime(), (int)this.moduleId);
        TvAccountDetailDao.checkTable(con, detailTable);
        this.insertDetailPS = con.prepareStatement("INSERT INTO " + detailTable + " (contractId, accountId, productId, sid, day, account) VALUES (?,?,?,?,?,?) ON DUPLICATE KEY UPDATE account=account+?");
        this.insertDetailPS.setInt(5, this._dd);
        return true;
    }

    private static void addAccountDelta(Map<Integer, AccountDelta> accountDeltaMap, int sid, BigDecimal account) {
        AccountDelta accountDelta = accountDeltaMap.get(sid);
        if (accountDelta == null) {
            accountDelta = new AccountDelta(account);
            accountDeltaMap.put(sid, accountDelta);
        } else {
            accountDelta.delta = accountDelta.delta.add(account);
        }
    }

    private static void addProductAccountDelta(Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap, int productId, int serviceId, Calendar date, BigDecimal account) {
        int yy = date.get(1);
        int mm = date.get(2) + 1;
        int day = date.get(5);
        ProductAccountKey key = new ProductAccountKey(productId, serviceId, day);
        productAccountDeltaMonthMap.computeIfAbsent(new MonthKey(yy, mm), k -> new HashMap()).compute(key, (k, v) -> {
            if (v == null) {
                return new AccountDelta(account);
            }
            v.delta = v.delta.add(account);
            return v;
        });
    }

    public CalculateResult calculate(boolean detailAccount, boolean addAccount, TvTariffContext tariffContext, TvTariffWorkerContext workerContext, boolean activation, boolean period, ContractRuntime contractRuntime, int contractId, ContractTariffOptionList contractTariffOptions, TvAccountRuntimeRoot tvAccountRuntime, int accountId, List<TvServiceCost> serviceCostList, TariffModuleTreeSet treeSet, Calendar tariffRequestTime, Date currentTime, BigDecimal balance, BigDecimal limit, boolean error, boolean recalculate, Date filterTimeFrom, Date filterTimeTo, ProductRejectCause reject) throws Exception {
        assert (accountId == 0 == (tvAccountRuntime == null));
        if (addAccount) {
            detailAccount = true;
        }
        List<TariffModuleTreeSet.Entry> treeList = this.getTreeList(treeSet, tariffRequestTime, currentTime, filterTimeTo);
        List contractLabelIds = new ContractLabelManager(this.connectionSet.getConnection()).getContractLabelIds(contractId);
        TvTariffRequest req = TvTarifficationManager.tarifficate(tariffContext, workerContext, this.moduleId, this.connectionSet, contractRuntime, contractRuntime.contractId, tvAccountRuntime, accountId, contractLabelIds, treeList, balance, limit, contractTariffOptions, serviceCostList, tariffRequestTime);
        HashSet<Integer> prolongatedProductSpecId = new HashSet<Integer>();
        try {
            Collection<TvServiceCost> processServiceCostList;
            Calendar calendar;
            HashMap<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap;
            HashMap<MonthKey, Map<ProductAccountKey, AccountDelta>> hashMap = productAccountDeltaMonthMap = detailAccount || addAccount ? new HashMap<MonthKey, Map<ProductAccountKey, AccountDelta>>(4) : null;
            if (addAccount && recalculate && filterTimeFrom != null) {
                calendar = TimeUtils.convertDateToCalendar((Date)filterTimeFrom);
                int yy = calendar.get(1);
                int mm = calendar.get(2) + 1;
                productAccountDeltaMonthMap.put(new MonthKey(yy, mm), new HashMap());
            }
            calendar = new GregorianCalendar();
            if (tariffContext.isProlongation()) {
                processServiceCostList = serviceCostList;
                assert (serviceCostList.size() == req.getServiceCostList().size());
                assert (serviceCostList.containsAll(req.getServiceCostList()));
            } else {
                processServiceCostList = req.getServiceCostList();
            }
            for (TvServiceCost serviceCost : processServiceCostList) {
                BigDecimal cost = serviceCost.getCost();
                BigDecimal activationPrice = serviceCost.activationPrice;
                int prolongation = serviceCost.prolongation;
                serviceCost.prolongation = 0;
                if ((serviceCost.periodTimeFrom == null || serviceCost.periodTimeTo == null) && cost == null) {
                    if (!error) continue;
                    throw new BGException("\u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
                }
                Date timeFrom = serviceCost.getProductItem() != null && serviceCost.getProductItem().productPeriodActivationTime != null && !serviceCost.periodTimeFrom.after(serviceCost.getProductItem().productPeriodActivationTime) && !serviceCost.periodTimeTo.before(serviceCost.getProductItem().productPeriodActivationTime) ? serviceCost.getProductItem().productPeriodActivationTime : serviceCost.periodTimeFrom;
                if (filterTimeFrom != null && filterTimeFrom.after(timeFrom) || filterTimeTo != null && filterTimeTo.before(timeFrom)) continue;
                calendar.setTime(timeFrom);
                if (serviceCost.activationServiceId <= 0) {
                    serviceCost.activationServiceId = serviceCost.getServiceId();
                }
                if (this.isReject(serviceCost, reject)) {
                    if (!error) continue;
                    throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442.");
                }
                if (!activation && tariffContext.isProlongation() && (!TvUtils.checkDependent(contractRuntime, tvAccountRuntime, accountId, tariffRequestTime, prolongatedProductSpecId, serviceCost) || !TvUtils.checkIncompatible(contractRuntime, tvAccountRuntime, accountId, tariffRequestTime, prolongatedProductSpecId, serviceCost.getProductSpecRuntime().getProductSpec())) || !TvTarifficationManager.checkServiceAndCost(activation, period, error, serviceCost, cost, activationPrice)) continue;
                if (!period) {
                    cost = BigDecimal.ZERO;
                }
                if (activation) {
                    this.utilCalendar.setTime(serviceCost.getActivationTime());
                    AtomicReference<BigDecimal> balanceRef = new AtomicReference<BigDecimal>(balance);
                    if (!this.processActivation(addAccount, balanceRef, limit, error, calendar, serviceCost, activationPrice, productAccountDeltaMonthMap)) continue;
                    balance = balanceRef.get();
                }
                cost = cost.setScale(5, this.balanceRoundingMode);
                if (balance != null) {
                    BigDecimal newBalance = balance.subtract(cost);
                    if (!recalculate && this.lowBalance(newBalance, limit, serviceCost)) continue;
                    balance = newBalance;
                }
                if (productAccountDeltaMonthMap != null) {
                    TvTarifficationManager.addProductAccountDelta(productAccountDeltaMonthMap, serviceCost.getProductId(), serviceCost.getServiceId(), calendar, cost);
                }
                serviceCost.prolongation = prolongation;
                if (prolongation == 0) continue;
                prolongatedProductSpecId.add(serviceCost.getProductSpecRuntime().productSpec.getId());
            }
            if (addAccount && productAccountDeltaMonthMap.size() > 0) {
                this.updateAccount(contractRuntime, contractId, accountId, recalculate, productAccountDeltaMonthMap);
            }
            req.setBalance(balance);
            return new CalculateResult(req, balance, productAccountDeltaMonthMap);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private boolean lowBalance(BigDecimal newBalance, BigDecimal limit, TvServiceCost serviceCost) {
        if (serviceCost.ignoreBalance) {
            this.getLogger().info("lowBalance: => serviceCost.ignoreBalance");
            return false;
        }
        BigDecimal negBalance = newBalance.subtract(limit);
        this.getLogger().info("lowBalance: negBalance => " + negBalance + ", ignoreBalanceSumma=>" + serviceCost.ignoreBalanceSumma);
        if (negBalance.compareTo(serviceCost.ignoreBalanceSumma) < 0) {
            this.getLogger().info("lowBalance: =>negBalance.compareTo( serviceCost.ignoreBalanceSumma)<0 ");
            return true;
        }
        return false;
    }

    private boolean isReject(TvServiceCost serviceCost, ProductRejectCause reject) {
        boolean result = false;
        this.getLogger().info("ProductRejectCause for productId[" + serviceCost.getProductId() + "]=>" + reject.toString());
        this.getLogger().info("serviseCost=>" + serviceCost.toString());
        if (reject.isRejectBySecondary()) {
            this.getLogger().info("ProductRejectCause: => reject.isRejectBySecondary()");
            return true;
        }
        if (reject.getContractStatus() >= 0 && !serviceCost.contractStatusSet.isEmpty()) {
            this.getLogger().info("ProductRejectCause: => reject.getContractStatus()>=0&&!serviceCost.contractStatusSet.isEmpty()");
            if (!serviceCost.contractStatusSet.contains(reject.getContractStatus())) {
                this.getLogger().info("ProductRejectCause: => !serviceCost.contractStatusSet.contains( reject.getContractStatus()");
                result = true;
            }
        } else if (reject.isRejectByContractStatus()) {
            this.getLogger().info("ProductRejectCause: => reject.isRejectByContractStatus()");
            result = true;
        }
        if (reject.getDeviceState() != -2000 && !serviceCost.deviceStateSet.isEmpty()) {
            this.getLogger().info("ProductRejectCause: => reject.getDeviceState()!=-2000&&!serviceCost.deviceStateSet.isEmpty()");
            if (!serviceCost.deviceStateSet.contains(reject.getDeviceState())) {
                this.getLogger().info("ProductRejectCause: => !serviceCost.deviceStateSet.contains( reject.getDeviceState())");
                result = true;
            }
        } else if (reject.isRejectByDeviceState()) {
            this.getLogger().info("ProductRejectCause: => reject.isRejectByDeviceState()");
            result = true;
        }
        this.getLogger().info("ProductRejectCause:result =>" + result);
        return result;
    }

    private List<TariffModuleTreeSet.Entry> getTreeList(TariffModuleTreeSet treeSet, Calendar tariffRequestTime, Date currentTime, Date filterTimeTo) {
        List treeList = treeSet.getEntryList(tariffRequestTime.getTimeInMillis());
        if (treeList.size() == 0) {
            if (currentTime != null) {
                treeList = treeSet.getEntryList(currentTime.getTime());
            } else {
                if (filterTimeTo != null) {
                    treeList = treeSet.getEntryList(filterTimeTo.getTime());
                }
                if (treeList.size() == 0) {
                    Calendar calendar = (Calendar)tariffRequestTime.clone();
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
                    calendar.set(5, 1);
                    calendar.add(2, 1);
                    calendar.add(5, -1);
                    treeList = treeSet.getEntryList(calendar.getTime().getTime());
                }
            }
        }
        return treeList;
    }

    private void updateAccount(ContractRuntime contractRuntime, int contractId, int accountId, boolean recalculate, Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap) throws SQLException, BGException {
        BalanceDao balanceDao = this.getBalanceDao();
        HashMap<Integer, AccountDelta> accountDeltaMap = new HashMap<Integer, AccountDelta>();
        for (Map.Entry<MonthKey, Map<ProductAccountKey, AccountDelta>> ee : productAccountDeltaMonthMap.entrySet()) {
            MonthKey monthKey = ee.getKey();
            int yy = monthKey.yy;
            int mm = monthKey.mm;
            Map<ProductAccountKey, AccountDelta> productAccountDeltaMap = ee.getValue();
            accountDeltaMap.clear();
            for (Map.Entry<ProductAccountKey, AccountDelta> e : productAccountDeltaMap.entrySet()) {
                ProductAccountKey key = e.getKey();
                AccountDelta accountDelta = e.getValue();
                this.init(yy, mm, key.day);
                this.insertDetailPS.setInt(1, contractRuntime.contractId);
                this.insertDetailPS.setInt(2, accountId);
                this.insertDetailPS.setInt(3, key.productId);
                this.insertDetailPS.setInt(4, key.serviceId);
                this.insertDetailPS.setInt(5, key.day);
                this.insertDetailPS.setBigDecimal(6, accountDelta.delta);
                this.insertDetailPS.setBigDecimal(7, accountDelta.delta);
                this.insertDetailPS.executeUpdate();
                TvTarifficationManager.addAccountDelta(accountDeltaMap, key.serviceId, accountDelta.delta);
            }
            boolean nonZero = false;
            BigDecimal accountSum = BigDecimal.ZERO;
            for (Map.Entry entry : accountDeltaMap.entrySet()) {
                AccountDelta accountDelta = (AccountDelta)entry.getValue();
                if (BigDecimal.ZERO.compareTo(accountDelta.delta) == 0) continue;
                accountSum = accountSum.add(accountDelta.delta);
                nonZero = true;
                balanceDao.addContractAccount(contractId, yy, mm, ((Integer)entry.getKey()).intValue(), accountDelta.delta);
            }
            BigDecimal accountSumRound = nonZero ? accountSum.setScale(2, RoundingMode.HALF_EVEN) : accountSum;
            if (recalculate || accountSumRound != accountSum && accountSumRound.compareTo(accountSum) != 0) {
                BigDecimal bigDecimal = balanceDao.setBalanceAccount(contractId, contractRuntime.getSuperContractId(), yy, mm);
                if (this.balanceEP != null) {
                    this.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId, 2, yy, mm, bigDecimal));
                    continue;
                }
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId, 2, yy, mm, bigDecimal));
                continue;
            }
            if (!nonZero) continue;
            balanceDao.addBalanceAccount(contractId, contractRuntime.getSuperContractId(), yy, mm, accountSumRound);
            if (this.balanceEP != null) {
                this.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId, 1, yy, mm, accountSum));
                continue;
            }
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId, 1, yy, mm, accountSum));
        }
    }

    private boolean processActivation(boolean addAccount, AtomicReference<BigDecimal> balanceRef, BigDecimal limit, boolean error, Calendar date, TvServiceCost serviceCost, BigDecimal activationPrice, Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap) throws BGException {
        if (!(activationPrice == null || serviceCost.getServiceId() <= 0 && serviceCost.activationServiceId <= 0 || BigDecimal.ZERO.compareTo(activationPrice) == 0 || serviceCost.getProductItem() != null && serviceCost.getProductItem().activationTime.compareTo(serviceCost.getProductItem().productPeriodActivationTime) != 0)) {
            activationPrice = activationPrice.setScale(5, this.balanceRoundingMode);
            BigDecimal balance = balanceRef.get();
            if (balance != null) {
                BigDecimal newBalance = balance.subtract(activationPrice);
                if (newBalance.compareTo(limit) < 0) {
                    if (error) {
                        throw new BGException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                    }
                    return false;
                }
                balance = newBalance;
                balanceRef.set(balance);
            }
            if (productAccountDeltaMonthMap != null) {
                TvTarifficationManager.addProductAccountDelta(productAccountDeltaMonthMap, serviceCost.getProductId(), serviceCost.activationServiceId, date, activationPrice);
            }
        }
        return true;
    }

    private static boolean checkServiceAndCost(boolean activation, boolean period, boolean error, TvServiceCost serviceCost, BigDecimal cost, BigDecimal activationPrice) throws BGException {
        if (cost == null) {
            if (error) {
                throw new BGException("\u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
            }
            if (!activation && period) {
                try {
                    logger.error("Cost not found for productId:" + serviceCost.getProductId() + ", productSpecId:" + serviceCost.getProductItem().productSpecId + ", activationModeId:" + serviceCost.getProductItem().activationModeId);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return false;
        }
        if (serviceCost.getServiceId() <= 0 || serviceCost.getServiceId() <= 0 && serviceCost.activationServiceId <= 0 && activationPrice != null && BigDecimal.ZERO.compareTo(activationPrice) != 0) {
            if (error) {
                throw new BGException("\u0423\u0441\u043b\u0443\u0433\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
            }
            if (!activation && period) {
                try {
                    logger.error("Service not found for productId:" + serviceCost.getProductId() + ", productSpecId:" + serviceCost.getProductItem().productSpecId + ", activationModeId:" + serviceCost.getProductItem().activationModeId);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return false;
        }
        return true;
    }

    public static class AccountDelta {
        public BigDecimal delta;

        AccountDelta(BigDecimal delta) {
            this.delta = delta;
        }
    }

    public static class ProductAccountKey {
        public final int productId;
        public final int serviceId;
        public final int day;

        public ProductAccountKey(int productId, int serviceId, int day) {
            this.productId = productId;
            this.serviceId = serviceId;
            this.day = day;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.productId) + this.serviceId) + this.day;
        }

        public boolean equals(Object obj) {
            ProductAccountKey other = (ProductAccountKey)obj;
            return this.productId == other.productId && this.serviceId == other.serviceId && this.day == other.day;
        }
    }

    public static class MonthKey {
        public final int yy;
        public final int mm;

        public MonthKey(int yy, int mm) {
            this.yy = yy;
            this.mm = mm;
        }

        public int hashCode() {
            return 31 * (31 + this.mm) + this.yy;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            MonthKey other = (MonthKey)obj;
            return this.mm == other.mm && this.yy == other.yy;
        }
    }

    public static final class CalculateResult {
        private final TvTariffRequest req;
        private final BigDecimal balance;
        private final Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap;

        public CalculateResult(TvTariffRequest req, BigDecimal balance, Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap) {
            this.req = req;
            this.balance = balance;
            this.productAccountDeltaMonthMap = productAccountDeltaMonthMap;
        }

        public TvTariffRequest getReq() {
            return this.req;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public Map<MonthKey, Map<ProductAccountKey, AccountDelta>> getProductAccountDeltaMonthMap() {
            return this.productAccountDeltaMonthMap;
        }
    }
}

