/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.bean;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportConf;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.modules.reports.server.report.BGJsonReport;
import ru.bitel.bgbilling.modules.reports.server.report.BGReport;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BGReportUtils {
    private static Map<String, List<Report>> cacheReports = new HashMap<String, List<Report>>();
    private static final Comparator<BGPluginServer> pluginsComparator = new Comparator<BGPluginServer>(){

        @Override
        public int compare(BGPluginServer o1, BGPluginServer o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public static BGReport getReport(String id, Connection con, Connection conSlave, ModuleSetup moduleSetup, int userId, Logger log) throws Exception {
        BGReport report = null;
        File cfg = null;
        DynamicClass cfg_clazz = null;
        Document doc = null;
        try {
            String name_find = id + ".rep.xml";
            DynamicCodeDao dcd = new DynamicCodeDao(con);
            for (DynamicClass clazz : dcd.getDynamicClasses()) {
                String name = clazz.getResourceFileSimpleName();
                if (!name.equals(name_find)) continue;
                cfg = DynamicCodeDao.getClassFile((String)clazz.getClassName());
                cfg_clazz = clazz;
                break;
            }
            if (cfg == null) {
                cfg = new File("reports/" + id + ".rep.xml");
            }
            if (cfg.exists()) {
                doc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(cfg)), (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.EXCEPTION);
            }
        }
        catch (Exception e) {
            throw new BGException("error load config for report id=" + id, (Throwable)e);
        }
        String report_class = XMLUtils.selectText(doc, (String)"//report/@report_class");
        if (!Utils.isBlankString((String)report_class)) {
            log.debug("load report class=" + report_class);
            report = (BGReport)((Object)Utils.newInstance((String)report_class, BGReport.class));
            if (report == null) {
                throw new BGException("error load report class=" + report_class);
            }
            report.init(conSlave, (Preferences)moduleSetup, userId, id, cfg, null);
        } else {
            boolean isJavReport = false;
            boolean isJson = false;
            if (doc != null) {
                Element element = XMLUtils.selectElement((Node)doc, (String)"//report");
                isJavReport = element != null && "java".equals(element.getAttribute("type"));
                boolean bl = isJson = element != null && "true".equals(element.getAttribute("json"));
            }
            report = isJavReport ? (isJson ? new BGJsonReport() : new BGCSVReport()) : new BGJasperReport();
            report.init(conSlave, (Preferences)moduleSetup, userId, id, cfg, cfg_clazz);
        }
        return report;
    }

    public static void addRequestParams(BGReport report, HttpServletRequest request) {
        if (report != null) {
            HashMap<String, String> reportParams = new HashMap<String, String>();
            Map params = request.getParameterMap();
            for (String paramName : params.keySet()) {
                if (!paramName.startsWith("report_")) continue;
                reportParams.put(paramName.substring(7), request.getParameter(paramName));
            }
            report.setParams(reportParams);
        }
    }

    public static JSONArray getModuleAndPlugin(ModuleSetup moduleSetup, Connection con) throws Exception {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)BGReportUtils.getSeparator("\u042f\u0434\u0440\u043e"));
        jsonArray.put((Object)BGReportUtils.getItem("kernel", "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c", 0));
        ParameterMap custGroups = moduleSetup.subLined("reports.custom.groups", "custom:\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435");
        for (Map.Entry gr : custGroups.entrySet()) {
            jsonArray.put((Object)BGReportUtils.getItem((String)gr.getKey(), (String)gr.getValue(), 0));
        }
        File[] files = null;
        File folder = new File("reports/");
        files = folder.exists() && folder.isDirectory() ? folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getPath().endsWith(".rep.xml");
            }
        }) : new File[]{};
        ArrayList<DynamicClass> dynamicClasses = new ArrayList<DynamicClass>();
        DynamicCodeDao dcd = new DynamicCodeDao(con);
        for (Object clazz : dcd.getDynamicClasses()) {
            if (!clazz.getResourceFileSimpleName().endsWith(".rep.xml")) continue;
            dynamicClasses.add((DynamicClass)clazz);
        }
        ArrayList<BGModule> modules = new ArrayList<BGModule>();
        for (BGModule module : new ModuleManager(con).getModules(null)) {
            if (!BGReportUtils.hasReportFolder(module.getName(), files) && !BGReportUtils.hasReportDyn(module.getName(), dynamicClasses)) continue;
            modules.add(module);
        }
        if (modules.size() > 0) {
            jsonArray.put((Object)BGReportUtils.getSeparator("\u041c\u043e\u0434\u0443\u043b\u0438"));
            for (BGModule module : modules) {
                jsonArray.put((Object)BGReportUtils.getItem(module.getName(), module.getTitle(), module.getId()));
            }
        }
        ArrayList<BGPluginServer> plugins = new ArrayList<BGPluginServer>();
        for (BGPluginServer plugin : BGPluginManagerServer.getManager().getPluginsMap().values()) {
            if (!BGReportUtils.hasReportFolder(plugin.getId(), files) && !BGReportUtils.hasReportDyn(plugin.getId(), dynamicClasses)) continue;
            plugins.add(plugin);
        }
        if (plugins.size() > 0) {
            jsonArray.put((Object)BGReportUtils.getSeparator("\u041f\u043b\u0430\u0433\u0438\u043d\u044b"));
            Collections.sort(plugins, pluginsComparator);
            for (BGPluginServer plugin : plugins) {
                jsonArray.put((Object)BGReportUtils.getItem(plugin.getId(), plugin.getName(), 0));
            }
        }
        return jsonArray;
    }

    private static JSONObject getSeparator(String title) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"separator");
        json.put("title", (Object)title);
        return json;
    }

    private static JSONObject getItem(String module, String title, int moduleId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"item");
        json.put("module", (Object)module);
        json.put("title", (Object)title);
        json.put("moduleId", moduleId);
        return json;
    }

    private static boolean hasReportFolder(String module, File[] files) {
        return Stream.of(files).anyMatch(pathname -> pathname.getName().startsWith(module));
    }

    private static boolean hasReportDyn(String module, List<DynamicClass> dynamicClasses) throws BGException {
        for (DynamicClass clazz : dynamicClasses) {
            String name = clazz.getResourceFileSimpleName();
            if (!name.startsWith(module + "_")) continue;
            return true;
        }
        return false;
    }

    public static List<Report> getReports(String reportModule, Connection con) throws Exception {
        List<Report> reports;
        BGReportConf conf = (BGReportConf)Setup.getSetup().getConfig(0, BGReportConf.class);
        List<Report> list = reports = conf.cache ? cacheReports.get(reportModule) : null;
        if (reports == null) {
            reports = new ArrayList<Report>();
            File folder = new File("reports/");
            if (folder.exists() && folder.isDirectory()) {
                BGReportUtils.addReportFolder(folder, reportModule, reports);
            }
            BGReportUtils.addReportDyn(reportModule, reports, con);
            Collections.sort(reports, new Comparator<Report>(){

                @Override
                public int compare(Report o1, Report o2) {
                    return o1.title.compareTo(o2.title);
                }
            });
            cacheReports.put(reportModule, reports);
        }
        return reports;
    }

    public static void resetReportCache() {
        cacheReports = new HashMap<String, List<Report>>();
    }

    private static void addReportFolder(File folder, final String module, List<Report> reports) throws BGException {
        FileFilter infFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getPath().endsWith(".rep.xml") && pathname.getName().startsWith(module + "_");
            }
        };
        for (File f : folder.listFiles(infFilter)) {
            String name = f.getName();
            name = name.substring(0, name.length() - 8);
            BGReportUtils.addReportDoc(name, f, "folder", reports);
        }
    }

    private static void addReportDyn(String module, List<Report> reports, Connection con) throws Exception {
        DynamicCodeDao dcd = new DynamicCodeDao(con);
        for (DynamicClass clazz : dcd.getDynamicClasses()) {
            String name = clazz.getResourceFileSimpleName();
            if (!name.endsWith(".rep.xml") || !name.startsWith(module + "_")) continue;
            String simpleName = name.substring(0, name.lastIndexOf(".rep.xml"));
            BGReportUtils.addReportDoc(simpleName, DynamicCodeDao.getClassFile((String)clazz.getClassName()), "dyn", reports);
        }
    }

    private static void addReportDoc(String name, File file, String from, List<Report> reports) throws BGException {
        Document doc = null;
        try {
            doc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(file)), (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.EXCEPTION);
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0435 \u043e\u0442\u0447\u0435\u0442\u0430 " + name, (Throwable)e);
        }
        Element reportElement = doc.getDocumentElement();
        if (Utils.notBlankString((String)reportElement.getAttribute("title"))) {
            Report report = new Report();
            report.id = name;
            report.title = reportElement.getAttribute("title");
            report.params_class = XMLUtils.getAttribute((Element)reportElement, (String)"params_class", (String)"ru.bitel.bgbilling.modules.reports.client.modules.kernel.ReportParams_Default");
            report.report_class = reportElement.getAttribute("report_class");
            report.report_doc_url = reportElement.getAttribute("doc_url");
            report.type = reportElement.getAttribute("type");
            report.reportElement = reportElement;
            report.from = from;
            reports.add(report);
        }
    }

    public static class Report {
        public String id;
        public String type;
        public String title;
        public String params_class;
        public String report_class;
        public String report_doc_url;
        public Element reportElement;
        public String from;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

