/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.constructor;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.reports.client.constructor.FilterPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.GenerateReportOptions;
import ru.bitel.bgbilling.modules.reports.client.constructor.ParameterField;
import ru.bitel.bgbilling.modules.reports.client.include.FillableFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ModuleFilter;
import ru.bitel.bgbilling.modules.reports.client.include.RFAddress;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class ViewXmlReportPanel
extends BGUPanel {
    private final JTextArea data = new JTextArea();
    private Document document = null;
    private Element rootElement = null;
    private final Map<ReportFilter, Element> elements = new LinkedHashMap<ReportFilter, Element>();
    private final Map<String, String> fields = new LinkedHashMap<String, String>();
    private final XmlReportDocumentListener xmlReportDocumentListener;

    public ViewXmlReportPanel(Consumer<Void> reloadXmlReportDataListener) {
        this.xmlReportDocumentListener = new XmlReportDocumentListener(reloadXmlReportDataListener);
    }

    protected void jbInit() throws Exception {
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"XML \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043e\u0442\u0447\u0435\u0442\u0430");
        this.data.setColumns(50);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane(this.data), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.data.getDocument().addDocumentListener(this.xmlReportDocumentListener);
    }

    public void setData(GenerateReportOptions options) throws Exception {
        this.elements.clear();
        this.document = XMLUtils.newDocument();
        this.rootElement = this.document.createElement("report");
        this.rootElement.setAttribute("title", options.getReportTitle());
        this.rootElement.setAttribute("dyn_class", options.getProcessingClass());
        this.rootElement.setAttribute("type", "java");
        this.rootElement.setAttribute("scroll", options.isNeedScroll() ? "true" : "false");
        this.addFiltersToReportXml(this.document, this.rootElement, options);
        this.addReportFieldsToXml(this.document, this.rootElement, options.getFields());
        this.document.appendChild(this.rootElement);
        this.data.setText(XMLUtils.serializeToString((Node)this.document, (boolean)true));
    }

    private void addFiltersToReportXml(Document document, Element rootElement, GenerateReportOptions options) {
        List<FilterPanel> filters = options.getFilters();
        if (Utils.notEmptyCollection(filters)) {
            filters.forEach(reportFilterPanel -> {
                int moduleId;
                ReportFilter reportFilter = reportFilterPanel.getReportFilter();
                Element filterEl = document.createElement(reportFilter.getFilterTitle());
                filterEl.setAttribute("title", Utils.maskBlank((String)reportFilterPanel.getTitleField().getText(), (String)reportFilter.getGuiTitle()));
                if (reportFilter instanceof ModuleFilter && (moduleId = ((ModuleFilter)((Object)reportFilter)).getModuleId()) > 0) {
                    filterEl.setAttribute("mid", String.valueOf(moduleId));
                }
                int size = reportFilterPanel.getParameterFields().size();
                for (int i = 0; i < size; ++i) {
                    try {
                        ParameterField parameterField = reportFilterPanel.getParameterFields().get(i);
                        String parameterName = (String)parameterField.getField().get(reportFilter);
                        if (!Utils.notBlankString((String)parameterName)) continue;
                        String attrName = reportFilter instanceof RFAddress ? this.defineAddressFilterAttributeName(i) : "name" + (Serializable)(size > 1 ? Integer.valueOf(i + 1) : "");
                        filterEl.setAttribute(attrName, parameterName);
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                if (reportFilter instanceof FillableFilter) {
                    Map<String, String> fillableParameters = reportFilterPanel.getFillableParameters();
                    fillableParameters.forEach((id, value) -> {
                        Element element = document.createElement("item");
                        element.setAttribute("id", (String)id);
                        element.setAttribute("title", (String)value);
                        filterEl.appendChild(element);
                    });
                    ParameterField sqlField = reportFilterPanel.getSqlRequestField();
                    if (sqlField != null && Utils.notBlankString((String)sqlField.getText())) {
                        filterEl.setAttribute("sql", sqlField.getText());
                    }
                }
                rootElement.appendChild(filterEl);
                this.elements.put(reportFilter, filterEl);
            });
        }
    }

    private String defineAddressFilterAttributeName(int i) {
        switch (i) {
            case 0: {
                return "cityName";
            }
            case 1: {
                return "streetName";
            }
            case 2: {
                return "areaName";
            }
            case 3: {
                return "quarterName";
            }
            case 4: {
                return "houseName";
            }
        }
        return "";
    }

    private void addReportFieldsToXml(Document doc, Element rootElement, Map<String, String> fields) {
        this.fields.clear();
        this.fields.putAll(fields);
        if (this.fields.size() > 0) {
            Element fieldsEl = doc.createElement("fields");
            this.fields.forEach((id, name) -> {
                Element element = doc.createElement("item");
                element.setAttribute("id", (String)id);
                element.setAttribute("title", (String)name);
                fieldsEl.appendChild(element);
            });
            rootElement.appendChild(fieldsEl);
        }
    }

    private Document createNewDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
            return null;
        }
    }

    public Document generateDocumentFromXmlSource() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(IOUtils.toInputStream((String)this.data.getText(), (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void clear() {
        this.document = null;
        this.rootElement = null;
        this.elements.clear();
        this.fields.clear();
        this.data.setText("");
    }

    public String getXmlData() {
        return this.data.getText();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setRootElement(Element rootElement) {
        this.rootElement = rootElement;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    private final class XmlReportDocumentListener
    implements DocumentListener {
        private final Consumer<Void> reloadXmlReportDataListener;

        private XmlReportDocumentListener(Consumer<Void> reloadXmlReportDataListener) {
            this.reloadXmlReportDataListener = reloadXmlReportDataListener;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.reloadXmlReportDataListener.accept(null);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.reloadXmlReportDataListener.accept(null);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.reloadXmlReportDataListener.accept(null);
        }
    }
}

