/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.bean;

import bsh.Interpreter;
import bsh.TargetError;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportConf;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGMapCollectionDataSource;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGRSDataSource;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGXmlDataSource;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class BGReportTemplate
extends BGLogger {
    private static final Map<Object, JasperReport> reports = new HashMap<Object, JasperReport>();
    private static final Map<Object, Constructor<? extends ReportFiller>> javaConstructorsCache = new ConcurrentHashMap<Object, Constructor<? extends ReportFiller>>();
    private static final Map<Integer, String> months = new HashMap<Integer, String>();
    private static URI contextURI;
    private static final ParameterMap emptySetup;
    private static final Pattern patMM;
    private static final Pattern patYY;
    private static final Pattern patModuleMonth;
    private static final Pattern patMonth;
    private static final Pattern patDate;
    private static final Pattern patTime;
    private static final Pattern patDollar;

    public static JasperReport getJasperReport(URI uri) throws BGException {
        Setup setup = Setup.getSetup();
        if (setup == null) {
            setup = emptySetup;
        }
        return BGReportTemplate.getJasperReport((ParameterMap)setup, uri);
    }

    public static JasperReport getJasperReport(ParameterMap setup, URI uri) throws BGException {
        try {
            if (!uri.isAbsolute()) {
                uri = contextURI.resolve(uri);
            }
            return BGReportTemplate.getJasperReport(setup, uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 uri jasper-\u0448\u0430\u0431\u043b\u043e\u043d\u0430 (" + uri + ")", (Throwable)e);
        }
    }

    public static JasperReport getJasperReport(ParameterMap setup, URL url) throws BGException {
        JasperReport result;
        if (setup.getBoolean("reports.cache", true)) {
            result = reports.get(url);
            if (result == null) {
                result = BGReportTemplate.newJasperReport(setup, url);
                reports.put(url, result);
            }
        } else {
            result = BGReportTemplate.newJasperReport(setup, url);
        }
        return result;
    }

    private static JasperReport newJasperReport(ParameterMap setup, URL url) throws BGException {
        try {
            JasperDesign design = JRXmlLoader.load((InputStream)url.openStream());
            BGReportTemplate.prepareJasperDesign(setup, design);
            return JasperCompileManager.compileReport((JasperDesign)design);
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438\u043b\u0438 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 jasper-\u0448\u0430\u0431\u043b\u043e\u043d\u0430", (Throwable)e);
        }
    }

    public static void prepareJasperDesign(ParameterMap setup, JasperDesign design) {
        if ("1".equals(setup.get("reports.pdf.setdefault", "1"))) {
            DefaultJasperReportsContext jasperReportsContext = DefaultJasperReportsContext.getInstance();
            String pdfEncoding = setup.get("reports.pdf.default.encoding", jasperReportsContext.getProperty("net.sf.jasperreports.default.pdf.encoding"));
            String pdfFont = setup.get("reports.pdf.default.font", jasperReportsContext.getProperty("net.sf.jasperreports.default.pdf.font.name"));
            BGReportTemplate.prepareJasperDesign(design.getBackground(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getColumnFooter(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getColumnHeader(), pdfEncoding, pdfFont);
            JRGroup[] groups = design.getGroups();
            if (groups != null) {
                for (JRGroup group : groups) {
                    BGReportTemplate.prepareJasperDesign(group.getGroupHeaderSection(), pdfEncoding, pdfFont);
                    BGReportTemplate.prepareJasperDesign(group.getGroupFooterSection(), pdfEncoding, pdfFont);
                }
            }
            BGReportTemplate.prepareJasperDesign(design.getDetailSection(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getLastPageFooter(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getPageFooter(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getPageHeader(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getSummary(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getTitle(), pdfEncoding, pdfFont);
            BGReportTemplate.prepareJasperDesign(design.getNoData(), pdfEncoding, pdfFont);
        }
    }

    private static void prepareJasperDesign(JRSection section, String pdfEncoding, String pdfFont) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null) {
            for (JRBand band : bands) {
                BGReportTemplate.prepareJasperDesign(band, pdfEncoding, pdfFont);
            }
        }
    }

    private static void prepareJasperDesign(JRBand ee, String pdfEncoding, String pdfFont) {
        if (ee != null) {
            for (JRElement e : ee.getElements()) {
                JRFont ff;
                if (!(e instanceof JRFont) || (ff = (JRFont)e).isPdfEmbedded() || ff.getStyle() != null && Boolean.TRUE.equals(ff.getStyle().isPdfEmbedded())) continue;
                ff.setPdfEmbedded(Boolean.valueOf(true));
                ff.setPdfFontName(pdfFont);
                ff.setPdfEncoding(pdfEncoding);
            }
        }
    }

    public static void fillReportToStream(JasperReport report, BGReportFilter filter, Connection con, Document doc, OutputStream out) throws Exception {
        try {
            ReportResult result = BGReportTemplate.processReport(report, filter, con, doc);
            JasperFillManager.fillReportToStream((JasperReport)report, (OutputStream)out, result.params, (JRDataSource)result.dataSource);
        }
        catch (JRException e) {
            throw new Exception(e);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public static void fillReportToPdfStream(JasperReport report, BGReportFilter filter, Connection con, Document doc, OutputStream out) {
        try {
            ReportResult result = BGReportTemplate.processReport(report, filter, con, doc);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)report, result.params, (JRDataSource)result.dataSource);
            JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void fillReportToXlsStream(JasperReport report, BGReportFilter filter, Connection con, Document doc, OutputStream out) {
        try {
            ReportResult result = BGReportTemplate.processReport(report, filter, con, doc);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)report, result.params, (JRDataSource)result.dataSource);
            JRXlsExporter exporter = new JRXlsExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.exportReport();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void fillReportToPdfStream(List<JasperReport> reports, BGReportFilter filter, Connection con, Document doc, OutputStream out) {
        try {
            ArrayList<JasperPrint> prints = new ArrayList<JasperPrint>();
            for (JasperReport report : reports) {
                ReportResult result = BGReportTemplate.processReport(report, filter, con, doc);
                prints.add(JasperFillManager.fillReport((JasperReport)report, result.params, (JRDataSource)result.dataSource));
            }
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, prints);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
            exporter.exportReport();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void fillReportToStream(JasperReport report, BGReportFilter filter, Connection con, OutputStream out) throws Exception {
        BGReportTemplate.fillReportToStream(report, filter, con, null, out);
    }

    private static ReportResult processReport(JasperReport report, BGReportFilter filter, Connection con, Document doc) throws Exception {
        int mid = filter.getIntParam("mid", -1);
        if (report == null) {
            System.err.println("Reports: Report is null!");
            return null;
        }
        JRQuery query = report.getQuery();
        ReportResult result = BGReportTemplate.processQuery(report, report.getFields(), filter, query, con, doc, mid);
        result.params.put("_filter", filter);
        result.params.put("_months", months);
        return result;
    }

    private static ReportResult processQuery(JasperReport report, JRField[] fields, BGReportFilter filter, JRQuery query, Connection con, Document doc, int mid) throws Exception {
        ReportResult result = new ReportResult(mid);
        result.params = new HashMap<String, Object>();
        result.params.put("_document", doc);
        result.params.put("_fields", fields);
        if (query != null) {
            if ("bgbs".equalsIgnoreCase(query.getLanguage())) {
                Interpreter i = new Interpreter();
                i.getNameSpace().importCommands("/ru/bitel/bgbilling/kernel/script/server/bsh/commands");
                i.eval(query.getText());
                try {
                    i.getNameSpace().getGlobal(i).invokeMethod("fillReport", new Object[]{con, filter, result});
                }
                catch (TargetError e) {
                    Throwable throwable = e.getTarget();
                    if (throwable instanceof BGException) {
                        BGException bgtarget = (BGException)throwable;
                        throw bgtarget;
                    }
                    throw e;
                }
            } else if ("java".equalsIgnoreCase(query.getLanguage())) {
                BGReportConf conf = (BGReportConf)Setup.getSetup().getConfig(mid, BGReportConf.class);
                Constructor<? extends ReportFiller> c = null;
                if (conf.cache) {
                    c = javaConstructorsCache.get(query.getText());
                }
                if (c == null) {
                    ScriptEngine e = new ScriptEngineManager().getEngineByName("java");
                    Object obj = e.eval(query.getText());
                    Class<ReportFiller> clazz = obj.getClass().asSubclass(ReportFiller.class);
                    c = clazz.getDeclaredConstructor(new Class[0]);
                    c.setAccessible(true);
                    javaConstructorsCache.put(query.getText(), c);
                }
                ReportFiller filler = c.newInstance(new Object[0]);
                filler.fillReport(con, filter, result);
            } else if ("javascript".equalsIgnoreCase(query.getLanguage())) {
                ScriptEngine e = new ScriptEngineManager().getEngineByName("js");
                e.eval(query.getText());
                ReportFiller filler = ((Invocable)((Object)e)).getInterface(ReportFiller.class);
                filler.fillReport(con, filter, result);
            } else if ("sql".equalsIgnoreCase(query.getLanguage())) {
                String q = query.getText();
                q = BGReportTemplate.parseQuery(q, filter, mid);
                ResultSet rs = con.createStatement().executeQuery(q);
                result.setDataSource(new BGRSDataSource(rs));
            } else if ("xpath".equalsIgnoreCase(query.getLanguage()) && doc != null) {
                BGXmlDataSource ds = new BGXmlDataSource((Node)doc, query.getText(), fields);
                result.setDataSource((JRDataSource)ds);
                result.params.put("_xpath", ds);
            }
        }
        if (result.params == null) {
            result.params = new HashMap<String, Object>();
        }
        if (result.dataSource == null) {
            result.dataSource = new BGMapCollectionDataSource(null);
        }
        return result;
    }

    private static String parseQuery(String q, BGReportFilter f, int mid) {
        Object c;
        SimpleDateFormat mm;
        Calendar c2;
        String name;
        Matcher m = patMM.matcher(q);
        while (m.find()) {
            name = m.group(1);
            c2 = f.getCalendarParam(name);
            if (c2 != null) {
                mm = new SimpleDateFormat("MM");
                q = m.replaceFirst(mm.format(c2.getTime()));
            } else {
                q = m.replaceFirst("");
            }
            m = patMM.matcher(q);
        }
        m = patYY.matcher(q);
        while (m.find()) {
            name = m.group(1);
            c2 = f.getCalendarParam(name);
            if (c2 != null) {
                mm = new SimpleDateFormat("yyyy");
                q = m.replaceFirst(mm.format(c2.getTime()));
            } else {
                q = m.replaceFirst("");
            }
            m = patYY.matcher(q);
        }
        m = patModuleMonth.matcher(q);
        while (m.find()) {
            name = m.group(1);
            c2 = f.getCalendarParam(m.group(2));
            q = c2 != null ? m.replaceFirst(ServerUtils.getModuleMonthTableName((String)name, (Date)c2.getTime(), (int)mid)) : m.replaceFirst("");
            m = patModuleMonth.matcher(q);
        }
        m = patMonth.matcher(q);
        while (m.find()) {
            name = m.group(1);
            c2 = f.getCalendarParam(m.group(2));
            q = c2 != null ? m.replaceFirst(ServerUtils.getMonthTableName((String)name, (Date)c2.getTime())) : m.replaceFirst("");
            m = patMonth.matcher(q);
        }
        m = patDate.matcher(q);
        while (m.find()) {
            c = f.getCalendarParam(m.group(1));
            q = c != null ? m.replaceFirst(TimeUtils.convertCalendarToSqlDate((Calendar)c).toString()) : m.replaceFirst("");
            m = patDate.matcher(q);
        }
        m = patTime.matcher(q);
        while (m.find()) {
            c = f.getCalendarParam(m.group(1));
            q = c != null ? m.replaceFirst(TimeUtils.convertCalendarToTimestamp((Calendar)c).toString()) : m.replaceFirst("");
            m = patTime.matcher(q);
        }
        m = patDollar.matcher(q);
        while (m.find()) {
            c = f.getStringParam(m.group(1));
            q = c != null ? m.replaceFirst((String)c) : m.replaceFirst("");
            m = patDollar.matcher(q);
        }
        return q;
    }

    static {
        for (int i = 0; i < TimeUtils.monthNames.length; ++i) {
            months.put(i, TimeUtils.monthNames[i]);
        }
        contextURI = new File(".").toURI().normalize();
        emptySetup = new ParameterMap.DefaultParameterMap(Collections.emptyMap());
        patMM = Pattern.compile("\\$mm\\(\\s*(\\w+)\\s*\\)");
        patYY = Pattern.compile("\\$yy\\(\\s*(\\w+)\\s*\\)");
        patModuleMonth = Pattern.compile("\\$module_month_table\\(\\s*(\\w+)\\s*,\\s*(\\w+)\\s*\\)");
        patMonth = Pattern.compile("\\$month_table\\(\\s*(\\w+)\\s*,\\s*(\\w+)\\s*\\)");
        patDate = Pattern.compile("\\$date\\(\\s*(\\w+)\\s*\\)");
        patTime = Pattern.compile("\\$time\\(\\s*(\\w+)\\s*\\)");
        patDollar = Pattern.compile("\\$\\(\\s*([\\w\\.]+)\\s*\\)");
    }

    public static class ReportResult {
        protected JRDataSource dataSource;
        protected Map<String, Object> params;
        protected int mid;

        public ReportResult(int mid, JRDataSource dataSource, Map<String, Object> params) {
            this.dataSource = dataSource;
            this.params = params;
            this.mid = mid;
        }

        public ReportResult(int moduleId) {
            this.mid = moduleId;
        }

        public void setDataSource(JRDataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void setMid(int mid) {
            this.mid = mid;
        }

        public void setDataSource(Collection<Map<String, Object>> dataSource) {
            this.dataSource = new BGMapCollectionDataSource(dataSource);
        }

        public void setDataSource(ResultSet dataSource) {
            this.dataSource = new BGRSDataSource(dataSource);
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public String sql(String sql, BGReportFilter filter) {
            return BGReportTemplate.parseQuery(sql, filter, this.mid);
        }

        public JRDataSource createDataSource(ResultSet dataSource) {
            return new BGRSDataSource(dataSource);
        }

        public JRDataSource createDataSource(Collection<Map<String, Object>> dataSource) {
            return new BGMapCollectionDataSource(dataSource);
        }

        public int getMid() {
            return this.mid;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }
    }

    public static interface ReportFiller {
        public void fillReport(Connection var1, BGReportFilter var2, ReportResult var3) throws Exception;
    }
}

