/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.modules.npay.server.Recalculator;
import ru.bitel.bgbilling.modules.npay.server.bean.DebetStatusManageConfig;
import ru.bitel.bgbilling.modules.npay.server.bean.RecalculatorParameters;
import ru.bitel.bgbilling.modules.npay.server.task.Calculator;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DebetStatusManageLocker
extends TaskBase {
    private String email;
    private int status = 0;
    private Calendar startMonth;
    private PeriodicErrorManager errorManager;
    private Connection con;
    private Connection conSlave;
    private boolean checkAccountChanged = true;
    private ServerContext context;

    protected boolean initTask() {
        this.email = this.taskSetup.get("email", null);
        this.status = this.taskSetup.getInt("status", 0);
        return true;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c NPay. \u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0434\u0435\u0431\u0435\u0442\u043e\u0432\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeTask() {
        this.context = (ServerContext)ServerContext.get();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        List configKeys = Utils.toList((String)moduleSetup.get("debet.npay.keys", ""));
        if (configKeys.isEmpty()) {
            configKeys.add("");
        }
        Iterator iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            String configKey = (String)iterator.next();
            DebetStatusManageConfig config = new DebetStatusManageConfig((Preferences)moduleSetup, configKey);
            if (!config.isEnable()) {
                this.getLogger().info("Debet status manage is switch off in module config");
                return;
            }
            this.checkAccountChanged = config.isCheckAccountChanged();
            String TABLE_GROUPED_SUB_ACCOUNT = " _npay_debet_status_manage_locker_sub_account_" + this.moduleId + " ";
            String TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT = " _npay_debet_status_manage_locker_sub_and_independ_account_" + this.moduleId + " ";
            this.con = this.setup.getDBConnectionFromPool();
            this.conSlave = this.setup.getDBSlaveConnectionFromPool();
            try {
                BalanceUtils bu = new BalanceUtils(this.conSlave);
                try {
                    ResultSet rs;
                    int index;
                    ContractStatusDao contractStatusDao = new ContractStatusDao(this.con);
                    this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUB_ACCOUNT);
                    this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT);
                    String query = null;
                    this.startMonth = TimeUtils.getStartMonth((Calendar)this.getOperatingTime());
                    String moduleServices = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
                    Date currentDate = TimeUtils.convertCalendarToDate((Calendar)this.getOperatingTime());
                    this.errorManager = new PeriodicErrorManager(this.con);
                    this.errorManager.initErrorMessage(this.moduleId, "NPay", String.valueOf(this.moduleId), this.startMonth.getTime());
                    Calculator calculator = new Calculator();
                    calculator.setExecutingTime(this.getOperatingTime());
                    calculator.initTask(this.setup, 0, "mid=" + this.moduleId + "\nservice.set=" + config.getServiceSet());
                    calculator.setPreCalc(this.status);
                    calculator.setActiveFromDate(null);
                    calculator.startTask();
                    Map planAccountMap = calculator.getCostCache().getContractAccounts();
                    HashSet<Integer> cidsForClose = new HashSet<Integer>();
                    ContractLabelManager contractLabelManager = new ContractLabelManager(this.con);
                    StringBuilder report = new StringBuilder(1000);
                    query = "CREATE TEMPORARY TABLE " + TABLE_GROUPED_SUB_ACCOUNT + " (  `scid` int(11) NOT NULL, `summa` decimal(10,2) NOT NULL, PRIMARY KEY  (`scid` ) ) SELECT contract.scid AS scid, SUM(ROUND(account.summa,2)) AS summa FROM contract_account AS account INNER JOIN contract ON account.cid=contract.id WHERE account.yy=? AND account.mm=? AND account.sid IN (" + moduleServices + ") AND contract.sub_mode=0 AND contract.scid>0 GROUP BY contract.scid";
                    try (PreparedStatement psCreateTempTable = this.conSlave.prepareStatement(query);){
                        psCreateTempTable.setInt(1, this.startMonth.get(1));
                        psCreateTempTable.setInt(2, this.startMonth.get(2) + 1);
                        psCreateTempTable.executeUpdate();
                    }
                    query = "CREATE TEMPORARY TABLE " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT + " (  `cid` int(11) NOT NULL, `summa` decimal(10,2) NOT NULL, PRIMARY KEY  (`cid` ) ) SELECT contract.id AS cid, SUM(ROUND(account.summa,2)) AS summa FROM contract_account AS account INNER JOIN contract ON account.cid=contract.id WHERE account.yy=? AND account.mm=? AND account.sid IN (" + moduleServices + ") ";
                    if (!config.isProcessDependentSub()) {
                        query = query + " AND ( contract.scid<=0 OR (contract.sub_mode=1) )";
                    }
                    query = query + " GROUP BY contract.id";
                    psCreateTempTable = this.conSlave.prepareStatement(query);
                    try {
                        psCreateTempTable.setInt(1, this.startMonth.get(1));
                        psCreateTempTable.setInt(2, this.startMonth.get(2) + 1);
                        psCreateTempTable.executeUpdate();
                    }
                    finally {
                        if (psCreateTempTable != null) {
                            psCreateTempTable.close();
                        }
                    }
                    query = "SELECT DISTINCT contract.id, contract.scid, contract.sub_list, contract.sub_mode, contract.closesumma, contract.title, contract.gr, account.summa, sub_account.summa, contract.status  FROM contract INNER JOIN contract_module ON contract.id=contract_module.cid AND contract_module.mid=? LEFT JOIN " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT + " AS account ON contract.id=account.cid LEFT JOIN " + TABLE_GROUPED_SUB_ACCOUNT + " AS sub_account ON contract.id=sub_account.scid ";
                    if (Utils.notBlankString((String)config.getTariffIds())) {
                        String sqlDate = "'" + TimeUtils.format((Calendar)this.getOperatingTime(), (String)"yyyy-MM-dd") + "'";
                        query = query + "INNER JOIN contract_tariff ON contract.id=contract_tariff.cid AND contract_tariff.tpid IN (" + config.getTariffIds() + ") AND contract_tariff.date1<=" + sqlDate + "AND (contract_tariff.date2 IS NULL OR " + sqlDate + "<=contract_tariff.date2) ";
                    }
                    if (!config.getContractLabelIds().isEmpty()) {
                        query = query + "INNER JOIN contract_label_link ON contract.id=contract_label_link.contract_id AND contract_label_link.label_id IN (" + Utils.toString(config.getContractLabelIds()) + ") ";
                    }
                    String selectQuery = query + "WHERE contract.mode=1 AND contract.status IN (" + this.status + ") AND (contract.scid<=0 OR contract.sub_mode=1) AND (contract.date2 IS NULL OR ?<=contract.date2)";
                    try (PreparedStatement psSelect = this.conSlave.prepareStatement(selectQuery);){
                        index = 1;
                        psSelect.setInt(index++, this.moduleId);
                        psSelect.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)this.getOperatingTime()));
                        rs = psSelect.executeQuery();
                        try {
                            this.check(config, bu, planAccountMap, report, cidsForClose, currentDate, rs, false, contractStatusDao, contractLabelManager);
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    if (!config.isProcessDependentSub()) continue;
                    selectQuery = query + "WHERE contract.mode=1 AND contract.status IN (" + this.status + ") AND (contract.scid>0 AND contract.sub_mode=0) AND (contract.date2 IS NULL OR ?<=contract.date2)";
                    psSelect = this.conSlave.prepareStatement(selectQuery);
                    try {
                        index = 1;
                        psSelect.setInt(index++, this.moduleId);
                        psSelect.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)this.getOperatingTime()));
                        rs = psSelect.executeQuery();
                        try {
                            this.check(config, bu, planAccountMap, report, cidsForClose, currentDate, rs, true, contractStatusDao, contractLabelManager);
                            continue;
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                            continue;
                        }
                    }
                    finally {
                        if (psSelect == null) continue;
                        psSelect.close();
                        continue;
                    }
                }
                finally {
                    bu.close();
                    continue;
                }
            }
            catch (Exception e) {
                if (!this.errorManager.isCapReached()) {
                    String subject = e.getMessage();
                    String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430.";
                    this.errorManager.addErrorToList(subject, text, e);
                }
                this.getLogger().error(e.getMessage(), (Throwable)e);
                this.error = e;
                continue;
            }
            finally {
                try {
                    this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUB_ACCOUNT);
                    this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT);
                    this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                    this.errorManager.processErrors();
                    continue;
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                    this.error = e;
                    continue;
                }
                finally {
                    ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
                    continue;
                }
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(DebetStatusManageConfig config, BalanceUtils bu, Map<Integer, BigDecimal> planAccountMap, StringBuilder report, Set<Integer> cidsForClose, Date currentDate, ResultSet rs, boolean checkDuplicate, ContractStatusDao contractStatusDao, ContractLabelManager contractLabelManager) throws Exception {
        while (rs.next()) {
            try {
                int contractId = rs.getInt(1);
                int superId = rs.getInt(2);
                MDC.put((String)"contractId", (String)String.valueOf(contractId));
                MDC.put((String)"contractSuperId", (String)String.valueOf(superId));
                if (checkDuplicate && (cidsForClose.contains(contractId) || cidsForClose.contains(superId))) {
                    this.getLogger().debug("Skip subcontract...");
                    continue;
                }
                String subList = rs.getString(3);
                BigDecimal limit = Utils.maskNull((BigDecimal)rs.getBigDecimal(5));
                String title = rs.getString(6);
                BigDecimal accountSumma = Utils.maskNull((BigDecimal)rs.getBigDecimal(8));
                BigDecimal subSumma = rs.getBigDecimal(9);
                int oldStatus = rs.getInt(10);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("title = {}, subList = {}, oldStatus = {}", new Object[]{title, subList, oldStatus});
                    this.getLogger().debug("accountSumma = {}, subSumma = {}", (Object)accountSumma, (Object)subSumma);
                }
                if (subSumma != null && BigDecimal.ZERO.compareTo(subSumma) != 0) {
                    accountSumma = accountSumma.add(subSumma);
                }
                BigDecimal planAccount = Utils.maskNull((BigDecimal)planAccountMap.get(contractId));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("accountSumma = {}", (Object)accountSumma);
                    this.getLogger().debug("planAccount = {}", (Object)planAccount);
                }
                if (superId < 1) {
                    for (Integer dependSub : Utils.toIntegerList((String)subList)) {
                        BigDecimal subAccount = Utils.maskNull((BigDecimal)planAccountMap.get(dependSub));
                        planAccount = planAccount.add(subAccount);
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("planAccount: " + planAccount + ", accountSumma: " + accountSumma);
                }
                if (this.checkAccountChanged && planAccount.compareTo(accountSumma) <= 0) continue;
                BigDecimal diff = planAccount.subtract(accountSumma);
                BigDecimal balance = bu.getBalanceOut(currentDate, contractId);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("  balance: " + balance + ", diff: " + diff + ", limit: " + limit);
                }
                if (balance.subtract(diff).compareTo(limit) >= 0) continue;
                if (config.isEnableForContractLabelIds(contractLabelManager.getContractLabelIds(contractId))) {
                    cidsForClose.add(contractId);
                    ContractStatus status = new ContractStatus().setContractId(contractId).setStatus(config.getNextStatus(oldStatus)).setDateFrom(currentDate).setDateTo(null).setComment("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u043a \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u044b");
                    contractStatusDao.changeStatus(status, Integer.valueOf(0));
                    if (this.context != null) {
                        this.context.commit();
                    }
                    this.getLogger().info("Locked contract " + title + " balance: " + Utils.formatBigDecimalSumm((BigDecimal)balance) + "; currentAccount: " + Utils.formatBigDecimalSumm((BigDecimal)accountSumma) + "; planAccount: " + Utils.formatBigDecimalSumm((BigDecimal)planAccount));
                    RecalculatorParameters parameters = new RecalculatorParameters().setServiceSet(0).setContractIds(Arrays.asList(contractId)).setComment("\u041f\u0435\u0440\u0435\u0440\u0430\u0441\u0447\u0435\u0442 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442 \u043f\u043e\u0441\u043b\u0435 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430").setDetail(this.setup.getModuleSetup(Integer.valueOf(this.moduleId)).getBoolean("npay.recalculate.detail", true));
                    new Recalculator(this.moduleId, TimeUtils.convertDateToCalendar((Date)currentDate), parameters).init(this.setup).executeTask();
                    if (!Utils.notBlankString((String)this.email)) continue;
                    report.append(title);
                    report.append("\n");
                    continue;
                }
                this.getLogger().info("Skip locking contract (no enable for contract) " + title + " balance: " + Utils.formatBigDecimalSumm((BigDecimal)balance) + "; currentAccount: " + Utils.formatBigDecimalSumm((BigDecimal)accountSumma) + "; planAccount: " + Utils.formatBigDecimalSumm((BigDecimal)planAccount));
            }
            finally {
                MDC.remove((String)"contractId");
                MDC.remove((String)"contractSuperId");
            }
        }
    }

    public List<TaskParameter> taskParameters() {
        List taskParameters = super.taskParameters();
        taskParameters.add(new TaskParameter().setKey("email").setTitle("email").setDefaultValue(""));
        taskParameters.add(new TaskParameter().setKey("status").setTitle("status").setDefaultValue("0"));
        return taskParameters;
    }
}

