/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.MobiServiceCode;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mobimoney.common.service.MobiService;
import ru.bitel.bgbilling.modules.mobimoney.server.bean.TransactionManager;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mobimoney.common.service.MobiService")
public class MobiServiceImpl
extends AbstractService
implements MobiService {
    public SearchResult<Transaction> searchTransactions(int contractId, String contractTitle, String status, PeriodWithTime period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        new TransactionManager(this.getConnection(), this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, contractId, contractTitle, status);
        return searchResult;
    }

    public Transaction getTransaction(String mobiPaymentId) throws Exception {
        return new TransactionManager(this.getConnection(), this.moduleId).getTransaction(mobiPaymentId);
    }

    public void updateTransaction(Transaction transaction) throws Exception {
        TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
        if (transaction.getId() > 0) {
            transactionManager.updateTransaction(transaction);
        } else {
            transactionManager.addTransaction(transaction);
        }
    }

    public void checkStatus(Transaction transaction) throws Exception {
    }

    public int checkContract(String contractTitle) throws Exception {
        int result = -1;
        Connection con = this.getConnection();
        try (ContractDao contractDao = new ContractDao(con, this.userId);){
            Contract contract = contractDao.getByTitle(contractTitle);
            if (contract != null && new ContractModuleManager(con).getContractModuleSet(contract.getId()).contains(this.moduleId)) {
                result = contract.getId();
            }
        }
        return result;
    }

    public boolean checkPayment(int contractId, String mobiPaymentId) throws Exception {
        return new TransactionManager(this.getConnection(), this.moduleId).checkPayment(contractId, mobiPaymentId);
    }

    public List<MobiServiceCode> getServiceCodeList() throws Exception {
        return new TransactionManager(this.getConnection(), this.moduleId).getServiceCodeList();
    }

    public int updateServiceCode(MobiServiceCode mobiServiceCode) throws Exception {
        new TransactionManager(this.getConnection(), this.moduleId).updateServiceCode(mobiServiceCode);
        return mobiServiceCode == null ? 0 : mobiServiceCode.getId();
    }

    public void deleteServiceCode(List<Integer> ids) throws Exception {
        new TransactionManager(this.getConnection(), this.moduleId).deleteServiceCode(ids);
    }
}

