/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoFee;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class MangoFeeDao
extends AbstractIdDao<MangoFee> {
    public MangoFeeDao(Connection con, int moduleId, Date date) {
        super(con, moduleId, "mango_fee", date);
    }

    public void checkAndCreateTable(Setup setup) {
        String createQuery = "CREATE TABLE " + this.tableName + " ( id INT UNSIGNED NOT NULL,control VARCHAR(20) NOT NULL,productId INT NOT NULL,serviceId INT NOT NULL,date DATETIME NOT NULL,sum DECIMAL(10,2) NOT NULL,day INT NOT NULL,UNIQUE KEY id (`id`),INDEX `control` (`control`),INDEX `day` (`day`) )";
        ServerUtils.checkAndCreatePeriodicTableName((Connection)this.con, (String)this.tableName, (String)createQuery);
    }

    public List<MangoFee> getListMangoFee(String control) throws SQLException {
        if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return this.list("control=?", null, new Object[]{control});
        }
        return Collections.emptyList();
    }

    public int deleteByDay(int day) throws SQLException {
        return this.delete("day=?", new Object[]{day});
    }

    public void insertList(List<MangoFee> list) throws SQLException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (MangoFee fee : list) {
            this.update(fee);
        }
    }

    public List<MangoFee> aggregatedByService() throws SQLException {
        ArrayList<MangoFee> list = new ArrayList<MangoFee>();
        String query = "SELECT control, serviceId, SUM(sum) as sum FROM " + this.tableName + " GROUP BY control, serviceId";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                MangoFee agrFee = new MangoFee();
                agrFee.setControl(rs.getString("control"));
                agrFee.setServiceId(rs.getInt("serviceId"));
                agrFee.setSum(rs.getBigDecimal("sum"));
                list.add(agrFee);
            }
        }
        return list;
    }

    protected void updateImpl(MangoFee mangoFee) throws SQLException {
        Objects.requireNonNull(mangoFee);
        if (mangoFee.getId() < 1) {
            return;
        }
        String query = "INSERT INTO " + this.tableName + " SET id=?, control=?, productId=?, serviceId=?, date=?, sum=?, day=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, mangoFee.getId());
            ps.setString(index++, mangoFee.getControl());
            ps.setInt(index++, mangoFee.getProductId());
            ps.setInt(index++, mangoFee.getServiceId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)mangoFee.getDate()));
            ps.setBigDecimal(index++, mangoFee.getSum());
            ps.setInt(index++, mangoFee.getDay());
            ps.executeUpdate();
        }
    }

    protected MangoFee getFromRS(ResultSet rs) throws SQLException {
        MangoFee fee = new MangoFee();
        fee.setId(rs.getInt("id"));
        fee.setControl(rs.getString("control"));
        fee.setProductId(rs.getInt("productId"));
        fee.setServiceId(rs.getInt("serviceId"));
        fee.setDate((Date)rs.getTimestamp("date"));
        fee.setSum(rs.getBigDecimal("sum"));
        fee.setDay(rs.getInt("day"));
        return fee;
    }
}

