/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class TransactionUtils {
    public static void addPaymentWithCommissionInContract(Connection con, BGAbstractTransaction transaction, int moduleId, int paymentTypeId, String paymentComment, int commissionType, int commissionTypeId, BigDecimal commissionPercent, String commissionComment) throws Exception {
        Payment payment = TransactionUtils.addPaymentInContract(con, transaction, moduleId, paymentTypeId, paymentComment);
        Charge charge = TransactionUtils.addCommissionInContract(con, transaction, commissionType, commissionTypeId, commissionPercent, payment.getDate(), commissionComment);
        TransactionUtils.updateContractBalance(con, transaction, payment, charge);
    }

    public static void addPaymentWithoutCommissionInContract(Connection con, BGAbstractTransaction transaction, int moduleId, int paymentTypeId, String paymentComment) throws Exception {
        Payment payment = TransactionUtils.addPaymentInContract(con, transaction, moduleId, paymentTypeId, paymentComment);
        TransactionUtils.updateContractBalance(con, transaction, payment, null);
    }

    private static Payment addPaymentInContract(Connection con, BGAbstractTransaction transaction, int moduleId, int paymentTypeId, String paymentComment) throws Exception {
        Date paymentDate = transaction.getTransactionDate();
        if (paymentDate == null) {
            paymentDate = new Date();
            transaction.setTransactionDate(paymentDate);
        }
        Payment payment = Payment.builder().setDate(paymentDate).setTypeId(paymentTypeId).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(moduleId).setTransactionId(String.valueOf(transaction.getId())).setComment(paymentComment).build();
        new PaymentDao(con).update(payment);
        transaction.setPaymentId(payment.getId());
        return payment;
    }

    private static Charge addCommissionInContract(Connection con, BGAbstractTransaction transaction, int commissionType, int commissionTypeId, BigDecimal commissionPercent, Date paymentDate, String commissionComment) throws Exception {
        Charge charge = null;
        BigDecimal percent = null;
        BigDecimal summa = null;
        if (commissionType == 3) {
            percent = new BigDecimal(100).subtract(commissionPercent).divide(new BigDecimal(100));
            summa = transaction.getSum().multiply(percent);
        } else if (commissionType > 0) {
            percent = commissionPercent.divide(new BigDecimal(100)).add(new BigDecimal(1));
            summa = transaction.getSum().divide(percent, RoundingMode.HALF_UP);
        }
        if (commissionType != 0) {
            summa = transaction.getSum().subtract(summa);
            charge = Charge.builder().setContractId(transaction.getContractId()).setComment(commissionComment).setTypeId(commissionTypeId).setSum(summa).setDate(paymentDate).build();
            new ChargeDao(con).update(charge);
        }
        return charge;
    }

    private static void updateContractBalance(Connection con, BGAbstractTransaction transaction, Payment payment, Charge charge) throws BGException {
        ServerUtils.commitConnection(con);
        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
            balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
        }
        ServerUtils.commitConnection(con);
        EventProcessor.getInstance().publish(new PaymentEvent(0, payment));
        EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
        if (charge != null) {
            EventProcessor.getInstance().publish(new ChargeEvent(0, charge));
            EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(transaction.getContractId(), 4, charge.getSum()));
        }
    }
}

