/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import bitel.billing.server.util.Config;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.emuns.BGEntityType;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusLogDao;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractObjectStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractObjectStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractSetStatusLogicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangingEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskStatus;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskType;
import ru.bitel.bgbilling.kernel.task.server.bean.BGFutureTaskDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.worker.ThreadContext;

public class ContractStatusDao
extends AbstractIdDao<ContractStatus> {
    private final ServerContext context;
    private final EventProcessor ep;

    public ContractStatusDao(Connection con) {
        super(con, 0, "contract_status");
        ThreadContext context = ThreadContext.get();
        this.context = context instanceof ServerContext ? (ServerContext)context : null;
        this.ep = EventProcessor.getInstance();
    }

    protected ContractStatus getFromRS(ResultSet rs) throws SQLException {
        return new ContractStatus().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setObjectId(rs.getInt("object_id")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setStatus(rs.getInt("status")).setComment(rs.getString("comment"));
    }

    protected void updateImpl(ContractStatus status) throws SQLException {
        Objects.requireNonNull(status);
        boolean update = status.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET date1=?, date2=?, status=?, comment=?" + (update ? " WHERE id=?" : ", cid=?, object_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 0;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateTo()));
            ps.setInt(index++, status.getStatus());
            ps.setString(index++, status.getComment());
            if (update) {
                ps.setInt(index++, status.getId());
            } else {
                ps.setInt(index++, status.getContractId());
                ps.setInt(index++, status.getObjectId());
            }
            ps.executeUpdate();
            if (!update) {
                status.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public ContractStatus getStatus(int contractId, LocalDate date) throws SQLException {
        return this.getStatus(contractId, 0, date);
    }

    public ContractStatus getStatus(int contractId, int objectId, LocalDate date) throws SQLException {
        ContractStatus result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND (object_id=0 " + (objectId > 0 ? " OR object_id=?" : "") + ") AND date1<=? AND (date2 IS NULL OR date2>=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Date sqlDate = TimeUtils.convertLocalDateToSqlDate((LocalDate)date);
            int index = 1;
            ps.setInt(index++, contractId);
            if (objectId > 0) {
                ps.setInt(index++, objectId);
            }
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            try (ResultSet rs = ps.executeQuery();){
                ContractStatus contractStatus = null;
                ContractStatus objectStatus = null;
                while (rs.next()) {
                    ContractStatus status = this.getFromRS(rs);
                    if (status.getObjectId() > 0) {
                        objectStatus = status;
                        continue;
                    }
                    contractStatus = status;
                }
                result = objectStatus != null ? objectStatus : contractStatus;
            }
        }
        return result;
    }

    public List<ContractStatus> getStatusList(int contractId, java.util.Date date) throws BGException {
        return this.getStatusList(contractId, 0, date);
    }

    public List<ContractStatus> getStatusList(int contractId, int objectId, java.util.Date date) throws BGException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND object_id=? AND (date2 IS NULL OR ?<=date2) ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, objectId);
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Map<Integer, List<ContractStatus>> getContractStatusListMap(java.util.Date date) throws SQLException {
        HashMap<Integer, List<ContractStatus>> result = new HashMap<Integer, List<ContractStatus>>();
        String query = "SELECT * FROM " + this.tableName + " WHERE object_id=0 AND (date2 IS NULL OR ?<=date2) ORDER BY cid, date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)date));
            try (ResultSet rs = ps.executeQuery();){
                int curContractId = 0;
                ArrayList<ContractStatus> list = new ArrayList<ContractStatus>();
                while (rs.next()) {
                    ContractStatus contractStatus = this.getFromRS(rs);
                    if (curContractId != contractStatus.getContractId()) {
                        curContractId = contractStatus.getContractId();
                        list = new ArrayList();
                        result.put(curContractId, list);
                    }
                    list.add(contractStatus);
                }
            }
        }
        return result;
    }

    public List<ContractStatus> getStatusList(int contractId) throws SQLException {
        return this.list("cid=? AND object_id=0", "date1", new Object[]{contractId});
    }

    public List<ContractStatus> getStatusList(int contractId, int objectId) throws SQLException {
        Object[] objectArray;
        String string = "cid=? AND (object_id=0 " + (objectId > 0 ? " OR object_id=?" : "") + ")";
        if (objectId > 0) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = contractId;
            objectArray = objectArray2;
            objectArray2[1] = objectId;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = contractId;
        }
        return this.list(string, "date1", objectArray);
    }

    public void searchContractStatus(SearchResult<ContractStatus> searchResult, int contractId, int objectId) throws SQLException {
        Result result = this.list(searchResult.getPage(), "cid=? AND object_id=?", "date1 desc", new Object[]{contractId, objectId});
        searchResult.setList(result.getList());
        searchResult.setPage(result.getPage());
    }

    public List<ContractStatus> list(int contractId, LocalDate date) throws SQLException {
        return this.list(contractId, 0, date);
    }

    public List<ContractStatus> list(int contractId, int objectId, LocalDate date) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        boolean useDate = date != null;
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND ( object_id=0 " + (objectId > 0 ? " OR object_id=?" : "") + " ) " + (useDate ? " AND (date2 IS NULL OR ?<=date2)" : "") + " ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            if (objectId > 0) {
                ps.setInt(index++, objectId);
            }
            if (useDate) {
                ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)date));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }

    public List<ContractStatus> getStatusListAfterDate(int contractId, Calendar date) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND object_id=0 AND date1>? ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }

    public void setContractStatus(ContractStatus status) throws SQLException {
        String query = "UPDATE contract SET status=?, status_date=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, status.getStatus());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateFrom()));
            ps.setInt(3, status.getContractId());
            ps.executeUpdate();
        }
    }

    public void setContractObjectStatus(ContractStatus status) throws SQLException {
        String query = "UPDATE `object` SET status=?, status_date=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, status.getStatus());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateFrom()));
            ps.setInt(3, status.getObjectId());
            ps.executeUpdate();
        }
    }

    public static boolean isStatusPeriodValid(ContractStatus status) {
        return status.getDateFrom() != null && (status.getDateTo() == null || TimeUtils.dateBeforeOrEq((java.util.Date)status.getDateFrom(), (java.util.Date)status.getDateTo()));
    }

    public void changeStatus(ContractStatus newStatus, Integer userId) throws Exception {
        this.changeStatus(newStatus, userId, true);
    }

    public void changeStatus(ContractStatus newStatus, Integer userId, boolean processEvent) throws Exception {
        Contract contract;
        Objects.requireNonNull(newStatus);
        LocalDate now = LocalDate.now();
        LocalDate statusFrom = TimeUtils.convertDateToLocalDate((java.util.Date)newStatus.getDateFrom());
        LocalDate statusTo = TimeUtils.convertDateToLocalDate((java.util.Date)newStatus.getDateTo());
        if (statusTo == null || !statusTo.isBefore(now)) {
            this.addFutureStatusTask(newStatus, userId);
        }
        if (!(statusFrom != null && statusFrom.isAfter(now) || statusTo != null && !statusTo.isAfter(now))) {
            newStatus.setDateTo(null);
        }
        if (statusFrom != null && statusFrom.isAfter(now)) {
            return;
        }
        userId = userId != null ? userId : 0;
        boolean useEventSetStatusLogic = Setup.getSetup().getBoolean("use.event.set.status.logic", false);
        ContractStatus originalStatus = newStatus.clone();
        newStatus = newStatus.clone();
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            contract = (Contract)contractDao.get(originalStatus.getContractId());
            if (contract == null) {
                return;
            }
        }
        GregorianCalendar prevDay = new GregorianCalendar();
        prevDay.setTime(originalStatus.getDateFrom());
        ((Calendar)prevDay).add(5, -1);
        GregorianCalendar nextDay = null;
        if (originalStatus.getDateTo() != null) {
            nextDay = new GregorianCalendar();
            nextDay.setTime(originalStatus.getDateTo());
            ((Calendar)nextDay).add(6, 1);
        }
        ArrayList<ContractStatus> statusList = new ArrayList<ContractStatus>();
        ContractStatusDao contractStatusDao = new ContractStatusDao(this.con);
        statusList.addAll(contractStatusDao.getStatusList(originalStatus.getContractId(), originalStatus.getObjectId(), originalStatus.getDateFrom()));
        for (ContractStatus status : statusList) {
            if (!ContractStatusDao.isStatusPeriodValid(newStatus)) break;
            if (useEventSetStatusLogic) {
                ContractSetStatusLogicEvent contractSetStatusLogicEvent = new ContractSetStatusLogicEvent((int)userId, status, newStatus, originalStatus);
                contractSetStatusLogicEvent = EventProcessor.getInstance().request(contractSetStatusLogicEvent);
                if (contractSetStatusLogicEvent.isProcessed()) continue;
            }
            if (newStatus.getDateFrom() != null && status.getDateTo() != null && !TimeUtils.dateBeforeOrEq((java.util.Date)newStatus.getDateFrom(), (java.util.Date)status.getDateTo()) || newStatus.getDateTo() != null && status.getDateFrom() != null && !TimeUtils.dateBeforeOrEq((java.util.Date)status.getDateFrom(), (java.util.Date)newStatus.getDateTo())) continue;
            if (TimeUtils.dateBeforeOrEq((java.util.Date)newStatus.getDateFrom(), (java.util.Date)status.getDateFrom()) && (newStatus.getDateTo() == null || status.getDateTo() != null && TimeUtils.dateBeforeOrEq((java.util.Date)status.getDateTo(), (java.util.Date)newStatus.getDateTo()))) {
                this.deleteStatus(status, userId);
                continue;
            }
            if (newStatus.getDateTo() != null && TimeUtils.periodInRange((java.util.Date)newStatus.getDateFrom(), (java.util.Date)newStatus.getDateTo(), (java.util.Date)status.getDateFrom(), (java.util.Date)status.getDateTo())) {
                ContractStatus nextStatus = status.clone();
                nextStatus.setDateFrom(nextDay.getTime());
                if (ContractStatusDao.isStatusPeriodValid(nextStatus)) {
                    this.updateStatus(nextStatus, userId);
                }
                status.setDateTo(prevDay.getTime());
                this.doByPeriod(status, userId);
                continue;
            }
            if (newStatus.getDateTo() != null && TimeUtils.dateInRange((java.util.Date)status.getDateFrom(), (java.util.Date)newStatus.getDateFrom(), (java.util.Date)newStatus.getDateTo())) {
                status.setDateFrom(nextDay.getTime());
                this.doByPeriod(status, userId);
                continue;
            }
            if (status.getDateTo() != null && !TimeUtils.dateInRange((java.util.Date)status.getDateTo(), (java.util.Date)newStatus.getDateFrom(), (java.util.Date)newStatus.getDateTo())) continue;
            status.setDateTo(prevDay.getTime());
            this.doByPeriod(status, userId);
        }
        ContractStatus statusEvent = new ContractStatus().setContractId(newStatus.getContractId()).setObjectId(newStatus.getObjectId()).setDateFrom(newStatus.getDateFrom()).setDateTo(newStatus.getDateTo()).setStatus(newStatus.getStatus()).setComment(newStatus.getComment());
        if (processEvent) {
            EventProcessor.getInstance().request(new ContractStatusChangingEvent((int)userId, statusEvent, originalStatus));
        }
        if (ContractStatusDao.isStatusPeriodValid(statusEvent) && (statusEvent.getObjectId() <= 0 || statusEvent.getStatus() != -1)) {
            this.updateStatus(statusEvent, userId);
        }
        java.util.Date date = new java.util.Date();
        if (TimeUtils.dateBeforeOrEq((java.util.Date)statusEvent.getDateFrom(), (java.util.Date)date) && (statusEvent.getDateTo() == null || TimeUtils.dateBeforeOrEq((java.util.Date)date, (java.util.Date)statusEvent.getDateTo()))) {
            if (statusEvent.getObjectId() == 0) {
                contractStatusDao.setContractStatus(statusEvent);
                if (processEvent) {
                    EventProcessor.getInstance().publishAfterCommit(new ContractStatusChangedEvent(statusEvent, userId));
                    EventProcessor.getInstance().publishAfterCommit(new ContractStatusChangedTopicEvent(statusEvent, userId));
                }
            } else {
                contractStatusDao.setContractObjectStatus(statusEvent);
                if (processEvent) {
                    EventProcessor.getInstance().publishAfterCommit(new ContractObjectStatusChangedEvent(statusEvent, userId));
                    EventProcessor.getInstance().publishAfterCommit(new ContractObjectStatusChangedTopicEvent(statusEvent, userId));
                }
            }
        }
        ContractStatusLog log = ContractStatusLog.builder().setDate(new java.util.Date()).setContractId(originalStatus.getContractId()).setObjectId(originalStatus.getObjectId()).setComment(originalStatus.getComment()).setUserId(userId).setStatus(originalStatus.getStatus()).setDate1(originalStatus.getDateFrom()).setDate2(originalStatus.getDateTo()).build();
        if (originalStatus.getStatus() != statusEvent.getStatus() || statusEvent.getDateFrom() == null || originalStatus.getDateFrom().getTime() != statusEvent.getDateFrom().getTime() || originalStatus.getDateTo() == null && statusEvent.getDateTo() != null || originalStatus.getDateTo() != null && statusEvent.getDateTo() == null || originalStatus.getDateTo() != null && statusEvent.getDateTo() != null && originalStatus.getDateTo().getTime() != statusEvent.getDateTo().getTime()) {
            log.setComment(log.getComment() + "; \u0441\u0442\u0430\u0442\u0443\u0441 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f (\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u043a: " + TimeUtils.formatDate((java.util.Date)statusEvent.getDateFrom()) + "-" + TimeUtils.formatDate((java.util.Date)statusEvent.getDateTo()) + ":" + StatusCache.getInstance().getStatusTitle(statusEvent.getStatus()) + ")");
            if (!ContractStatusDao.isStatusPeriodValid(statusEvent)) {
                log.setComment(log.getComment() + "(\u0442.\u0435. \u0432\u044b\u0440\u043e\u0434\u0438\u043b\u0441\u044f)");
            }
        }
        if (!originalStatus.getComment().equals(statusEvent.getComment())) {
            log.setComment(log.getComment() + "; \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f: \"" + statusEvent.getComment() + "\"");
        }
        this.saveLog(log);
        if (contract.isSuper()) {
            ContractStatusManagerConf conf = Setup.getSetup().getConfig(0, ContractStatusManagerConf.class);
            if (conf.dependSubContractStatusChange) {
                Iterator iterator = Utils.toIntegerList((String)contract.getDependSubList()).iterator();
                while (iterator.hasNext()) {
                    int subId = (Integer)iterator.next();
                    originalStatus.setContractId(subId);
                    this.changeStatus(originalStatus, userId, processEvent);
                }
            }
            if (conf.independSubContractStatusChange) {
                try (ContractDao contractDao = new ContractDao(this.con, 0);){
                    for (Contract contr : contractDao.getSubContracts(contract.getId(), 1)) {
                        originalStatus.setContractId(contr.getId());
                        this.changeStatus(originalStatus, userId, processEvent);
                    }
                }
            }
        }
    }

    private void addFutureStatusTask(ContractStatus newStatus, int userId) throws Exception {
        List<BGFutureTask> futureTasks;
        LocalDate now = LocalDate.now();
        LocalDate statusFrom = TimeUtils.convertDateToLocalDate((java.util.Date)newStatus.getDateFrom());
        LocalDate statusTo = TimeUtils.convertDateToLocalDate((java.util.Date)newStatus.getDateTo());
        BGFutureTaskDao futureTaskDao = new BGFutureTaskDao(this.con);
        if ((statusFrom == null || statusFrom.isBefore(now.plusDays(1L))) && statusTo != null && statusTo.isAfter(now.minusDays(1L))) {
            futureTasks = futureTaskDao.list(0, BGFutureTaskType.CONTRACT_STATUS, BGEntityType.CONTRACT, newStatus.getContractId(), BGFutureTaskStatus.ACTIVE);
            int taskId = futureTasks.stream().filter(a -> a.getStartTime().toLocalDate().isEqual(statusTo.plusDays(1L))).findFirst().map(a -> a.getId()).orElse(0);
            if (taskId > 0) {
                futureTaskDao.cancel(BGFutureTaskType.CONTRACT_STATUS, taskId);
                return;
            }
            int status = StatusCache.getInstance().getDefaultStatus();
            if (statusFrom != null) {
                status = Optional.ofNullable(this.getStatus(newStatus.getContractId(), statusFrom.minusDays(1L))).map(a -> a.getStatus()).orElse(status);
            }
            ContractStatus contractStatus = newStatus.clone();
            contractStatus.setStatus(status);
            contractStatus.setDateFrom(TimeUtils.convertLocalDateToDate((LocalDate)statusTo.plusDays(1L)));
            contractStatus.setDateTo(null);
            BGFutureTask futureTask = BGFutureTask.builder().setModuleId(0).setEntityType(BGEntityType.CONTRACT).setEntityId(contractStatus.getContractId()).setCreateTime(LocalDateTime.now()).setCreateUserId(userId).setType(BGFutureTaskType.CONTRACT_STATUS).setStartTime(TimeUtils.convertDateToLocalDateTime((java.util.Date)contractStatus.getDateFrom())).setData(contractStatus.toJson().toString()).build();
            futureTaskDao.update((Object)futureTask);
        }
        if (statusFrom != null && statusFrom.isAfter(now)) {
            futureTasks = futureTaskDao.list(0, BGFutureTaskType.CONTRACT_STATUS, BGEntityType.CONTRACT, newStatus.getContractId(), BGFutureTaskStatus.ACTIVE);
            futureTasks = futureTasks.stream().filter(a -> a.getStartTime().toLocalDate().isEqual(statusFrom)).toList();
            futureTaskDao.cancel(BGFutureTaskType.CONTRACT_STATUS, futureTasks.stream().map(a -> a.getId()).toList());
            BGFutureTask futureTask = BGFutureTask.builder().setModuleId(0).setEntityType(BGEntityType.CONTRACT).setEntityId(newStatus.getContractId()).setCreateTime(LocalDateTime.now()).setCreateUserId(userId).setType(BGFutureTaskType.CONTRACT_STATUS).setStartTime(TimeUtils.convertDateToLocalDateTime((java.util.Date)newStatus.getDateFrom())).setData(newStatus.toJson().toString()).build();
            futureTaskDao.update((Object)futureTask);
        }
    }

    public List<ContractStatus> getStatusList(int contractId, Set<Integer> statuses, java.util.Date startMonth, java.util.Date endMonth) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        String query = "SELECT status.id, status.date1, status.date2 FROM " + this.tableName + " AS status WHERE status.cid=? AND status.object_id=0" + (String)(statuses != null && !statuses.isEmpty() ? " AND status.status IN (" + Utils.toString(statuses) + ")" : "") + " AND (? IS NULL OR status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) ORDER BY status.date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int i = 1;
            Date endMonthSql = TimeUtils.convertDateToSqlDate((java.util.Date)endMonth);
            ps.setInt(i++, contractId);
            ps.setDate(i++, endMonthSql);
            ps.setDate(i++, endMonthSql);
            ps.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)startMonth));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new ContractStatus().setId(rs.getInt(1)).setDateFrom(rs.getDate(2)).setDateTo(rs.getDate(3)));
                }
            }
        }
        result.trimToSize();
        return result;
    }

    public List<Period> getPeriodList(int contractId, int objectId, Set<Integer> statuses, java.util.Date startMonth, java.util.Date endMonth) throws SQLException {
        ArrayList<Period> result = new ArrayList<Period>();
        String query = "SELECT status.date1, status.date2 FROM " + this.tableName + " AS status WHERE status.cid=? AND status.object_id=?" + (String)(statuses != null && !statuses.isEmpty() ? " AND status.status IN (" + Utils.toString(statuses) + ")" : "") + " AND (? IS NULL OR status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) ORDER BY status.date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Date endMonthSql = TimeUtils.convertDateToSqlDate((java.util.Date)endMonth);
            int i = 1;
            ps.setInt(i++, contractId);
            ps.setInt(i++, objectId);
            ps.setDate(i++, endMonthSql);
            ps.setDate(i++, endMonthSql);
            ps.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)startMonth));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    java.util.Date date2;
                    java.util.Date date1 = rs.getDate(1);
                    if (date1 == null || startMonth != null && TimeUtils.dateBefore((java.util.Date)date1, (java.util.Date)startMonth)) {
                        date1 = startMonth;
                    }
                    if ((date2 = rs.getDate(2)) == null || endMonth != null && TimeUtils.dateBefore((java.util.Date)endMonth, (java.util.Date)date2)) {
                        date2 = endMonth;
                    }
                    result.add(new Period(date1, date2));
                }
            }
        }
        result.trimToSize();
        return result;
    }

    protected void doByPeriod(ContractStatus status, Integer userId) throws BGException {
        if (ContractStatusDao.isStatusPeriodValid(status)) {
            this.updateStatus(status, userId);
        } else {
            this.deleteStatus(status, userId);
        }
    }

    protected void saveLog(ContractStatusLog log) throws Exception {
        new ContractStatusLogDao(this.con).update((Object)log);
    }

    protected void updateStatus(ContractStatus status, Integer userId) throws BGException {
        boolean update = status.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET date1=?, date2=?, status=?, comment=?" + (update ? " WHERE id=?" : ", cid=?, object_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateTo()));
            ps.setInt(index++, status.getStatus());
            ps.setString(index++, status.getComment());
            if (update) {
                ps.setInt(index++, status.getId());
            } else {
                ps.setInt(index++, status.getContractId());
                ps.setInt(index++, status.getObjectId());
            }
            ps.executeUpdate();
            if (!update) {
                status.setId(ServerUtils.lastInsertId(ps));
            }
            ContractStatusModifiedEvent event = new ContractStatusModifiedEvent(status.getContractId(), (int)userId, null, status);
            if (this.context != null) {
                this.context.publishAfterCommit(event);
            } else {
                this.ep.publish(event);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean deleteContractObjectStatus(int contractId, int objectId) throws BGException {
        boolean bl;
        block8: {
            String query = "DELETE FROM " + this.tableName + " WHERE cid=? AND object_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                int index = 1;
                ps.setInt(index++, contractId);
                ps.setInt(index++, objectId);
                boolean bl2 = bl = ps.executeUpdate() > 0;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            ps.close();
        }
        return bl;
    }

    protected void deleteStatus(ContractStatus status, int userId) throws BGException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, status.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        ContractStatusModifiedEvent event = new ContractStatusModifiedEvent(status.getContractId(), userId, status, null);
        if (this.context != null) {
            this.context.publishAfterCommit(event);
        } else {
            this.ep.publish(event);
        }
    }

    static class ContractStatusManagerConf
    extends Config {
        final boolean dependSubContractStatusChange;
        final boolean independSubContractStatusChange = Utils.parseBoolean((String)Setup.getSetup().get("independ.subcontract.status.change", "no"));

        public ContractStatusManagerConf(int moduleId, ParameterMap moduleSetup, Setup serverSetup) {
            super(moduleId, moduleSetup, serverSetup);
            this.dependSubContractStatusChange = Utils.parseBoolean((String)Setup.getSetup().get("depend.subcontract.status.change", "1"));
        }
    }
}

