/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.bitel.common.io.Base64InputStream;
import ru.bitel.common.io.Base64OutputStream;

public class IOUtils {
    public static OutputStream urlEncode(OutputStream out) throws IOException {
        return new Base64OutputStream(new FilterOutputStream(out){

            @Override
            public void write(int b) throws IOException {
                if (b == 43) {
                    super.write(45);
                } else if (b == 47) {
                    super.write(95);
                } else if (b == 61) {
                    super.write(44);
                } else {
                    super.write(b);
                }
            }
        }, 0);
    }

    public static InputStream urlDecode(InputStream in) throws IOException {
        return new Base64InputStream(new FilterInputStream(in){

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b == 45) {
                    return 43;
                }
                if (b == 95) {
                    return 47;
                }
                if (b == 44) {
                    return 61;
                }
                return b;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int result = super.read(b, off, len);
                int size = off + result;
                for (int i = off; i < size; ++i) {
                    if (b[i] == 45) {
                        b[i] = 43;
                        continue;
                    }
                    if (b[i] == 95) {
                        b[i] = 47;
                        continue;
                    }
                    if (b[i] != 44) continue;
                    b[i] = 61;
                }
                return result;
            }
        });
    }

    public static void transfer(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer, 0, bufferSize)) != -1) {
            out.write(buffer, 0, len);
        }
    }
}

