/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.table;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TableStatusLog
extends BGTableInfoBase {
    public TableStatusLog() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnPeriod(), BGUTableColumn.buildColumnDateTime("\u0414\u0430\u0442\u0430", "date").setWidth(180), BGUTableColumn.buildColumnTextCenter("\u0421\u0442\u0430\u0442\u0443\u0441", "status").setWidth(200), BGUTableColumn.buildColumnTextCenter("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", "user").setWidth(200), BGUTableColumn.buildColumnComment()};
    }

    @Override
    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        ContractStatusService contractStatusService = serverContext.getService(ContractStatusService.class, 0);
        List<Status> statusList = contractStatusService.getStatusList(false);
        Map userMap = UserMap.getMap();
        int objectId = Utils.parseInt(tableParams.get("objectId", "0"));
        SearchResult<ContractStatusLog> searchResult = contractStatusService.contractStatusLogSearch(tableParams.getContractId(), objectId, tableParams.getPage());
        this.page = searchResult.getPage();
        return searchResult.getList().stream().map(a -> new BGUTableRowData().addValue(this.getPeriod(new Period(a.getDate1(), a.getDate2()))).addValue("status", statusList.stream().filter(s -> s.getId() == a.getStatus()).findFirst().map(s -> s.getGuiTitle()).orElseGet(() -> a.getStatus() == -1 ? "\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430" : "??? #" + a.getStatus())).addValue("user", Optional.ofNullable((User)userMap.get(a.getUserId())).map(u -> u.getName()).orElse("??? [ID#" + a.getUserId() + "]")).addValue(this.getComment(a.getComment())).addValue("date", TimeUtils.formatFullDate(a.getDate()))).toList();
    }
}

