/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.emuns.BGEntityType;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatusChangeParameters;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusLogDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.MonitorStatusResult;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.ServerStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.contract.status.server.WebStatusChangeRules;
import ru.bitel.bgbilling.kernel.contract.status.server.bean.ContractStatusMonitorDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractStatusChangeDatesEvent;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskStatus;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskType;
import ru.bitel.bgbilling.kernel.task.server.bean.BGFutureTaskDao;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService")
public class ContractStatusServiceImpl
extends AbstractService
implements ContractStatusService {
    private ContractStatusDao contractStatusDao;
    protected static Calendar balanceDumpTime;

    @PostConstruct
    private void init() {
        this.contractStatusDao = new ContractStatusDao(this.getConnection());
    }

    @Override
    public List<Status> statusList() throws Exception {
        return StatusCache.getInstance().getStatusList();
    }

    @Override
    public List<BGFutureTask> statusFutureTasks(BGEntityType entityType, int entityId, BGFutureTaskStatus status) throws Exception {
        return new BGFutureTaskDao(this.getConnection()).list(this.moduleId, BGFutureTaskType.CONTRACT_STATUS, entityType, entityId, status);
    }

    @Override
    public void statusFutureTaskCancel(int contractId, int id) throws Exception {
        new BGFutureTaskDao(this.getConnection()).cancel(BGFutureTaskType.CONTRACT_STATUS, id);
    }

    @Override
    public List<ContractStatus> contractStatusList(int contractId, Date date) throws Exception {
        return this.contractObjectStatusList(contractId, 0, date);
    }

    @Override
    public ContractStatus contractStatusOnDate(int contractId, Date date) throws Exception {
        return this.contractObjectStatusOnDate(contractId, 0, date);
    }

    @Override
    public ContractStatusChangeParameters contractStatusChangeParametersGet(int contractId) throws Exception {
        Date curdate = new Date();
        WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
        Set<Integer> changeableStatusSet = changeRules.getChangeableStatusIds();
        int status = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId).getStatus();
        GetContractStatusChangeDatesEvent dateListEvent = new GetContractStatusChangeDatesEvent(this.userId, contractId, status, curdate);
        dateListEvent = EventProcessor.getInstance().request(dateListEvent);
        List<Date> changeDateList = dateListEvent.getDateList();
        Calendar changeFrom = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(status));
        if (changeDateList != null) {
            ArrayList<Date> _changeDateList = new ArrayList<Date>();
            for (Date date : changeDateList) {
                _changeDateList.add(TimeUtils.clear_HOUR_MIN_MIL_SEC(date));
            }
            changeDateList = _changeDateList;
        }
        ContractStatusChangeParameters result = new ContractStatusChangeParameters();
        result.setChangeableStatuses(changeableStatusSet);
        if (changeDateList != null) {
            if (!changeDateList.isEmpty()) {
                result.setDateList(changeDateList);
            }
        } else {
            result.setDate(changeFrom != null ? changeFrom.getTime() : null);
        }
        boolean hasFutureChange = false;
        boolean hasManyFutureChanges = false;
        boolean canCancel = false;
        for (ContractStatus contractStatus : this.contractStatusDao.list(contractId, null)) {
            if (!TimeUtils.dateBefore(curdate, contractStatus.getDateFrom())) continue;
            if (hasFutureChange) {
                canCancel = false;
                hasManyFutureChanges = true;
                break;
            }
            hasFutureChange = true;
            if (!changeableStatusSet.contains(contractStatus.getStatus())) continue;
            canCancel = true;
        }
        result.setHasFutureChange(hasFutureChange);
        result.setHasManyFutureChanges(hasManyFutureChanges);
        result.setCanCancel(canCancel);
        return result;
    }

    @Override
    public MapHolder<String, String> contractStatusChange(int contractId, ContractStatus contractStatus, boolean customer, boolean confirmChecked) throws Exception {
        HashMap<String, String> result;
        if (contractStatus == null || contractStatus.getStatus() < 0) {
            throw new BGIllegalArgumentException("contractStatus");
        }
        if (contractStatus.getContractId() <= 0 || contractStatus.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (contractStatus.getDateFrom() == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430.", "contractStatusChange.dateFrom");
        }
        if (contractStatus.getDateTo() != null && !TimeUtils.dateBeforeOrEq(contractStatus.getDateFrom(), contractStatus.getDateTo())) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", "contractStatusChange.wrongPeriod");
        }
        int userId = contractStatus.getUserId() != 0 ? contractStatus.getUserId() : this.userId;
        if (!ServerStatusUtil.checkStatusChange(contractId, userId, contractStatus, confirmChecked, result = new HashMap<String, String>())) {
            return new MapHolder<String, String>(result);
        }
        if (!customer) {
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatusChange", (int)0, (int)userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)contractStatus.getDateFrom(), (Date)contractStatus.getDateTo());
            }
            contractStatus.setId(0);
            this.contractStatusDao.changeStatus(contractStatus, userId);
            result.put("statusId", String.valueOf(contractStatus.getId()));
            return new MapHolder<String, String>(result);
        }
        return this.contractStatusChangeByCustomer(contractStatus);
    }

    @Override
    public List<ContractStatus> contractObjectStatusList(int contractId, int objecttId, Date date) throws Exception {
        return this.contractStatusDao.list(contractId, objecttId, TimeUtils.convertDateToLocalDate(date));
    }

    @Override
    public ContractStatus contractObjectStatusOnDate(int contractId, int objecttId, Date date) throws Exception {
        return this.contractStatusDao.getStatus(contractId, objecttId, TimeUtils.convertDateToLocalDate(date));
    }

    @Override
    public ContractStatusChangeParameters contractObjectStatusChangeParametersGet(int contractId, int objecttId) throws Exception {
        return null;
    }

    @Override
    public MapHolder<String, String> contractObjectStatusChange(int contractId, int objecttId, ContractStatus contractStatus, boolean customer, boolean confirmChecked) throws Exception {
        return null;
    }

    private MapHolder<String, String> contractStatusChangeByCustomer(ContractStatus contractStatus) throws Exception {
        if (contractStatus.getDateTo() != null) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.forbidden");
        }
        WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
        Contract contract = new ContractManager(this.getConnection()).getContractById(contractStatus.getContractId());
        int currentStatus = contract.getStatus();
        Date curdate = new Date();
        ContractStatusChangeParameters changeParams = this.contractStatusChangeParametersGet(contractStatus.getContractId());
        if (TimeUtils.dateEqual(contractStatus.getDateFrom(), curdate) && currentStatus == contractStatus.getStatus()) {
            contractStatus.setDateTo(null);
            if (!changeParams.isCanCancel()) {
                if (changeParams.isHasFutureChange()) {
                    throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.", "contractStatusChangeCancel.blockedByFutureChange");
                }
                if (changeParams.isHasManyFutureChanges()) {
                    throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.", "contractStatusChangeCancel.blockedByFutureChange");
                }
                throw new BGMessageException("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441\u043e \u0441\u043c\u0435\u043d\u044f\u0435\u043c\u044b\u043c.", "contractStatusChangeCancel.notFound");
            }
        } else {
            if (!changeRules.isStatusChangeAllow(currentStatus, contractStatus.getStatus())) {
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.forbidden");
            }
            if (changeParams.isHasFutureChange()) {
                throw new BGMessageException("\u0421\u043c\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0443\u0436\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.", "contractStatusChange.hasFutureChange");
            }
            if (changeParams.getDateList() != null && changeParams.getDateList().size() > 0) {
                if (!changeParams.getDateList().contains(contractStatus.getDateFrom())) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
                }
            } else if (changeParams.getDate() != null) {
                if (!TimeUtils.dateBeforeOrEq(changeParams.getDate(), contractStatus.getDateFrom())) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
                }
            } else {
                throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
            }
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatus", (int)0, (int)-1);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)contractStatus.getDateFrom(), (Date)contractStatus.getDateTo());
        }
        contractStatus.setId(0);
        this.contractStatusDao.changeStatus(contractStatus, -1);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("statusId", String.valueOf(contractStatus.getId()));
        return new MapHolder<String, String>(result);
    }

    @Override
    public void createBalanceDump() throws Exception {
        balanceDumpTime = new ContractStatusMonitorDao(this.getConnection()).createBalanceDump();
    }

    @Override
    public SearchResult<MonitorStatusResult> contractSearch(int mode, int statusPeriod, String statusPeriodUnit, Set<Integer> label, Set<Integer> notLabel, String status, String saldoFrom, String saldoTo, String sort, int subContract, Page page, int saldoAccountMonths, BigDecimal saldoAcconuntsMore, Set<Integer> serviceAccountMaxServices, float serviceMaxVal, int balanceLimit, int balancePrevLimit) throws Exception {
        if (balanceDumpTime == null) {
            throw new BGMessageException("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0441\u0440\u0435\u0437 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432!");
        }
        if (TimeUtils.daysDelta(balanceDumpTime, new GregorianCalendar()) >= 1) {
            throw new BGMessageException("\u0421\u0440\u0435\u0437 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432 \u0443\u0441\u0442\u0430\u0440\u0435\u043b, \u0441\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u0435\u0433\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e");
        }
        int saldoShowMode = this.getSetup().getInt("contract.status.monitor.saldo.show.mode", 1);
        ContractStatusMonitorDao dao = new ContractStatusMonitorDao(this.getConnection());
        return dao.contractSearch(saldoShowMode, saldoAccountMonths, serviceMaxVal, Utils.toString(serviceAccountMaxServices), status, mode, subContract, balanceLimit, balancePrevLimit, statusPeriod, statusPeriodUnit, label, notLabel, saldoFrom, saldoTo, saldoAcconuntsMore, sort, page);
    }

    @Override
    public List<Status> getStatusList(boolean onlyManual) throws Exception {
        List<Status> statusList = null;
        statusList = onlyManual ? StatusCache.getInstance().getManualStatusList() : StatusCache.getInstance().getStatusList();
        return statusList;
    }

    @Override
    public MapHolder<String, String> changeContractStatus(int[] contractIds, int objectId, int statusId, Date dateFrom, Date dateTo, String comment, boolean confirmChecked) throws Exception {
        if (contractIds == null || contractIds.length == 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: contractIds[] == null \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        if (dateFrom == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: dateFrom == null");
        }
        if (statusId < (objectId > 0 ? -1 : 0)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: statusId - \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        }
        if (contractIds.length > 1 && objectId > 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: contractIds.length > 1 && objectId > 0");
        }
        if (dateTo != null && !TimeUtils.dateBeforeOrEq(dateFrom, dateTo)) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (contractIds.length == 1 && !ServerStatusUtil.checkStatusChange(contractIds[0], objectId, this.userId, statusId, dateFrom, dateTo, comment, confirmChecked, result)) {
            return new MapHolder<String, String>(result);
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatusChange", (int)0, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)dateFrom, (Date)dateTo);
        }
        for (int i = 0; i < contractIds.length; ++i) {
            this.contractStatusDao.changeStatus(new ContractStatus().setComment(comment).setContractId(contractIds[i]).setObjectId(objectId).setDateFrom(dateFrom).setDateTo(dateTo).setStatus(statusId), this.userId);
        }
        result.put("status", "ok");
        return new MapHolder<String, String>(result);
    }

    @Override
    public SearchResult<ContractStatusLog> contractStatusLogSearch(int contractId, int objectId, Page page) throws Exception {
        SearchResult<ContractStatusLog> searchResult = new SearchResult<ContractStatusLog>(page);
        new ContractStatusLogDao(this.getConnection()).searchContractStatusLog(searchResult, contractId, objectId);
        return searchResult;
    }

    @Override
    public SearchResult<ContractStatus> contractStatusSearch(int contractId, int objectId, Page page) throws Exception {
        SearchResult<ContractStatus> searchResult = new SearchResult<ContractStatus>(page);
        if (objectId == 0) {
            this.contractStatusDao.searchContractStatus(searchResult, contractId, objectId);
        } else {
            List<Object> resultList2 = new ArrayList();
            resultList2 = this.buildContractObjectStatusList(this.contractStatusDao.list(contractId, objectId, null), contractId, objectId, 0);
            Collections.reverse(resultList2);
            searchResult.getPage().setRecordCount(resultList2.size());
            searchResult.setList(resultList2.subList(page.getPageSize() * (page.getPageIndex() - 1), Math.min(page.getPageSize() * page.getPageIndex(), resultList2.size())));
        }
        return searchResult;
    }

    private ContractStatus addStatus(int contractId, int objectId, int status, Date date1, Date date2) {
        return new ContractStatus().setId(0).setContractId(contractId).setObjectId(objectId).setStatus(status).setDateFrom(date1).setDateTo(date2);
    }

    private List<ContractStatus> buildContractObjectStatusList(List<ContractStatus> contractStatusList, int contractId, int objectId, int defaultStatus) {
        Objects.requireNonNull(contractStatusList);
        List<ContractStatus> oList = contractStatusList.stream().filter(a -> a.getObjectId() > 0).toList();
        List<ContractStatus> periods = Arrays.asList(this.addStatus(contractId, 0, defaultStatus, null, null));
        for (ContractStatus status : oList) {
            ArrayList<ContractStatus> newPeriods = new ArrayList<ContractStatus>();
            for (ContractStatus checkStatus : periods) {
                if (!(checkStatus.getDateFrom() != null && status.getDateTo() != null && checkStatus.getDateFrom().after(status.getDateTo()) || checkStatus.getDateTo() != null && status.getDateFrom() != null && checkStatus.getDateTo().before(status.getDateFrom()))) {
                    LocalDate localDate;
                    if (checkStatus.getDateFrom() == null || status.getDateFrom() != null && checkStatus.getDateFrom().before(status.getDateFrom())) {
                        localDate = TimeUtils.convertDateToLocalDate(status.getDateFrom()).minusDays(1L);
                        newPeriods.add(this.addStatus(contractId, 0, checkStatus.getStatus(), checkStatus.getDateFrom(), TimeUtils.convertLocalDateToDate(localDate)));
                    }
                    newPeriods.add(status);
                    if (status.getDateTo() == null || checkStatus.getDateTo() != null && !checkStatus.getDateTo().after(status.getDateTo())) continue;
                    localDate = TimeUtils.convertDateToLocalDate(status.getDateTo()).plusDays(1L);
                    newPeriods.add(this.addStatus(contractId, objectId, checkStatus.getStatus(), TimeUtils.convertLocalDateToDate(localDate), checkStatus.getDateTo()));
                    continue;
                }
                newPeriods.add(checkStatus);
            }
            periods = newPeriods;
        }
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        List<ContractStatus> cList = contractStatusList.stream().filter(a -> a.getObjectId() == 0).toList();
        for (ContractStatus status : periods) {
            if (status.getObjectId() > 0) {
                result.add(status);
                continue;
            }
            for (ContractStatus checkStatus : cList) {
                if (checkStatus.getDateFrom() != null && status.getDateTo() != null && checkStatus.getDateFrom().after(status.getDateTo()) || checkStatus.getDateTo() != null && status.getDateFrom() != null && checkStatus.getDateTo().before(status.getDateFrom())) continue;
                ContractStatus newStatus = checkStatus.clone();
                newStatus.setId(checkStatus.getId());
                if (checkStatus.getDateFrom() != null && status.getDateFrom() != null && checkStatus.getDateFrom().before(status.getDateFrom())) {
                    newStatus.setDateFrom(status.getDateFrom());
                }
                if (status.getDateTo() != null && (checkStatus.getDateTo() == null || checkStatus.getDateTo().after(status.getDateTo()))) {
                    newStatus.setDateTo(status.getDateTo());
                }
                result.add(newStatus);
            }
        }
        return result;
    }
}

