/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ScheduledTaskReloadEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.PeriodicTask;
import ru.bitel.bgbilling.kernel.task.common.bean.RunningTask;
import ru.bitel.bgbilling.kernel.task.common.bean.SchedulerTaskLog;
import ru.bitel.bgbilling.kernel.task.common.service.SchedulerService;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.TaskBaseRunner;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.kernel.task.server.bean.SchedulerManager;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.task.common.service.SchedulerService")
public class SchedulerServiceImpl
extends AbstractService
implements SchedulerService {
    private SchedulerManager manager;

    @PostConstruct
    public void init() {
        this.manager = new SchedulerManager(this.getConnection());
    }

    @Override
    public List<LightweightTaskData> getSchedulerTasks(String moduleId) throws Exception {
        List<LightweightTaskData> result = this.manager.getTaskList(moduleId);
        result.forEach(task -> {
            task.setModuleName(this.getModuleName(task.isPlugin(), task.getModuleId()));
            List<DependentTask> dependentTasks = task.getDependentTasks();
            if (dependentTasks != null) {
                if (Utils.isBlankString(task.getTitle())) {
                    String comment = task.getComment();
                    if (Utils.isBlankString(comment) && !dependentTasks.isEmpty()) {
                        comment = dependentTasks.get(0).getTitle();
                    }
                    task.setTitle("\u041f\u0430\u043a\u0435\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 (\u0417\u0430\u0434\u0430\u0447: " + dependentTasks.size() + ") => " + comment);
                }
                dependentTasks.forEach(t -> t.setModuleName(this.getModuleName(t.isPlugin(), t.getModuleId())));
            }
        });
        return result;
    }

    private String getModuleName(boolean isPlugin, int moduleId) {
        if (isPlugin) {
            return BGPluginManagerServer.getManager().optPluginByUID(moduleId).map(a -> a.getName()).orElse("\u041f\u043b\u0430\u0433\u0438\u043d ID#" + moduleId + " (\u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d)");
        }
        if (moduleId == 0) {
            return "\u042f\u0434\u0440\u043e";
        }
        if (moduleId > 0) {
            BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
            if (bgModule != null) {
                return bgModule.getTitle();
            }
            this.getLogger().error("Module not found in ModuleCache for ID#{}", (Object)moduleId);
        }
        return moduleId < 0 ? "" : "??? [ID#" + moduleId + "]";
    }

    @Override
    public List<KeyValue> getModuleAndPluginList() throws Exception {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        result.add(new KeyValue("-2", "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
        result.add(new KeyValue("0", "\u042f\u0434\u0440\u043e"));
        result.add(new KeyValue("-1", "\u041c\u043e\u0434\u0443\u043b\u0438"));
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            Map<String, String> moduleTasks = TaskCache.getInstance().getModuleTasks(String.valueOf(module.getId()));
            if (moduleTasks == null || moduleTasks.isEmpty()) continue;
            result.add(new KeyValue(String.valueOf(module.getId()), module.getTitle()));
        }
        result.add(new KeyValue("-1", "\u041f\u043b\u0430\u0433\u0438\u043d\u044b"));
        for (String pluginId : BGPluginManagerServer.getManager().getPluginsMap().keySet()) {
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(pluginId);
            Map<String, String> pluginTasks = TaskCache.getInstance().getModuleTasks("p" + plugin.getPluginUID());
            if (pluginTasks == null || pluginTasks.isEmpty()) continue;
            result.add(new KeyValue("p" + plugin.getPluginUID(), plugin.getName()));
        }
        return result;
    }

    @Override
    public List<KeyValue> getAvailableSchedulerTasks(String moduleId) throws Exception {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        Map<String, String> availableTasks = TaskCache.getInstance().getModuleTasks(moduleId);
        if (availableTasks != null && availableTasks.size() > 0) {
            for (String key : availableTasks.keySet()) {
                result.add(new KeyValue(key, availableTasks.get(key)));
            }
        }
        return result;
    }

    @Override
    public int getActiveTaskCount() throws Exception {
        return new RunTaskDataManager(this.getConnection()).getTaskCount();
    }

    @Override
    public void updateTask(LightweightTaskData task) throws Exception {
        if (task.getId() > 0) {
            this.manager.updateTask(task);
        } else {
            this.manager.addTask(task);
        }
        EventProcessor.getInstance().publish(new ScheduledTaskReloadEvent());
    }

    @Override
    public void deleteTask(int taskId) throws Exception {
        this.manager.deleteTask(taskId);
        this.manager.deleteTaskLog();
    }

    @Override
    public void immediateRun(LightweightTaskData task) throws Exception {
        this.addTaskToTable(task, true);
    }

    @Override
    public void immediateRunOneTask(LightweightTaskData task) throws Exception {
        this.addTaskToTable(task, false);
    }

    private void addTaskToTable(LightweightTaskData task, boolean isPackageTask) throws Exception {
        if (task == null) {
            throw new BGMessageException("Task is null!");
        }
        new RunTaskDataManager(this.getConnection()).addTask(new TaskBaseRunner(task, new Date(), isPackageTask));
    }

    @Override
    public List<RunningTask> getRunningTaskList() throws Exception {
        return this.manager.getRunningTaskList();
    }

    @Override
    public List<PeriodicTask> getPeriodicTaskList() throws Exception {
        return this.manager.getPeriodicTaskList();
    }

    @Override
    public void deleteCurrentRunTask(int taskId) throws Exception {
        this.manager.deleteCurrentRunTask(taskId);
    }

    @Override
    public SearchResult<SchedulerTaskLog> getTaskLog(int taskId, Period period, Page page) throws Exception {
        SearchResult<SchedulerTaskLog> searchResult = new SearchResult<SchedulerTaskLog>(period, page);
        searchResult.setList(new ArrayList());
        this.manager.getTaskLog(taskId, searchResult);
        return searchResult;
    }

    @Override
    public String getTaskParameters(String className) throws Exception {
        Class<?> clazz;
        JSONArray array = new JSONArray();
        if (!Utils.isBlankString(className) && TaskBase.class.isAssignableFrom(clazz = Class.forName(className))) {
            List<TaskParameter> taskParameters = clazz.asSubclass(TaskBase.class).getConstructor(new Class[0]).newInstance(new Object[0]).taskParameters();
            taskParameters.forEach(a -> {
                JSONObject json = new JSONObject().put("key", (Object)a.getKey()).put("title", (Object)a.getTitle()).put("defaultValue", (Object)a.getDefaultValue());
                array.put((Object)json);
            });
        }
        return array.toString();
    }
}

