/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.access;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.common.SerialUtils;

@XmlRootElement
@EventType(deliveryMode=1, timeToLive=60000L)
public class InetAuthorizationRequestEvent
extends QueueEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(InetAuthorizationRequestEvent.class);
    @XmlAttribute
    private final int accountingRootDeviceId;
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int servId;
    @XmlAttribute
    private final boolean accountingPeriodActivate;
    @XmlAttribute
    private int accessCode;

    protected InetAuthorizationRequestEvent() {
        this.accountingRootDeviceId = -1;
        this.deviceId = -1;
        this.servId = -1;
        this.accountingPeriodActivate = false;
    }

    public InetAuthorizationRequestEvent(int moduleId, int userId, int accountingRootDeviceId, int deviceId, int servId, boolean accountingPeriodActivate) {
        super(moduleId, CONTRACT_GLOBAL, userId);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.deviceId = deviceId;
        this.servId = servId;
        this.accountingPeriodActivate = accountingPeriodActivate;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("accountingRootDeviceId", this.accountingRootDeviceId);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getServId() {
        return this.servId;
    }

    public boolean isAccountingPeriodActivate() {
        return this.accountingPeriodActivate;
    }

    public int getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(int accessCode) {
        this.accessCode = accessCode;
    }
}

