/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.function.Lazy;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.StringCache;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.event.DeviceInterfaceModifiedEvent;
import ru.bitel.oss.systems.inventory.resource.server.bean.DevicePortDao;

public class InetInterfaceMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Integer, InetInterfaceMap> moduleMap = new ConcurrentHashMap<Integer, InetInterfaceMap>();
    private final int moduleId;
    private volatile Lazy<Holder> holder;

    public static synchronized InetInterfaceMap getInstance(int moduleId) throws BGException {
        InetInterfaceMap result = (InetInterfaceMap)moduleMap.get(moduleId);
        if (result == null) {
            result = new InetInterfaceMap(moduleId);
            moduleMap.put(moduleId, result);
        }
        return result;
    }

    InetInterfaceMap(int moduleId) throws BGException {
        this.moduleId = moduleId;
        InetDeviceMap.getInstance(moduleId);
        EventProcessor.getInstance().addListener((EventListener)this, InetReloadLocalEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)this, DeviceInterfaceModifiedEvent.class);
        this.holder = Lazy.of(() -> this.load());
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.holder = Lazy.of(() -> this.load());
    }

    @Deprecated
    public String getTitle(int deviceId, int interfaceId) throws BGException {
        return this.getInterfaceTitle(deviceId, interfaceId);
    }

    public String getInterfaceTitle(int invDeviceId, int interfaceId) throws BGException {
        Map<Integer, Map<Integer, InetInterfaceMapItem>> deviceMap = ((Holder)this.holder.get()).deviceMap;
        Map<Integer, InetInterfaceMapItem> ifaceMap = deviceMap.get(invDeviceId);
        if (ifaceMap == null) {
            return null;
        }
        InetInterfaceMapItem item = ifaceMap.get(interfaceId);
        if (item == null) {
            return null;
        }
        return item.title;
    }

    public Integer getInterfaceId(int deviceId, String interfaceTitle) throws BGException {
        Map<Integer, Map<String, Integer>> deviceMap = ((Holder)this.holder.get()).deviceTitleMap;
        Map<String, Integer> ifaceMap = deviceMap.get(deviceId);
        if (ifaceMap == null) {
            return null;
        }
        return ifaceMap.get(interfaceTitle);
    }

    private Holder load() throws Exception {
        logger.info("(Re)loading InetInterfaceMap");
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);){
            Holder holder = this.loadImpl(connectionSet);
            return holder;
        }
    }

    private Holder loadImpl(ConnectionSet connectionSet) throws Exception {
        HashMap<Integer, Map<Integer, InetInterfaceMapItem>> result = new HashMap<Integer, Map<Integer, InetInterfaceMapItem>>();
        HashMap<Integer, Map<String, Integer>> titleResult = new HashMap<Integer, Map<String, Integer>>();
        InetDeviceMap deviceMap = InetDeviceMap.getInstance(this.moduleId);
        DevicePortDao devicePortDao = new DevicePortDao(connectionSet.getConnection(), this.moduleId);
        StringCache ifaceTitleCache = new StringCache(256);
        HashMap<InetInterfaceMapItem, InetInterfaceMapItem> cache = new HashMap<InetInterfaceMapItem, InetInterfaceMapItem>();
        HashMap mapCache = new HashMap();
        for (Map.Entry<Integer, InetDeviceMap.InetDeviceMapItem> e : deviceMap.getMap().entrySet()) {
            InetDeviceMap.InetDeviceMapItem deviceMapItem = e.getValue();
            Integer invDeviceId = deviceMapItem.getDevice().getInvDeviceId();
            if (result.containsKey(invDeviceId)) continue;
            List deviceInterfaceList = devicePortDao.list(deviceMapItem.getDevice().getInvDeviceId(), -1, true, true, null);
            Map<Integer, InetInterfaceMapItem> map = new HashMap();
            HashMap<String, Integer> titleMap = new HashMap<String, Integer>();
            for (DeviceInterface iface : deviceInterfaceList) {
                String ifaceTitle = ifaceTitleCache.intern(iface.getTitle());
                InetInterfaceMapItem mapItem = new InetInterfaceMapItem(ifaceTitle);
                InetInterfaceMapItem oldMapItem = (InetInterfaceMapItem)cache.get(mapItem);
                if (oldMapItem != null) {
                    mapItem = oldMapItem;
                } else {
                    cache.put(mapItem, mapItem);
                }
                map.put(iface.getPort(), mapItem);
                titleMap.put(ifaceTitle, iface.getPort());
            }
            Map oldMap = (Map)mapCache.get(map);
            if (oldMap != null) {
                map = oldMap;
            } else {
                mapCache.put(map, map);
            }
            result.put(invDeviceId, map);
            titleResult.put(invDeviceId, titleMap);
        }
        Holder holder = new Holder(result, titleResult);
        cache.clear();
        mapCache.clear();
        return holder;
    }

    private static class Holder {
        final Map<Integer, Map<Integer, InetInterfaceMapItem>> deviceMap;
        final Map<Integer, Map<String, Integer>> deviceTitleMap;

        public Holder(Map<Integer, Map<Integer, InetInterfaceMapItem>> deviceMap, Map<Integer, Map<String, Integer>> deviceTitleMap) {
            this.deviceMap = deviceMap;
            this.deviceTitleMap = deviceTitleMap;
        }
    }

    class InetInterfaceMapItem {
        final String title;

        public InetInterfaceMapItem(String title) {
            this.title = title;
        }

        public int hashCode() {
            return this.title.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            InetInterfaceMapItem other = (InetInterfaceMapItem)obj;
            return this.title.equals(other.title);
        }
    }
}

