/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLogAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public abstract class AbstractInetSessionDao<B>
extends AbstractDao<B> {
    public static final String TABLE_INET_SESSION_LOG = "inet_session_log";
    public static final String TABLE_INET_SESSION_LOG_DETAIL = "inet_session_log_detail";
    public static final String TABLE_INET_SESSION_LOG_ROUTE = "inet_session_log_route";
    public static final String TABLE_INET_SESSION_LOG_ACCOUNT = "inet_session_log_account";
    public static final String TABLE_INET_SESSION_DETAIL = "inet_session_detail";
    public static final String TABLE_INET_SESSION_ACCOUNT = "inet_session_account";
    protected final String detailTableName;
    protected final String accountTableName;

    public AbstractInetSessionDao(Connection con, int mid, Date date) {
        super(con, mid, TABLE_INET_SESSION_LOG, date);
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.detailTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_DETAIL, (Date)date, (int)mid);
        this.accountTableName = ServerUtils.getModuleMonthTableName((String)TABLE_INET_SESSION_LOG_ACCOUNT, (Date)date, (int)mid);
    }

    public AbstractInetSessionDao(Connection con, int mid) {
        super(con, mid, "inet_session", null);
        this.detailTableName = "inet_session_detail_" + mid;
        this.accountTableName = "inet_session_account_" + mid;
    }

    public Map<Integer, Long> getSessionTrafficsReport(int cid, Collection<Integer> servIds, Period period, Collection<Integer> trafficTypeIds) throws BGException {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        try {
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
                return result;
            }
            Object sql = "SELECT SUM( detail.amount) AS amount , detail.trafficTypeId AS  trafficTypeId FROM " + this.tableName + " AS session  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId  LEFT JOIN " + this.detailTableName + " AS detail ON detail.sessionId = session.Id  WHERE serv.contractId=?";
            sql = this.addWherePart(servIds, period, (String)sql);
            if (trafficTypeIds.size() > 0) {
                sql = (String)sql + " AND detail.trafficTypeId IN ( " + Utils.toString(trafficTypeIds) + ")";
            }
            sql = (String)sql + " GROUP BY detail.trafficTypeId ";
            PreparedStatement ps = this.con.prepareStatement((String)sql);
            this.setParams(cid, period, ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long amount = rs.getLong("amount");
                int traffciTypeId = rs.getInt("trafficTypeId");
                result.put(traffciTypeId, amount);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected String addWherePart(Collection<Integer> servIds, Period period, String sql) {
        if (servIds.size() > 0) {
            sql = (String)sql + " AND serv.id IN (" + Utils.toString(servIds) + ")";
        }
        if (period.getDateFrom() != null) {
            sql = (String)sql + " AND session.sessionStart >=? ";
        }
        if (period.getDateTo() != null) {
            sql = (String)sql + " AND session.sessionStart < ? ";
        }
        return sql;
    }

    protected void setParams(int cid, Period period, PreparedStatement ps) throws SQLException {
        int idx = 1;
        ps.setInt(idx++, cid);
        if (period.getDateFrom() != null) {
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
        }
        if (period.getDateTo() != null) {
            Calendar endDate = (Calendar)period.getDateToCalendar().clone();
            endDate.add(5, 1);
            ps.setDate(idx++, TimeUtils.convertCalendarToSqlDate((Calendar)endDate));
        }
    }

    public void loadAccount(List<InetSessionLog> sessions, Collection<Integer> serviceIds) throws BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.accountTableName)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(100).append("SELECT serviceId, sum(amount) as amount, sum(account) as account FROM ").append(this.accountTableName).append(" WHERE sessionId=?");
            if (serviceIds != null && serviceIds.size() > 0) {
                sb.append(" AND serviceId IN ( ").append(Utils.toString(serviceIds)).append(")");
            }
            sb.append(" GROUP BY serviceId");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            for (InetSessionLog sessionLog : sessions) {
                ps.setLong(1, sessionLog.getId());
                HashMap<Integer, InetSessionLogAccount> accountMap = new HashMap<Integer, InetSessionLogAccount>();
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int serviceId = rs.getInt("serviceId");
                    long amount = rs.getLong("amount");
                    BigDecimal account = rs.getBigDecimal("account");
                    accountMap.put(serviceId, new InetSessionLogAccount(amount, account));
                }
                rs.close();
                ps.close();
                sessionLog.setAccountMap(accountMap);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void loadTraffics(List<InetSessionLog> sessions, Collection<Integer> trafficTypeIds) throws BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.detailTableName)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(100).append("SELECT trafficTypeId, sum(amount) as amount FROM ").append(this.detailTableName).append(" AS detail WHERE sessionId=?");
            if (trafficTypeIds != null && trafficTypeIds.size() > 0) {
                sb.append(" AND detail.trafficTypeId IN ( ").append(Utils.toString(trafficTypeIds)).append(")");
            }
            sb.append(" AND day!=0 GROUP BY trafficTypeId");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            for (InetSessionLog sessionLog : sessions) {
                ps.setLong(1, sessionLog.getId());
                HashMap<Integer, Long> trafficMap = new HashMap<Integer, Long>();
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int traffciTypeId = rs.getInt("trafficTypeId");
                    Long amount = rs.getLong("amount");
                    trafficMap.put(traffciTypeId, amount);
                }
                rs.close();
                ps.close();
                sessionLog.setTrafficMap(trafficMap);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Double> getSumReportInfo(int cid, Collection<Integer> servIds, Period period) throws BGException {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(0.0);
        list.add(0.0);
        list.add(0.0);
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return list;
        }
        try {
            String sql = "SELECT COUNT( session.id ), SUM( session. sessionCost ), SUM( session.sessionTime )" + this.getFromAndWherePart();
            PreparedStatement ps = this.getPs(cid, servIds, period, null, sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int count = rs.getInt(1);
                Double cost = rs.getDouble(2);
                long time = rs.getLong(3);
                if (count > 0) {
                    list.set(0, Double.valueOf(count));
                }
                if (cost > 0.0) {
                    list.set(1, (double)cost);
                }
                if (time <= 0L) continue;
                list.set(2, Double.valueOf(time));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    protected String getFromAndWherePart() {
        return " FROM " + this.tableName + " AS session  LEFT JOIN inet_serv_" + this.moduleId + " AS serv ON serv.id = session.servId  WHERE serv.contractId=?";
    }

    protected PreparedStatement getPs(int cid, Collection<Integer> servIds, Period period, Page page, String sql) throws SQLException {
        sql = this.addWherePart(servIds, period, (String)sql);
        sql = (String)sql + " ORDER BY session.sessionStart ";
        sql = (String)sql + this.sqlLimit(page);
        PreparedStatement ps = this.con.prepareStatement((String)sql);
        this.setParams(cid, period, ps);
        return ps;
    }
}

