/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;

public class InetTariffUtils {
    private static final Logger logger = LogManager.getLogger();

    public static void serviceSet(InetTariffRequest req, InetServiceCost cost, int serviceId) {
        if (cost == null) {
            logger.error("serviceCost is null. Does ServiceSet node in right place of tariff? [serviceId=" + serviceId + ", req.contractId=" + req.contractId + ", req.moduleId=" + req.moduleId + "]");
            return;
        }
        Map costMap = req.getServiceCost();
        List serviceCosts = (List)costMap.get(cost.getServiceId());
        List<InetServiceCost> newServiceCosts = (ArrayList<InetServiceCost>)costMap.get(serviceId);
        if (serviceCosts != null) {
            if (newServiceCosts == null) {
                if (serviceCosts.size() == 1 && serviceCosts.get(0) == cost) {
                    costMap.remove(cost.getServiceId());
                    newServiceCosts = serviceCosts;
                } else {
                    serviceCosts.remove((Object)cost);
                    newServiceCosts = new ArrayList(4);
                    newServiceCosts.add(cost);
                }
                cost.setServiceId(serviceId);
                costMap.put(serviceId, newServiceCosts);
            } else {
                serviceCosts.remove((Object)cost);
                cost.setServiceId(serviceId);
                newServiceCosts.add(cost);
            }
        } else if (newServiceCosts == null) {
            newServiceCosts = new ArrayList<InetServiceCost>(4);
            newServiceCosts.add(cost);
            cost.setServiceId(serviceId);
            costMap.put(serviceId, newServiceCosts);
        } else {
            cost.setServiceId(serviceId);
            newServiceCosts.add(cost);
        }
    }

    public static void serviceCostRemove(InetTariffRequest req, InetServiceCost cost) {
        Map costMap = req.getServiceCost();
        List serviceCosts = (List)costMap.get(cost.getServiceId());
        if (serviceCosts != null) {
            if (serviceCosts.size() == 1 && serviceCosts.get(0) == cost) {
                costMap.remove(cost.getServiceId());
            } else {
                serviceCosts.remove((Object)cost);
            }
        }
    }
}

