/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.slf4j.event.Level;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.worker.ServTrackingWorker;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionTrackingWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.worker.WorkerTask;

public abstract class AccountingWorkerTask
extends WorkerTask<ServerContext>
implements Lifecycle {
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile ScheduledFuture<?> future;
    private static final Random RANDOM = new Random();
    private volatile long delay;
    protected volatile int batchSize;
    protected String name;
    private volatile ObjectName objectName;
    protected final FrequencyCounter processTimePerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    protected final FrequencyCounter processTimePerTenMinutes = new FrequencyCounter(600L, TimeUnit.SECONDS);
    protected final FrequencyCounter invokePerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    protected final FrequencyCounter invokePerTenMinutes = new FrequencyCounter(600L, TimeUnit.SECONDS);

    public AccountingWorkerTask(int batchSize) {
        this(null, null, 0L, batchSize);
        this.delay = 0L;
    }

    public AccountingWorkerTask(ScheduledExecutorService scheduledExecutorService, String name, long delay, int batchSize) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.name = name;
        this.delay = delay <= 50L ? 50L : delay;
        this.batchSize = batchSize <= 0 ? Integer.MAX_VALUE : batchSize;
    }

    public AccountingWorkerTask(ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, ParameterMap defaultParams) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.name = name;
        long delay = params.getLong("delay.millis", defaultParams.getLong("delay.millis", params.getLong("delay", defaultParams.getLong("delay", 10L)) * 1000L));
        if (delay <= 50L) {
            delay = 50L;
        }
        this.delay = delay;
        this.batchSize = params.getInt("batchSize", defaultParams.getInt("batchSize", 0));
        if (this.batchSize <= 0) {
            this.batchSize = Integer.MAX_VALUE;
        }
    }

    @MBeanAttribute
    public long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        if (delay <= 50L) {
            delay = 50L;
        }
        this.delay = delay;
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), delay / 2L + (long)(RANDOM.nextInt((int)delay / 2) + 1), delay, TimeUnit.MILLISECONDS);
    }

    @MBeanAttribute
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            batchSize = Integer.MAX_VALUE;
        }
        this.batchSize = batchSize;
    }

    public synchronized void start() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.delay / 2L + (long)(RANDOM.nextInt((int)this.delay / 2) + 1), this.delay, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public void init() {
        this.objectName = AnnotatedMBean.register((Object)((Object)this), (String)this.name);
    }

    public void destroy() {
        MBeanUtils.unregisterMBean((ObjectName)this.objectName);
    }

    @MBeanAttribute(description="process time per minute in millis")
    public long getProcessTimePerMinute() {
        return this.processTimePerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute(description="process time per 10 minutes in millis")
    public long getProcessTimePerTenMinutes() {
        return this.processTimePerTenMinutes.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getInvokePerMinute() {
        return this.invokePerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getInvokePerTenMinutes() {
        return this.invokePerTenMinutes.get(System.currentTimeMillis());
    }

    public final boolean process(InetTariffWorkerContext workerContext, ConnectionSet connectionSet, SessionTarifficationManager tarifficationManager, InetConnectionRuntime connectionRuntime, Long hour, long millis, boolean recheckAccountingPeriod, long lockWaitTimeout) {
        Boolean result = this.sessionTarifficationProcess(workerContext, connectionSet, tarifficationManager, connectionRuntime, hour, millis, 1L, recheckAccountingPeriod, lockWaitTimeout, false);
        return !Boolean.FALSE.equals(result);
    }

    protected Boolean sessionTarifficationProcess(InetTariffWorkerContext workerContext, ConnectionSet connectionSet, SessionTarifficationManager tarifficationManager, InetConnectionRuntime connectionRuntime, Long hour, long millis, long minDeltaAmount, boolean recheckAccountingPeriod, long lockWaitTimeout, boolean checkAccountingPeriodError) {
        long trafficDeltaCalculateAmount;
        if (connectionRuntime.calculateType != 0) {
            return Boolean.FALSE;
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("minDeltaAmount = {}", (Object)minDeltaAmount);
            this.getLogger().trace("trafficDeltaCalculateAmount = {}", (Object)connectionRuntime.trafficDeltaCalculateAmount);
        }
        if ((trafficDeltaCalculateAmount = connectionRuntime.trafficDeltaCalculateAmount) < minDeltaAmount || trafficDeltaCalculateAmount == 0L) {
            if (this.getLogger().isTraceEnabled() && connectionRuntime.connection != null) {
                this.getLogger().trace("Skip => trafficDeltaCalculateAmount = {} == 0 || < {}", (Object)trafficDeltaCalculateAmount, (Object)minDeltaAmount);
            }
            return Boolean.FALSE;
        }
        boolean result = tarifficationManager.tarifficate(connectionSet, workerContext, connectionRuntime, millis, recheckAccountingPeriod, lockWaitTimeout, checkAccountingPeriodError);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("Result tarifficationManager.tarifficate(...) = {}", (Object)result);
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean trackingProcess(Accounting accounting, ConnectionSet connectionSet, InetConnectionRuntime connectionRuntime, Long hour, long millis, long lockTimeout, boolean forceCheck) throws BGException {
        InetConnection connection;
        block42: {
            long trafficDeltaCalculateAmount;
            if (connectionRuntime.calculateType != 0) {
                return false;
            }
            connection = connectionRuntime.connection;
            if (connection == null) {
                return false;
            }
            if (this.getLogger().isDebugEnabled()) {
                Optional.ofNullable(connectionRuntime.connection).ifPresent(a -> this.getLogger().debug("Tracking connection: {} for session: {}", (Object)connectionRuntime.connection.getId(), (Object)connectionRuntime.sessionId));
            }
            if (connectionRuntime.isServiceSession()) {
                return false;
            }
            if (connection.getConnectionStatus() != 1) {
                return false;
            }
            if (!forceCheck && (trafficDeltaCalculateAmount = connectionRuntime.trafficDeltaCalculateAmount) != 0L) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Skip => trafficDeltaCalculateAmount = {} != 0", (Object)trafficDeltaCalculateAmount);
                }
                return false;
            }
            if (accounting.getDisableServIds().contains(connectionRuntime.inetServId)) {
                if (!connectionRuntime.inetServRuntime.tryLock()) {
                    return false;
                }
            } else {
                if (lockTimeout > 0L) {
                    try {
                        if (!connectionRuntime.inetServRuntime.tryLock(lockTimeout, TimeUnit.MILLISECONDS)) {
                            return false;
                        }
                        break block42;
                    }
                    catch (InterruptedException ex) {
                        throw new BGException((Throwable)ex);
                    }
                }
                connectionRuntime.inetServRuntime.lock();
            }
        }
        try {
            int accessCode;
            if (connection.getConnectionStatus() != 1) {
                boolean ex = false;
                return ex;
            }
            connectionRuntime.trySplitSession(accounting, hour, millis);
            if (connectionRuntime.connection == null) {
                this.getLogger().error("Session was finished when trying to split.");
                boolean ex = false;
                return ex;
            }
            if (connectionRuntime.sessionDeviceState == InetServState.STATE_DISABLE.getCode()) {
                switch (AccessCode.getAccessCode((int)connection.getAccessCode())) {
                    case MAC_DENY: 
                    case IDENTIFIER_DENY: 
                    case INVALID_ACCOUNT: 
                    case INVALID_PIN: {
                        boolean ex = true;
                        return ex;
                    }
                }
            }
            InetServRuntime parentInetServRuntime = connectionRuntime.inetServRuntime.getParentInetServRuntime(accounting);
            AuthResult authResult = accounting.authorization(Level.DEBUG, parentInetServRuntime, connectionRuntime.inetServRuntime, true, connectionRuntime.connection.getDeviceId(), connectionRuntime.connection.getAgentDeviceId(), connectionRuntime.getRealm(), null, 0, null, 0, 0, false, null, null, false, connectionRuntime.sessionCostDelta, true);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Result of authorization accessCode = {}", (Object)authResult.accessCode);
            }
            if ((accessCode = authResult.accessCode) == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && connectionRuntime.sessionDeviceState == InetServState.STATE_DISABLE.getCode()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Session with deviceState=disable and authResult=0. Check session count.");
                }
                if (!accounting.checkSessionCount(parentInetServRuntime, connectionRuntime.inetServRuntime, connection, connectionRuntime.getRealm(), true)) {
                    accessCode = AccessCode.TOO_MANY_SESSIONS_ERROR.getCode();
                }
            }
            if (accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                if (connectionRuntime.processAccessCode(accounting, connectionSet, accessCode)) {
                    boolean bl = true;
                    return bl;
                }
                if (authResult.optionSet == null) {
                    boolean bl = true;
                    return bl;
                }
                if (connectionRuntime.sessionDeviceState == InetServState.STATE_ENABLE.getCode()) {
                    String source;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Option set full: {}", authResult.optionSet);
                    }
                    if (!connectionRuntime.processInetOptions(accounting, authResult.optionSet, source = SessionTrackingWorker.class.getSimpleName()) && accounting.servCheckOptions && !parentInetServRuntime.getInetServ().getDeviceOptions().equals(authResult.optionSet)) {
                        parentInetServRuntime.processOptionsModified(accounting, millis, authResult.optionSet, source);
                    }
                }
            } else if (connectionRuntime.processAccessCode(accounting, connectionSet, accessCode)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        return true;
    }

    protected boolean trackingProcess(Accounting accounting, ConnectionSet connectionSet, EventProcessor ep, InetDeviceRuntime rootDeviceRuntime, InetServRuntime inetServRuntime, long millis, Set<Integer> servTypeIds, boolean checkSessions, boolean accountingPeriodActivate, long lockWaitTimeout) throws BGException {
        InetServ inetServ;
        block20: {
            inetServ = inetServRuntime.getInetServ();
            if (inetServ.getParentId() > 0) {
                return false;
            }
            if (inetServ.getDeviceState() != InetServState.STATE_ENABLE.getCode()) {
                return false;
            }
            if (servTypeIds != null && !servTypeIds.contains(inetServ.getTypeId())) {
                return false;
            }
            if (rootDeviceRuntime != null && inetServ.getDeviceId() != rootDeviceRuntime.inetDeviceId.intValue() && !rootDeviceRuntime.descendantIds.contains(inetServ.getDeviceId())) {
                return false;
            }
            if (!RangeUtils.inRange((long)millis, (long)millis, (long)inetServRuntime.getDateFromMillis(), (long)inetServRuntime.getDateToMillis())) {
                return false;
            }
            if (checkSessions && this.haveSessions(accounting, inetServRuntime)) {
                return false;
            }
            if (lockWaitTimeout > 0L) {
                try {
                    if (!inetServRuntime.tryLock(lockWaitTimeout, TimeUnit.MILLISECONDS)) {
                        return false;
                    }
                    break block20;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            inetServRuntime.lock();
        }
        try {
            inetServ = inetServRuntime.getInetServ();
            if (inetServ.getDeviceState() != InetServState.STATE_ENABLE.getCode()) {
                boolean ex = true;
                return ex;
            }
            if (accountingPeriodActivate) {
                inetServRuntime.accountingPeriodCheck(accounting, connectionSet, millis, true, true);
            }
            Set<Integer> newOptions = accounting.inetServOptionSet(connectionSet, millis, inetServRuntime, null);
            if (inetServ.getDeviceOptions().equals(newOptions)) {
                boolean bl = true;
                return bl;
            }
            inetServRuntime.processOptionsModified(accounting, millis, newOptions, ServTrackingWorker.class.getSimpleName());
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            inetServRuntime.unlock();
        }
        return true;
    }

    private boolean haveSessions(Accounting accounting, InetServRuntime inetServRuntime) {
        if (this.haveSessions0(accounting, inetServRuntime)) {
            return true;
        }
        List<InetServRuntime> children = accounting.getInetServRuntimeMap().listChildren(inetServRuntime.inetServId);
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime child = children.get(i);
                if (!this.haveSessions0(accounting, child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean haveSessions0(Accounting accounting, InetServRuntime inetServRuntime) {
        InetConnectionAutoRuntime autoConnection;
        List<InetConnectionCallRuntime> callConnections = accounting.connectionMapCall.getByServId(inetServRuntime.inetServId);
        if (callConnections != null && callConnections.size() > 0) {
            return true;
        }
        ConcurrentMap<Integer, InetConnectionAutoRuntime> deviceMap = accounting.connectionMapAuto.getDeviceMap(inetServRuntime.getInetServ().getDeviceId());
        return deviceMap != null && (autoConnection = (InetConnectionAutoRuntime)((Object)deviceMap.get(inetServRuntime.inetServId))) != null && autoConnection.connection != null;
    }
}

