/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.current;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RangeCleaner;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateTask;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.SessionRecalculateDayTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.TrafficRangeRecalculateDayManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.current.RecalculateCurrentDayDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.current.RecalculateCurrentDayTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class SessionRecalculateCurrentDayTarifficationManager
extends SessionRecalculateDayTarifficationManager {
    private Set<Long> currentSessions = new HashSet<Long>();
    protected final String connectionTableName;
    private String sessionTableName;
    private String sessionDetailTableName;
    private Map<Integer, Integer> changedContractsAndSubs;
    private static final String TABLE_SESSION_DETAIL_TEMP = "session_detail_temp";

    public SessionRecalculateCurrentDayTarifficationManager(Accounting accounting, int idDivizor, int idRemainder, Set<Integer> cids, Date dateFrom, Date dateTo, Map<Integer, Integer> changedContractsAndSubs) throws BGException {
        super(accounting, idDivizor, idRemainder, cids, dateFrom, dateTo);
        this.sessionTableName = "inet_session_" + accounting.moduleId;
        this.connectionTableName = "inet_connection_" + accounting.moduleId;
        this.sessionDetailTableName = "inet_session_detail_" + accounting.moduleId;
        this.changedContractsAndSubs = changedContractsAndSubs;
        this.needSlave = false;
    }

    @Override
    protected void initDetailPSAndRS(Date month, Connection con) throws SQLException {
        String query = "CREATE TEMPORARY TABLE session_detail_temp(`contractId` int(11) NOT NULL,`connectionId` int(11) NOT NULL,`sessionId` bigint(20) NOT NULL,`day` tinyint(4) NOT NULL,`hour` tinyint(4) NOT NULL,`trafficTypeId` int(11) NOT NULL,`amount` bigint(20) NOT NULL,`deviceState` smallint(6) NOT NULL,PRIMARY KEY (`sessionId`,`day`,`hour`,`trafficTypeId`))";
        PreparedStatement ps = con.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        Object template = " REPLACE INTO session_detail_temp(contractId, connectionId, sessionId, day, hour, trafficTypeId, amount, deviceState)  SELECT serv.contractId, session.connectionId, detail.sessionId, detail.day, detail.hour, detail.trafficTypeId, SUM(detail.amount) as amount,  session.deviceState FROM sessionDetailTableName  AS detail INNER JOIN sessionTableName  AS session ON detail.sessionId = session.id  <SERV JOIN>  WHERE 1=1 ";
        template = (String)template + this.addDetailFilter();
        template = (String)template + " AND " + (String)(this.cids.size() > 0 ? " serv.contractId IN (" + Utils.toString((Iterable)this.cids) + ")" : " serv.contractId % ? = ? ");
        template = (String)template + " AND detail.day > 0 ";
        template = (String)template + " GROUP BY serv.contractId, detail.day, detail.hour, session.connectionId, detail.sessionId, detail.trafficTypeId ";
        query = ((String)template).replaceAll("sessionDetailTableName", this.sessionDetailTableName).replaceAll("sessionTableName", this.sessionTableName);
        query = query.replaceAll("<SERV JOIN>", " INNER JOIN " + this.connectionTableName + " AS connection ON session.connectionId = connection.id INNER JOIN " + this.servTableName + "  AS serv ON connection.servId = serv.id");
        ps = con.prepareStatement(query);
        int idx = this.addDetailFilterParams(ps);
        SessionRecalculateCurrentDayTarifficationManager.setDivizorAndRemainder(ps, idx, this.cids, this.idDivizor, this.idRemainder);
        ps.executeUpdate();
        ps.close();
        query = ((String)template).replaceAll("sessionDetailTableName", this.sessionLogDetailTableName).replaceAll("sessionTableName", this.sessionLogTableName);
        query = query.replaceAll("<SERV JOIN>", "INNER JOIN " + this.servTableName + " AS serv ON session.servId = serv.id ");
        ps = con.prepareStatement(query);
        idx = this.addDetailFilterParams(ps);
        SessionRecalculateCurrentDayTarifficationManager.setDivizorAndRemainder(ps, idx, this.cids, this.idDivizor, this.idRemainder);
        ps.executeUpdate();
        ps.close();
        query = "SELECT  * FROM session_detail_temp ORDER BY contractId, day, hour, connectionId, sessionId, trafficTypeId ";
        this.detailPS = con.prepareStatement(query);
        this.detailRS = this.detailPS.executeQuery();
    }

    @Override
    protected RecalculateDAO initDAO(Connection con) throws SQLException {
        RecalculateCurrentDayDAO dao = new RecalculateCurrentDayDAO(this.dateFrom, this.dateTo, this.accounting.moduleId, this.currentSessions, con);
        ((RecalculateDAO)dao).init();
        return dao;
    }

    protected boolean isCurrent(long sessionId) {
        return this.currentSessions.contains(sessionId);
    }

    @Override
    protected void freeResources() throws SQLException {
        PreparedStatement ps = this.conForDetail.prepareStatement("DROP TABLE session_detail_temp");
        ps.executeUpdate();
        ps.close();
    }

    @Override
    protected RecalculateTask createTask(InetServRuntimeMap inetServRuntimeMap, InetDeviceRuntimeMap deviceRuntimeMap) throws SQLException {
        return new RecalculateCurrentDayTask(this, this.accounting, this.currentSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeAllExtraData(Connection con) throws BGException, SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        RecalculateDAO recalculateDAO = this.initDAO(con);
        this.initMaxAndRangeManagers(con);
        try (BalanceDao balanceDao = new BalanceDao(con);){
            BigDecimal balanceAccount;
            recalculateDAO.removeAllExtraData(this.getInetServiceSet(), this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            this.maxRecalculateManager.removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            ((RangeCleaner)this.rangeRecalculateManager).removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            Set<Pair<Integer, Integer>> contractsForUpdateBalance = recalculateDAO.getContractsForUpdateBalance();
            for (Pair<Integer, Integer> pair : contractsForUpdateBalance) {
                Integer contractId = (Integer)pair.getFirst();
                Integer superContractId = (Integer)pair.getSecond();
                ((RecalculateCurrentDayDAO)recalculateDAO).updateContractAccountFromSessionAccount(contractId, yy, mm, this.getInetServiceSet());
                balanceAccount = balanceDao.setBalanceAccount(contractId.intValue(), superContractId.intValue(), yy, mm);
                this.accounting.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId.intValue(), 2, yy, mm, balanceAccount));
            }
            for (Integer n : this.affectedContracts) {
                this.changedContractsAndSubs.remove(n);
            }
            for (Pair pair : contractsForUpdateBalance) {
                this.changedContractsAndSubs.remove(pair.getFirst());
            }
            for (Map.Entry entry : this.changedContractsAndSubs.entrySet()) {
                int contractId = (Integer)entry.getKey();
                int superContractId = (Integer)entry.getValue();
                ((RecalculateCurrentDayDAO)recalculateDAO).updateContractAccountFromSessionAccount(contractId, yy, mm, this.getInetServiceSet());
                balanceAccount = balanceDao.setBalanceAccount(contractId, superContractId, yy, mm);
                this.accounting.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId, 2, yy, mm, balanceAccount));
                this.maxRecalculateManager.flushContract(contractId);
                ((TrafficRangeRecalculateDayManager)this.rangeRecalculateManager).flushContract(contractId);
            }
        }
        finally {
            this.maxRecalculateManager.close();
            ((TrafficRangeRecalculateDayManager)this.rangeRecalculateManager).close();
            recalculateDAO.close();
        }
    }
}

