/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAccountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountKey;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public class SessionTarifficationManager
extends BGLogger {
    public final Accounting accounting;
    protected boolean realtime;
    private long cacheCalendar1Time = Long.MIN_VALUE;
    private final Calendar cacheCalendar1 = new GregorianCalendar();
    private long cacheCalendar2Time = Long.MIN_VALUE;
    private final Calendar cacheCalendar2 = new GregorianCalendar();
    private final Calendar cacheCalendar3 = new GregorianCalendar();

    public SessionTarifficationManager(Accounting accounting) {
        this.accounting = accounting;
        this.realtime = accounting.realtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tarifficate(ConnectionSet connectionSet, InetTariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, long now, boolean recheckAccountingPeriod, long lockWaitTimeout, boolean checkAccountingPeriodError) {
        block28: {
            this.getLogger().debug("tarifficating connection");
            if (lockWaitTimeout > 0L) {
                try {
                    if (!connectionRuntime.inetServRuntime.tryLock(lockWaitTimeout, TimeUnit.MILLISECONDS)) {
                        return false;
                    }
                    break block28;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            connectionRuntime.inetServRuntime.lock();
        }
        try {
            int error = connectionRuntime.checkAccountingPeriod(this.accounting, connectionSet, recheckAccountingPeriod);
            InetOptionsHolder inetOptionsHolder = new InetOptionsHolder(connectionRuntime.getInetOptions());
            if (!connectionRuntime.isServiceSession() && this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Before calc inetOptions: {}", (Object)Utils.toString(inetOptionsHolder.inetOptions));
            }
            if (error == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                long hour = InetUtils.getHour(now);
                this.getLogger().trace("realtime = {}", (Object)this.realtime);
                if (this.realtime) {
                    Boolean[] ignoreBalanceInsufficient = new Boolean[]{null};
                    ConvergenceBalance balance = this.accounting.convergenceBalanceManager.getBalance(connectionSet, Integer.valueOf(connectionRuntime.contractId), now);
                    boolean balanceInsufficient = !balance.isBalanceExceedsLimit(connectionRuntime.sessionCostDelta);
                    this.getLogger().trace("balance = {}, balanceInsufficient = {}", (Object)balance.getBalance(), (Object)balanceInsufficient);
                    error = this.calculate(connectionSet, workerContext, connectionRuntime, error, hour, balance, connectionRuntime.sessionCostDelta, balanceInsufficient, ignoreBalanceInsufficient, inetOptionsHolder);
                    InetServRuntime rootServRuntime = connectionRuntime.inetServRuntime.getRootInetServRuntime(this.accounting);
                    if (error == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && rootServRuntime.getInetServ().getStatus() != InetServStatus.STATUS_ON) {
                        this.getLogger().info("inetServ[id=" + rootServRuntime.inetServId + "] status not active (accessCode=" + rootServRuntime.getInetServ().getAccessCode() + ").");
                        error = 20;
                    }
                    if (error == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && !StatusCache.getInstance().isModuleActiveStatus(this.accounting.moduleId, rootServRuntime.contractRuntime.getStatus())) {
                        this.getLogger().info("inetServ[id=" + rootServRuntime.inetServId + "] contract status not active.");
                        error = 11;
                    }
                    if (error == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && Boolean.FALSE.equals(ignoreBalanceInsufficient[0]) && !balance.isBalanceExceedsLimit(connectionRuntime.sessionCostDelta)) {
                        error = 12;
                    }
                } else {
                    error = this.calculate(connectionSet, workerContext, connectionRuntime, error, hour, null, BigDecimal.ZERO, false, null, inetOptionsHolder);
                    this.getLogger().debug("error[realtime={}] = {}", (Object)this.realtime, (Object)error);
                    boolean ignoreBalanceInsufficient = true;
                    return ignoreBalanceInsufficient;
                }
                this.getLogger().debug("error[realtime={}] = {}", (Object)this.realtime, (Object)error);
            } else if (!this.realtime) {
                this.getLogger().debug("Error on calculating = {}", (Object)error);
                boolean hour = true;
                return hour;
            }
            this.getLogger().debug("checkAccountingPeriodError = {}; access code = {}", (Object)checkAccountingPeriodError, (Object)error);
            if (!(connectionRuntime.isServiceSession() || checkAccountingPeriodError && error == AccessCode.ACCOUNTING_PERIOD_NOT_AVAILABLE.getCode())) {
                String source;
                Set<Integer> servInetOptions;
                HashSet<Integer> inetOptions = new HashSet<Integer>(inetOptionsHolder.inetOptions);
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Option set from tariff: {}", (Object)Utils.toString(inetOptions));
                }
                if ((servInetOptions = connectionRuntime.inetServRuntime.getRootInetServRuntime(this.accounting).getOptions(now)).size() > 0) {
                    if (inetOptions.size() > 0) {
                        InetOptionRuntimeMap inetOptionRuntimeMap = InetOptionRuntimeMap.getInstance(connectionSet, this.accounting.moduleId);
                        for (Integer inetOptionId : servInetOptions) {
                            InetOptionRuntime optionRuntime = inetOptionRuntimeMap.get(inetOptionId);
                            if (optionRuntime == null || optionRuntime.replaceIds == null) continue;
                            inetOptions.removeAll(optionRuntime.replaceIds);
                        }
                    }
                    inetOptions.addAll(servInetOptions);
                }
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Option set full: {}", (Object)Utils.toString(inetOptions));
                }
                InetServRuntime parentInetServRuntime = connectionRuntime.inetServRuntime.getParentInetServRuntime(this.accounting);
                if (!connectionRuntime.processAccessCode(this.accounting, connectionSet, error) && !connectionRuntime.processInetOptions(this.accounting, inetOptions, source = SessionTarifficationManager.class.getSimpleName()) && this.accounting.servCheckOptions && !parentInetServRuntime.getInetServ().getDeviceOptions().equals(inetOptions)) {
                    parentInetServRuntime.processOptionsModified(this.accounting, now, inetOptions, source);
                }
            } else {
                connectionRuntime.processAccessCode(this.accounting, connectionSet, error);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        return true;
    }

    private int calculate(ConnectionSet connectionSet, InetTariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, int error, long hour, ConvergenceBalance convergenceBalance, BigDecimal accountDelta, boolean balanceInsufficient, Boolean[] ignoreBalanceInsufficient, InetOptionsHolder inetOptionsHolder) throws Exception {
        this.getLogger().debug("Calculating connection");
        assert (connectionRuntime.inetServRuntime.isHeldByCurrentThread());
        InetServTypeRuntime servTypeRuntime = connectionRuntime.inetServRuntime.inetServTypeRef.get();
        TrafficTypeLinkRuntime trafficTypeLinkRuntime = servTypeRuntime.trafficTypeLinkRuntimeRef.get();
        ContractTariffOptionList tariffOptions = connectionRuntime.inetServRuntime.contractRuntime.getTariffOptions(hour);
        for (Map.Entry<Long, Map<TrafficAmountKey, TrafficAmountDelta>> e : connectionRuntime.trafficsDelta.entrySet()) {
            Calendar calendar;
            boolean isCurrentHour;
            long millis = e.getKey();
            boolean bl = isCurrentHour = millis == hour && this.accounting.realtime;
            if (isCurrentHour) {
                millis = InetUtils.roundToSeconds(System.currentTimeMillis());
                calendar = this.cacheCalendar3;
                calendar.setTimeInMillis(millis);
            } else if (connectionRuntime.sessionStartTime > millis) {
                millis = InetUtils.roundToSeconds(connectionRuntime.sessionStartTime);
                calendar = this.cacheCalendar1;
                if (millis != this.cacheCalendar1Time) {
                    calendar.setTimeInMillis(millis);
                    this.cacheCalendar1Time = millis;
                }
            } else {
                calendar = this.cacheCalendar2;
                if (millis != this.cacheCalendar2Time) {
                    calendar.setTimeInMillis(millis);
                    this.cacheCalendar2Time = millis;
                }
            }
            this.getLogger().debug("accountDelta = {}", (Object)accountDelta);
            int newError = this.calculateHour(this.accounting, connectionSet, workerContext, connectionRuntime, trafficTypeLinkRuntime, tariffOptions, millis, calendar, e.getValue(), isCurrentHour, convergenceBalance, accountDelta, balanceInsufficient, ignoreBalanceInsufficient, inetOptionsHolder);
            this.getLogger().debug("newError = {}", (Object)newError);
            if (error != 0) continue;
            error = newError;
        }
        connectionRuntime.trafficDeltaCalculateAmount = 0L;
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculate(ConnectionSet connectionSet, InetConnectionRuntime connectionRuntime, Calendar calendar, int error, ConvergenceBalance convergenceBalance, BigDecimal accountDelta, boolean balanceInsufficient) throws Exception {
        assert (connectionRuntime.inetServRuntime.isHeldByCurrentThread());
        InetTariffWorkerContext workerContext = new InetTariffWorkerContext(this.accounting.setup, connectionSet, this.accounting.moduleId);
        ThreadContext parentContext = ThreadContext.push((ThreadContext)workerContext);
        try {
            InetServTypeRuntime servTypeRuntime = connectionRuntime.inetServRuntime.inetServTypeRef.get();
            TrafficTypeLinkRuntime trafficTypeLinkRuntime = servTypeRuntime.trafficTypeLinkRuntimeRef.get();
            ContractTariffOptionList tariffOptions = connectionRuntime.inetServRuntime.contractRuntime.getTariffOptions(this.accounting.initialDate);
            InetOptionsHolder inetOptionsHolder = new InetOptionsHolder(connectionRuntime.getInetOptions());
            for (Map.Entry<Long, Map<TrafficAmountKey, TrafficAmountDelta>> e : connectionRuntime.trafficsDelta.entrySet()) {
                long millis = e.getKey();
                if (connectionRuntime.sessionStartTime > millis) {
                    millis = InetUtils.roundToSeconds(connectionRuntime.sessionStartTime);
                }
                calendar.setTimeInMillis(millis);
                int newError = this.calculateHour(this.accounting, connectionSet, workerContext, connectionRuntime, trafficTypeLinkRuntime, tariffOptions, millis, calendar, e.getValue(), false, convergenceBalance, accountDelta, balanceInsufficient, null, inetOptionsHolder);
                if (error != 0) continue;
                error = newError;
            }
            connectionRuntime.trafficDeltaCalculateAmount = 0L;
            workerContext.commit();
            int n = error;
            return n;
        }
        finally {
            ThreadContext.pop((ThreadContext)workerContext, (ThreadContext)parentContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int calculateHour(Accounting accounting, ConnectionSet connectionSet, InetTariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, TrafficTypeLinkRuntime trafficTypeLinkRuntime, ContractTariffOptionList tariffOptions, long millis, Calendar calendar, Map<TrafficAmountKey, TrafficAmountDelta> map, boolean isCurrentHour, ConvergenceBalance convergenceBalance, BigDecimal accountDelta, boolean balanceInsufficient, Boolean[] ignoreBalanceInsufficient, InetOptionsHolder inetOptionsHolder) throws Exception {
        InetServiceCost serviceCost;
        this.getLogger().debug("calculateHour");
        assert (connectionRuntime.inetServRuntime.isHeldByCurrentThread());
        List treeList = connectionRuntime.inetServRuntime.getTariffTreeSet().getEntryList(calendar.getTimeInMillis());
        if (treeList.size() == 0) {
            return AccessCode.TARIFF_NOT_FOUND.getCode();
        }
        int domainId = connectionRuntime.inetServRuntime.contractRuntime.getDomainId();
        ProductPeriodRuntimeList productPeriodRuntimeList = connectionRuntime.inetServRuntime.contractRuntime.getProductPeriods(millis);
        InetTariffRequest inetTariffRequest = new InetTariffRequest(domainId, accounting.moduleId, connectionRuntime.contractId, connectionRuntime.connection.getDeviceId(), connectionRuntime.sessionId, connectionRuntime.inetServRuntime, connectionRuntime, connectionRuntime.inetServRuntime.getContractSuspendPeriods(), productPeriodRuntimeList);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Calculate for {}", (Object)TimeUtils.format((Calendar)calendar, (String)"dd.MM.yyyy HH:mm:ss"));
        }
        inetTariffRequest.setTime(calendar);
        inetTariffRequest.setConnectionSet(connectionSet);
        inetTariffRequest.setBalanceInsufficient(balanceInsufficient);
        inetTariffRequest.setConvergenceBalance(convergenceBalance);
        inetTariffRequest.setAccountDelta(accountDelta);
        Map tariffOptionsMap = null;
        if (tariffOptions != null) {
            inetTariffRequest.setContractTariffOptions(tariffOptions);
            tariffOptionsMap = inetTariffRequest.getTariffOptionMap(millis);
            inetTariffRequest.setTariffOptionMap(tariffOptionsMap);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("TariffOptionMap: {}", (Object)tariffOptionsMap);
        }
        HashSet<Integer> trafficServiceIds = new HashSet<Integer>(trafficTypeLinkRuntime.trafficServiceIdSet);
        for (Map.Entry<TrafficAmountKey, TrafficAmountDelta> deltaEntry : map.entrySet()) {
            TrafficAmountDelta delta = deltaEntry.getValue();
            int type = -deltaEntry.getKey().trafficTypeId - 1;
            long amount = delta.calculateAmountDelta;
            serviceCost = new InetServiceCost(type, null, null, null, null, amount);
            ArrayList<InetServiceCost> serviceCostList = new ArrayList<InetServiceCost>(2);
            serviceCostList.add(serviceCost);
            inetTariffRequest.setServiceCost(type, serviceCostList);
            delta.calculateAmountDelta -= amount;
            trafficServiceIds.remove(type);
        }
        for (Integer serviceId : trafficServiceIds) {
            ArrayList<InetServiceCost> serviceCostList = new ArrayList<InetServiceCost>(3);
            serviceCostList.add(new InetServiceCost(serviceId, null, null, null, null, 0L));
            inetTariffRequest.setServiceCost(serviceId, serviceCostList);
        }
        int error = 0;
        int size = treeList.size();
        for (int i = 0; i < size; ++i) {
            TariffModuleTreeSet.Entry tree = (TariffModuleTreeSet.Entry)treeList.get(i);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("TariffRequest:\n{}", (Object)inetTariffRequest);
            }
            try {
                inetTariffRequest.setTariffTreeSetEntry(tree);
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            tree.getTree().execute((AbstractTariffRequest)inetTariffRequest, (TariffContext)accounting.tariffContext, (ThreadContext)workerContext);
            if (!this.getLogger().isTraceEnabled()) continue;
            this.getLogger().debug("Executed TariffRequest:\n{}", (Object)inetTariffRequest);
        }
        if (millis != calendar.getTimeInMillis()) {
            this.getLogger().error("TariffRequest 'time' was changed in tree.execute()");
        }
        Map<Integer, TrafficAccountDelta> accountingDelta = connectionRuntime.accountDelta;
        for (List serviceCostList : inetTariffRequest.getServiceCost().values()) {
            int size2 = serviceCostList.size();
            block12: for (int i = 0; i < size2; ++i) {
                serviceCost = (InetServiceCost)((Object)serviceCostList.get(i));
                if (serviceCost.getServiceId() <= 0 || serviceCost.getCost() == null) {
                    String what;
                    if (serviceCost.amountNull) continue;
                    switch (accounting.checkTariffPrice) {
                        case 0: {
                            continue block12;
                        }
                        case 4: {
                            if (serviceCost.getServiceId() != -1) break;
                            continue block12;
                        }
                        case 3: {
                            if (serviceCost.getServiceId() == -1) continue block12;
                        }
                        case 1: {
                            if (serviceCost.getAmount() == 0L) continue block12;
                        }
                    }
                    error = AccessCode.PRICE_NOT_FOUND.getCode();
                    if (serviceCost.getCost() == null) {
                        what = serviceCost.getServiceId() < 0 ? "trafficTypeId=" + (-serviceCost.getServiceId() - 1) : "serviceId=" + serviceCost.getServiceId();
                        this.getLogger().error("Cost not set for " + what + " and contract id=" + connectionRuntime.contractId);
                    } else {
                        what = "trafficTypeId=" + (-serviceCost.getServiceId() - 1);
                        this.getLogger().error("Service not set for " + what + " and contract id=" + connectionRuntime.contractId);
                    }
                    String key = "inet.tariffication.priceNotFound";
                    AlarmSender.sendAlarm((String)key, (long)600000L, (String)"Inet: \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u0435", (String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u0430\u0445 \u0434\u043b\u044f " + what + " \u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 id " + connectionRuntime.contractId));
                    continue;
                }
                if (accounting.skipFlushZeroCostAccount && BigDecimal.ZERO.compareTo(serviceCost.getCost()) == 0) continue;
                Integer serviceId = serviceCost.getServiceId();
                TrafficAccountDelta account = accountingDelta.get(serviceId);
                if (account != null) {
                    account.amountDelta += serviceCost.getAmount();
                    account.accountDelta = account.accountDelta.add(serviceCost.getCost(), accounting.tariffContext.mc);
                } else {
                    accountingDelta.put(serviceId, new TrafficAccountDelta(serviceCost.getAmount(), serviceCost.getCost()));
                }
                connectionRuntime.sessionCostDelta = connectionRuntime.sessionCostDelta.add(serviceCost.getCost(), accounting.tariffContext.mc);
            }
        }
        int restrictionAccessCode = connectionRuntime.inetServRuntime.getRootInetServRuntime(accounting).checkRestrictions(workerContext, accounting, connectionRuntime, inetTariffRequest);
        if (isCurrentHour) {
            if (inetTariffRequest.getAccessCode() != AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && error == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                this.getLogger().info("Authorization denied (by tariff) with accessCode " + inetTariffRequest.getAccessCode());
                error = AccessCode.AUTH_DENY.getCode();
            }
            if (restrictionAccessCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && error == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                this.getLogger().info("Authorization denied (by serv restriction) with accessCode " + restrictionAccessCode);
                error = restrictionAccessCode;
            }
            Set<Integer> inetOptionSet = inetTariffRequest.getInetOptionSet();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("InetOptionSet: {}", inetOptionSet);
            }
            inetOptionsHolder.inetOptions = new HashSet<Integer>(inetOptionSet);
            if (ignoreBalanceInsufficient != null) {
                ignoreBalanceInsufficient[0] = inetTariffRequest.isIgnoreBalanceInsufficient();
            }
        }
        return error;
    }

    static class InetOptionsHolder {
        Set<Integer> inetOptions;

        public InetOptionsHolder(Set<Integer> inetOptions) {
            this.inetOptions = inetOptions;
        }
    }
}

