/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access.sa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.access.sa.CompositeFuture;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEventType;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.AsyncEventWorker;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.AccessCodes;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetConnectionDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetConnectionDeviceStateAndOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.manage.InetDeviceManageEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaAccountingEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaConnectionCloseEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaDeviceInitEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServInitEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.Keys;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class ServiceActivatorDeviceWorker
extends AsyncEventWorker<Event> {
    private final ScheduledExecutorService scheduledExecutorService;
    private final Access access;
    private final int deviceId;
    private final long fetchDelay;
    private final long fetchTimeout;
    private volatile boolean skipEvent;
    private InetDeviceRuntime deviceRuntime;
    private ServiceActivatorSet serviceActivators;
    private InetConnectionManager connectionManager;
    private boolean manageConnections;
    private boolean connectionModifyInsteadClose;
    private boolean connectionCloseInsteadModify;
    private boolean connectionStateModify;
    private EventProcessor ep;
    private ConnectionSet connectionSet;
    private InetServDao inetServDao;
    private InetConnectionDao inetConnectionDao;
    private volatile Future<?> future;
    private boolean connected = false;
    protected long errorAlarmCount;
    protected long errorRedeliveryCount;
    protected long errorRedeliveryTimeout;
    protected long connectErrorCount = 0L;

    public ServiceActivatorDeviceWorker(Access access, ScheduledExecutorService scheduledExecutorService, int deviceId, long fetchDelay, long fetchTimeout) throws BGException {
        super(EventProcessor.getInstance(), ServiceActivatorDeviceWorker.destination(deviceId), access.moduleId, -1, "deviceId=" + deviceId, false, new Class[]{InetSaStateModifyEvent.class, InetSaConnectionCloseEvent.class, InetSaOptionsModifyEvent.class, InetSaServModifyEvent.class, InetSaAccountingEvent.class, InetSaDeviceInitEvent.class, InetSaServInitEvent.class});
        this.scheduledExecutorService = scheduledExecutorService;
        this.access = access;
        this.deviceId = deviceId;
        this.fetchDelay = fetchDelay;
        this.fetchTimeout = fetchTimeout;
    }

    public void start() {
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), 3000L, this.fetchDelay, TimeUnit.MILLISECONDS);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public InetDeviceRuntime getDeviceRuntime() {
        return this.deviceRuntime;
    }

    private static String destination(int deviceId) {
        return PartitionedQueueEvent.getDestinationMask(InetSaServModifyEvent.class, (int)deviceId);
    }

    protected synchronized void runImpl() throws Exception {
        int result = this.internalRunWorker(this.fetchTimeout, false);
        if (result < 0) {
            this.getLogger().info("Execution error - waiting " + this.errorPause + "ms for next try.");
            this.future.cancel(false);
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.errorPause, this.fetchDelay, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void execute() {
        this.future.cancel(false);
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), 0L, this.fetchDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * Loose catch block
     */
    protected boolean runWorker() throws BGException {
        this.deviceRuntime = this.access.deviceMap.getAndLockSa(this.deviceId);
        try {
            this.serviceActivators = this.deviceRuntime.saInstances;
            this.connectionManager = this.access.connectionManager;
            this.manageConnections = this.deviceRuntime.config.getInt(Keys.SA_CONNECTION_MANAGE.key, this.deviceRuntime.config.getInt("sa.manageConnections", 1)) > 0;
            this.connectionModifyInsteadClose = this.deviceRuntime.config.getInt(Keys.SA_CONNECTION_MODIFY_INSTEAD_CLOSE.key, 1) > 0;
            this.connectionCloseInsteadModify = this.deviceRuntime.config.getInt(Keys.SA_CONNECTION_CLOSE_INSTEAD_MODIFY.key, 0) > 0;
            this.connectionStateModify = this.deviceRuntime.config.getInt(Keys.SA_CONNECTION_STATE_MODIFY.key, 0) > 0;
            this.errorPause = this.deviceRuntime.config.getLong(Keys.SA_ERROR_PAUSE_MILLIS.key, this.deviceRuntime.config.getLong(Keys.SA_ERROR_PAUSE.key, TimeUnit.SECONDS.convert(1L, TimeUnit.MINUTES)) * 1000L);
            this.errorRedeliveryCount = this.deviceRuntime.config.getLong(Keys.SA_ERROR_REDELIVERY_COUNT.key, 100L);
            this.errorAlarmCount = Math.min(this.deviceRuntime.config.getLong(Keys.SA_ERROR_ALARM_COUNT.key, 20L), this.errorRedeliveryCount);
            this.errorRedeliveryTimeout = this.deviceRuntime.config.getLong(Keys.SA_ERROR_REDELIVERY_TIMEOUT_MILLIS.key, this.deviceRuntime.config.getLong(Keys.SA_ERROR_REDELIVERY_TIMEOUT.key, TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS)) * 1000L);
            this.batchSize = this.deviceRuntime.config.getInt(Keys.SA_BATCH_SIZE.key, 20);
            this.batchPause = this.deviceRuntime.config.getLong(Keys.SA_BATCH_PAUSE_MILLIS.key, this.deviceRuntime.config.getLong(Keys.SA_BATCH_PAUSE.key, 0L) * 1000L);
            this.batchWait = this.deviceRuntime.config.getLong(Keys.SA_BATCH_WAIT_MILLIS.key, this.deviceRuntime.config.getLong(Keys.SA_BATCH_WAIT.key, 5L) * 1000L);
            this.waitNextTask = this.deviceRuntime.config.getLong(Keys.SA_BATCH_WAIT_NEXT_MILLIS.key, this.deviceRuntime.config.getLong(Keys.SA_BATCH_WAIT_NEXT.key, 5L) * 1000L);
            this.ep = EventProcessor.getInstance();
            this.connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.access.setup, (boolean)true);
            int lazy = this.deviceRuntime.config.getInt(Keys.SA_LAZY.key, 0);
            try {
                this.inetServDao = new InetServDao(this.connectionSet.getConnection(), this.access.moduleId);
                this.inetConnectionDao = new InetConnectionDao(this.connectionSet.getConnection(), this.access.moduleId);
            }
            catch (Exception ex) {
                this.getLogger().warn(ex.getMessage(), (Throwable)ex);
            }
            try {
                if (lazy <= 0) {
                    try {
                        ++this.connectErrorCount;
                        this.connected = true;
                        this.serviceActivators.connect();
                        this.connectErrorCount = 0L;
                    }
                    catch (BGException e) {
                        if (this.connectErrorCount > this.errorAlarmCount) {
                            this.alarm(e);
                        }
                        throw e;
                    }
                }
                boolean e = this.doTasks();
                return e;
            }
            catch (BGException ex) {
                this.logError(ex);
                throw ex;
            }
            finally {
                if (this.connected) {
                    this.connected = false;
                    this.serviceActivators.disconnect();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.deviceRuntime != null) {
                this.deviceRuntime.saInstances.unlock();
                this.deviceRuntime = null;
            }
            this.serviceActivators = null;
            this.connectionManager = null;
            this.inetServDao = null;
            this.inetConnectionDao = null;
            this.ep = null;
            if (this.connectionSet != null) {
                this.connectionSet.close();
                this.connectionSet = null;
            }
        }
    }

    public final void putLast(Object task) throws InterruptedException {
        super.putLast(task);
    }

    public Object doTask(Object task) throws BGException {
        ServiceActivatorEvent result;
        this.getLogger().info("Do task deviceId: " + this.deviceId + "; " + task);
        if (this.skipEvent) {
            this.skipEvent = false;
            this.getLogger().info("Skip event by command");
            return Boolean.TRUE;
        }
        if (task instanceof InitEndTask) {
            int invDeviceId = this.deviceRuntime.inetDevice.getInvDeviceId();
            int inetDeviceId = this.deviceRuntime.inetDevice.getId();
            EventProcessor.getInstance().publish((Event)new InetDeviceManageEvent(this.access.moduleId, ((InitEndTask)task).userId, invDeviceId, inetDeviceId, "onDeviceSyncFinish", 0, 0));
            return Boolean.TRUE;
        }
        Date now = new Date();
        try {
            AsyncEventHolder asyncEventHolder;
            if (task instanceof AsyncEventHolder) {
                asyncEventHolder = (AsyncEventHolder)task;
                task = asyncEventHolder.event;
            } else {
                asyncEventHolder = null;
            }
            if (task instanceof InetSaStateModifyEvent) {
                this.getLogger().info("Do InetSaStateModifyEvent task");
                result = ((InetSaStateModifyEvent)task).toSaEvent(this.access, this.connectionSet, this.manageConnections, this.connectionManager, now);
            } else if (task instanceof InetSaOptionsModifyEvent) {
                this.getLogger().info("Do InetSaOptionsModifyEvent task");
                result = ((InetSaOptionsModifyEvent)task).toSaEvent(this.access, this.connectionSet, this.manageConnections, this.connectionManager, now);
            } else if (task instanceof InetSaServModifyEvent) {
                List<InetConnectionRuntime> connectionList;
                this.getLogger().info("Do InetSaServModifyEvent task");
                InetSaServModifyEvent servModifyEvent = (InetSaServModifyEvent)task;
                result = servModifyEvent.toSaEvent(this.access, this.connectionSet, now);
                if (result != null && servModifyEvent.getNewInetServState() == InetServState.STATE_DELETED.getCode() && !servModifyEvent.isInitServ() && result.servRuntime.inetServTypeRef.get().inetServType.getSessionInitiationType() == 0 && (connectionList = this.connectionManager.getByServId(result.inetServId)) != null) {
                    for (InetConnectionRuntime connection : connectionList) {
                        if (connection.connection.getConnectionStatus() >= 3) continue;
                        EventProcessor.getInstance().publish((Event)new InetSaConnectionCloseEvent(this.access.moduleId, 0, connection.connection));
                    }
                }
            } else if (task instanceof InetSaAccountingEvent) {
                int eventType;
                this.getLogger().info("Do InetSaAccountingEvent task");
                InetSaAccountingEvent accountingEvent = (InetSaAccountingEvent)task;
                switch (accountingEvent.getType()) {
                    case 1: {
                        eventType = ServiceActivatorEventType.ACCOUNTING_START.getCode();
                        break;
                    }
                    case 2: {
                        eventType = ServiceActivatorEventType.ACCOUNTING_STOP.getCode();
                        break;
                    }
                    default: {
                        return Boolean.TRUE;
                    }
                }
                InetConnection connection = accountingEvent.getConnection();
                if (connection.getDeviceId() != this.deviceId) {
                    return Boolean.TRUE;
                }
                int servId = connection.getServId();
                InetServRuntime inetServRuntime = this.access.inetServRuntimeMap.get(servId);
                if (inetServRuntime == null) {
                    this.getLogger().error("InetServ not found with id=" + servId);
                    return Boolean.TRUE;
                }
                String realm = InetUtils.getRealm(connection.getUsername());
                InetServ inetServ = inetServRuntime.getInetServ();
                List<InetServ> childrenServs = ServiceActivatorEvent.getInetServChildren(this.access.getInetServRuntimeMap(), inetServ.getId(), now.getTime());
                inetServ.setChildren(childrenServs);
                Set<Integer> optionSet = this.access.inetServOptionSet(this.connectionSet, now.getTime(), inetServRuntime, realm);
                result = new ServiceActivatorEvent(this.access, (Event)accountingEvent, 0, inetServRuntime, eventType, servId, inetServRuntime.inetServTypeRef.get().inetServType, inetServ, inetServ, connection.getDeviceState(), connection.getDeviceState(), optionSet, optionSet, 0);
                result.connectionRuntime = new InetConnectionRuntime(connection);
            } else if (task instanceof InetSaConnectionCloseEvent) {
                this.getLogger().info("Do InetSaConnectionCloseEvent task");
                InetSaConnectionCloseEvent connectionCloseEvent = (InetSaConnectionCloseEvent)task;
                result = connectionCloseEvent.toSaEvent(this.access, this.connectionSet, this.manageConnections, this.connectionManager, now);
            } else {
                if (task instanceof InetSaDeviceInitEvent) {
                    InetSaDeviceInitEvent deviceInitEvent = (InetSaDeviceInitEvent)task;
                    this.getLogger().info("Do InetSaDeviceInitEvent task, device:" + deviceInitEvent.getDeviceId());
                    this.initDevice0(deviceInitEvent.getInitDeviceId(), deviceInitEvent.getUserId());
                    return Boolean.TRUE;
                }
                if (task instanceof InetSaServInitEvent) {
                    InetSaServInitEvent servInitEvent = (InetSaServInitEvent)task;
                    this.getLogger().info("Do InetSaServInitEvent task");
                    this.initServ(this.connectionSet, servInitEvent.getInetServId(), servInitEvent.getUserId());
                    return Boolean.TRUE;
                }
                this.getLogger().error(task.toString());
                return Boolean.TRUE;
            }
            if (result == null) {
                this.getLogger().debug("Skip event");
                return Boolean.TRUE;
            }
            if (asyncEventHolder != null) {
                result.async = true;
                result.processDeviceId = asyncEventHolder.processDeviceId;
            }
            this.getLogger().info("Command result event: " + result);
            if (result.connectionRuntime != null && result.serviceConnections == null) {
                List<InetConnection> serviceSessions = this.connectionManager.getServiceSessions(result.connectionRuntime.connection.getId());
                result.serviceConnections = this.connectionManager != null ? serviceSessions : Collections.emptyList();
            }
        }
        catch (Exception ex) {
            this.logError("Device:" + this.deviceId + " - " + ex.getMessage(), ex);
            return Boolean.TRUE;
        }
        try {
            return new Object[]{this.doCommand(result), result};
        }
        catch (Throwable e) {
            throw new BGException("Error on device:" + this.deviceId + " - " + e.getClass().getName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""), e);
        }
    }

    private Object doCommand(ServiceActivatorEvent event) throws Throwable {
        if (!this.connected) {
            this.connected = true;
            this.serviceActivators.connect();
        }
        boolean result = true;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Processing deviceId=" + this.deviceId + "; event => " + event);
        }
        switch (ServiceActivatorEventType.getServiceActivatorEventTypeByCode(event.eventType)) {
            case SERVICE_MODIFY: {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("event.connectionRuntime = {}", (Object)event.connectionRuntime);
                }
                if (event.connectionRuntime == null) {
                    result = this.serviceActivators.serviceModify(this, event);
                    break;
                }
                this.getLogger().debug("connectionCloseInsteadModify = {}", (Object)this.connectionCloseInsteadModify);
                this.getLogger().debug("connectionModifyInsteadClose = {}", (Object)this.connectionModifyInsteadClose);
                if (this.connectionCloseInsteadModify) {
                    result = this.serviceActivators.connectionClose(this, event);
                    this.getLogger().debug("serviceActivators.connectionClose(...) = {}", (Object)result);
                    break;
                }
                if (this.connectionModifyInsteadClose && !AccessCodes.isNeededDisconnect((int)event.accessCode)) {
                    result = this.serviceActivators.connectionModify(this, event);
                    this.getLogger().debug("serviceActivators.connectionModify(...) = {}", (Object)result);
                    break;
                }
                this.getLogger().debug("event.newState = {}", (Object)event.newState);
                result = event.newState == InetServState.STATE_ENABLE.getCode() ? this.serviceActivators.connectionModify(this, event) : this.serviceActivators.connectionClose(this, event);
                this.getLogger().debug(event.newState == InetServState.STATE_ENABLE.getCode() ? "serviceActivators.connectionModify(...) = {}" : "serviceActivators.connectionClose(...) = {}", (Object)result);
                break;
            }
            case SERVICE_CANCEL: {
                result = this.serviceActivators.serviceCancel(this, event);
                break;
            }
            case SERVICE_CREATE: {
                result = this.serviceActivators.serviceCreate(this, event);
                break;
            }
            case ACCOUNTING_START: {
                result = this.serviceActivators.onAccountingStart(this, event);
                break;
            }
            case ACCOUNTING_STOP: {
                result = this.serviceActivators.onAccountingStop(this, event);
                break;
            }
        }
        this.getLogger().info("Process event type [" + event.eventType + "] result=" + result);
        if (result && event.futures != null) {
            if (event.futures.size() == 1) {
                return event.futures.get(0);
            }
            return new CompositeFuture(event.futures);
        }
        return result;
    }

    protected void taskDone(Object task, Object result) throws BGException {
        boolean optionsModified;
        boolean stateModified;
        boolean ok;
        boolean bl = ok = !Boolean.FALSE.equals(result);
        if (!ok) {
            this.getLogger().warn("Task return false");
            return;
        }
        if (!(task instanceof Object[])) {
            return;
        }
        Object[] array = (Object[])task;
        ServiceActivatorEvent event = (ServiceActivatorEvent)array[1];
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Task finished (event " + event + ")");
        }
        if (event.eventType != ServiceActivatorEventType.SERVICE_MODIFY.getCode() && event.eventType != ServiceActivatorEventType.SERVICE_CREATE.getCode() && event.eventType != ServiceActivatorEventType.SERVICE_CANCEL.getCode()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Skipping event type " + ServiceActivatorEventType.getServiceActivatorEventTypeByCode(event.eventType));
            }
            return;
        }
        boolean bl2 = stateModified = event.getOldState() != event.getNewState();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Old state: %d; new state: %d; state modified (old state != new state): %s", event.oldState, event.newState, stateModified));
        }
        boolean bl3 = optionsModified = event.oldOptions == null || !event.oldOptions.equals(event.newOptions);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Old options: %s; new options: %s; options modified (old option set != new option set): %s", Utils.toString(event.oldOptions), Utils.toString(event.newOptions), optionsModified));
        }
        if (event.connectionRuntime != null) {
            boolean rerouted;
            boolean bl4 = rerouted = this.deviceId != event.connectionRuntime.connection.getDeviceId();
            if (rerouted) {
                this.getLogger().warn("DeviceId in the connection doesn't match with the device id at the service activator");
                return;
            }
            event.connectionRuntime.setWantDeviceState(event.newState);
            if (event.newState == InetServState.STATE_DISABLE.getCode() && AccessCodes.isNeededDisconnect((int)event.accessCode)) {
                event.connectionRuntime.wantClose = true;
            }
            if (stateModified && (this.connectionStateModify || event.isConnectionStateModified())) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Changing device state and/or options");
                }
                this.fireInetConnectionDeviceOptionsModified(event, event.newState, optionsModified ? event.newOptions : null);
            } else if (optionsModified && event.isConnectionOptionsModified()) {
                this.fireInetConnectionDeviceOptionsModified(event, InetServState.STATE_NULL.getCode(), event.newOptions);
            }
        } else {
            InetSaServModifyEvent e;
            boolean rerouted;
            int servDeviceId = event.getNewInetServ() != null ? event.getNewInetServ().getDeviceId() : event.getOldInetServ().getDeviceId();
            boolean bl5 = rerouted = this.deviceId != servDeviceId;
            if (rerouted) {
                return;
            }
            if (event.eventType != ServiceActivatorEventType.SERVICE_CANCEL.getCode() || !(event.event instanceof InetSaServModifyEvent) || !((InetSaServModifyEvent)event.event).isInitServ()) {
                if (stateModified) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Changing serv state and/or options");
                    }
                    this.fireInetServDeviceStateAndOptionsModified(event, event.newState, optionsModified ? event.newOptions : null);
                } else if (optionsModified) {
                    this.fireInetServDeviceStateAndOptionsModified(event, InetServState.STATE_NULL.getCode(), event.newOptions);
                }
            }
            if (event.eventType == ServiceActivatorEventType.SERVICE_CANCEL.getCode() && event.event instanceof InetSaServModifyEvent && !((InetSaServModifyEvent)event.event).isInitServ() && (e = (InetSaServModifyEvent)event.event).getNewInetServ() == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Removing serv from the runtime (serviceCancel and not serv reinit)");
                }
                this.access.inetServRuntimeMap.removeRuntimeWithTimout(event.servRuntime);
            }
        }
    }

    private void fireInetServDeviceStateAndOptionsModified(ServiceActivatorEvent event, short newState, Set<Integer> newOptionSet) throws BGException {
        this.getLogger().info("Changing InetServ:" + event.inetServId + " state and/or options");
        try {
            this.inetServDao.updateDeviceStateAndOptions(event.inetServId, newState, newOptionSet, event.accessCode);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Successfully updated serv state and/or options. Sending event to update runtime");
            }
            InetServDeviceStateAndOptionsModifiedEvent inetServDeviceStateAndOptionsModifiedEvent = new InetServDeviceStateAndOptionsModifiedEvent(this.access.moduleId, this.deviceId, event.getInetServRuntime().contractRuntime.contractId, event.inetServId, newState, newOptionSet);
            inetServDeviceStateAndOptionsModifiedEvent.setSource(((Object)((Object)this)).getClass().getSimpleName() + ":fireInetServDeviceStateAndOptionsModified");
            this.ep.publish((Event)inetServDeviceStateAndOptionsModifiedEvent);
        }
        catch (Exception t) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to update state and/or options in the database. Sending task to update later");
            }
            this.ep.publish((Event)new InetServDeviceStateAndOptionsModifyEvent(this.access.moduleId, this.deviceId, event.getInetServRuntime().contractRuntime.contractId, event.inetServId, newState, newOptionSet, event.accessCode));
            this.getLogger().warn(t.getMessage(), (Throwable)t);
        }
        event.servRuntime.setDeviceStateAndOptions(newState, newOptionSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInetConnectionDeviceOptionsModified(ServiceActivatorEvent event, short newState, Set<Integer> newOptionSet) throws BGException {
        InetConnection connection = event.connectionRuntime.connection;
        this.getLogger().info("Changing InetConnection:" + connection.getId() + " state and/or options");
        try {
            this.inetConnectionDao.updateDeviceStateAndOptions(event.connectionRuntime.connection.getDeviceId(), event.connectionRuntime.connection.getId(), newState, newOptionSet, event.accessCode);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Successfully updated device state and/or options. Sending event to update runtime");
            }
            this.ep.publish((Event)new InetConnectionDeviceStateAndOptionsModifiedEvent(this.access.moduleId, this.deviceId, connection.getServId(), connection.getId(), newState, newOptionSet));
        }
        catch (Exception t) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to update state and/or options in the database. Sending task to update later");
            }
            this.ep.publish((Event)new InetConnectionDeviceStateAndOptionsModifyEvent(this.access.moduleId, this.deviceId, connection.getServId(), connection.getId(), newState, newOptionSet, event.accessCode));
            this.getLogger().warn(t.getMessage(), (Throwable)t);
        }
        event.servRuntime.lock();
        try {
            if (newState != InetServState.STATE_NULL.getCode()) {
                connection.setDeviceState(newState);
                InetConnection.setType((InetConnection)connection, (int)8, (boolean)true);
            }
            if (newOptionSet != null) {
                connection.setDeviceOptions(newOptionSet);
            }
        }
        finally {
            event.servRuntime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDevice0(int initDeviceId, int userId) throws BGException {
        int initDeviceId2;
        boolean onAccountingStart;
        EventProcessor ep = EventProcessor.getInstance();
        boolean syncAllPath = this.deviceRuntime.config.getInt(Keys.SA_DEVICE_SYNC_ALL_PATH.key, 1) > 0;
        boolean bl = onAccountingStart = this.deviceRuntime.config.getInt(Keys.SA_DEVICE_SYNC_ON_ACCOUNTING_START.key, 0) > 0;
        if (initDeviceId == -1) {
            initDeviceId = 0;
            initDeviceId2 = -1;
        } else if (initDeviceId <= 0) {
            if (syncAllPath) {
                initDeviceId = 0;
                initDeviceId2 = -1;
            } else {
                initDeviceId = this.deviceId;
                initDeviceId2 = this.deviceId;
            }
        } else {
            initDeviceId2 = initDeviceId;
        }
        for (Integer deviceId : this.deviceRuntime.descendantIds) {
            Object descendant;
            if (deviceId == this.deviceId || (descendant = this.access.deviceMap.get(deviceId)) == null || ((InetDeviceRuntime)descendant).parent == null || ((InetDeviceRuntime)descendant).parent.inetDeviceId != this.deviceId) continue;
            ep.publish((Event)new InetSaDeviceInitEvent(this.moduleId, userId, deviceId.intValue(), initDeviceId2));
        }
        boolean cancelBeforeCreate = this.deviceRuntime.config.getInt(Keys.SA_DEVICE_SYNC_CANCEL_BEFORE_CREATE.key, 1) > 0;
        try {
            ArrayList<InetServRuntime> servRuntimeList = new ArrayList<InetServRuntime>(100);
            for (InetServRuntime servRuntime : this.access.inetServRuntimeMap.values()) {
                InetServ newInetServ = servRuntime.getInetServ();
                if (newInetServ.getDeviceId() != this.deviceId || newInetServ.getParentId() != 0) continue;
                servRuntimeList.add(servRuntime);
            }
            Collections.sort(servRuntimeList, new Comparator<InetServRuntime>(){

                @Override
                public int compare(InetServRuntime o1, InetServRuntime o2) {
                    long o2Time;
                    long o1Time = o1.getDateFromMillis();
                    return o1Time > (o2Time = o2.getDateFromMillis()) ? -1 : (o1Time == o2Time ? 0 : 1);
                }
            });
            long millis = System.currentTimeMillis();
            ArrayList<InetServRuntime> servRuntimeListCurrent = new ArrayList<InetServRuntime>(100);
            ArrayList<InetServRuntime> servRuntimeListNotCurrent = new ArrayList<InetServRuntime>(100);
            for (InetServRuntime servRuntime : servRuntimeList) {
                if (RangeUtils.inRange((long)millis, (long)millis, (long)servRuntime.getDateFromMillis(), (long)servRuntime.getDateToMillis())) {
                    servRuntimeListCurrent.add(servRuntime);
                    continue;
                }
                servRuntimeListNotCurrent.add(servRuntime);
            }
            this.getLogger().info("Data ready for device:" + this.deviceId + ". Wait for device not interactive.");
            Object object = this;
            synchronized (object) {
                this.getLogger().info("Adding tasks for device:" + this.deviceId + ".");
                try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.access.setup, (boolean)true);){
                    for (InetServRuntime servRuntime : servRuntimeListCurrent) {
                        this.initServ(connectionSet, initDeviceId, servRuntime, cancelBeforeCreate, onAccountingStart);
                    }
                    for (InetServRuntime servRuntime : servRuntimeListNotCurrent) {
                        this.initServ(connectionSet, initDeviceId, servRuntime, cancelBeforeCreate, onAccountingStart);
                    }
                }
                this.putLast(new InitEndTask(userId));
            }
        }
        catch (InterruptedException ex) {
            this.logError(ex);
        }
    }

    private void initServ(ConnectionSet connectionSet, int inetServId, int userId) throws BGException {
        boolean onAccountingStart = this.deviceRuntime.config.getInt(Keys.SA_DEVICE_SYNC_ON_ACCOUNTING_START.key, 0) > 0;
        boolean cancelBeforeCreate = this.deviceRuntime.config.getInt(Keys.SA_DEVICE_SYNC_CANCEL_BEFORE_CREATE.key, 1) > 0;
        try {
            InetServRuntime servRuntime = this.access.inetServRuntimeMap.get(inetServId);
            this.initServ(connectionSet, 0, servRuntime, cancelBeforeCreate, onAccountingStart);
        }
        catch (InterruptedException ex) {
            this.logError(ex);
        }
    }

    private void initServ(ConnectionSet connectionSet, int initDeviceId, InetServRuntime servRuntime, boolean cancelBeforeCreate, boolean onAccountingStart) throws InterruptedException, BGException {
        List<InetConnectionRuntime> connectionList;
        InetServ newInetServ = servRuntime.getInetServ();
        if (newInetServ.getDeviceId() != this.deviceId) {
            return;
        }
        List<InetServ> childrenServs = ServiceActivatorEvent.getInetServChildren(this.access.getInetServRuntimeMap(), newInetServ.getId(), 0L);
        newInetServ.setChildren(childrenServs);
        List<InetServOption> inetservOptionList = servRuntime.inetServOptionsList.toList(servRuntime.inetServId);
        if (onAccountingStart && (connectionList = this.access.connectionManager.getByServId(servRuntime.inetServId)) != null) {
            for (InetConnectionRuntime connectionRuntime : connectionList) {
                InetSaAccountingEvent saAccountingEvent = new InetSaAccountingEvent(this.moduleId, newInetServ.getContractId(), connectionRuntime.connection, 1);
                if (this.deviceId == connectionRuntime.connection.getDeviceId()) {
                    this.putFirst(saAccountingEvent);
                    continue;
                }
                this.ep.publish((Event)saAccountingEvent);
            }
        }
        if (TimeUtils.dateInRange((Date)new Date(), (Date)newInetServ.getDateFrom(), (Date)newInetServ.getDateTo())) {
            short newDeviceState = newInetServ.getDeviceState();
            if (newDeviceState == InetServState.STATE_DELETED.getCode()) {
                ConvergenceBalance balance;
                StatusCache statusCache;
                newDeviceState = InetServState.STATE_ENABLE.getCode();
                newDeviceState = newInetServ.getStatus() != InetServStatus.STATUS_ON ? InetServState.STATE_DISABLE.getCode() : (!(statusCache = StatusCache.getInstance()).isModuleActiveStatus(this.moduleId, servRuntime.contractRuntime.getStatus()) ? InetServState.STATE_DISABLE.getCode() : (!(balance = ConvergenceBalanceManager.getInstance().getBalance(connectionSet, Integer.valueOf(newInetServ.getContractId()), System.currentTimeMillis())).isBalanceExceedsLimit() ? InetServState.STATE_DISABLE.getCode() : InetServState.STATE_ENABLE.getCode()));
            }
            InetSaServModifyEvent servCreateEvent = new InetSaServModifyEvent(this.access.moduleId, initDeviceId, null, newInetServ, newDeviceState, inetservOptionList, true);
            this.putFirst(servCreateEvent);
        }
        if (cancelBeforeCreate) {
            InetSaServModifyEvent servCancelEvent = new InetSaServModifyEvent(this.access.moduleId, initDeviceId, newInetServ, null, InetServState.STATE_DELETED.getCode(), inetservOptionList, true);
            this.putFirst(servCancelEvent);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + System.identityHashCode((Object)this);
    }

    public void skipEvent() {
        this.scheduledExecutorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServiceActivatorDeviceWorker serviceActivatorDeviceWorker = ServiceActivatorDeviceWorker.this;
                synchronized (serviceActivatorDeviceWorker) {
                    ServiceActivatorDeviceWorker.this.skipEvent = true;
                    ServiceActivatorDeviceWorker.this.execute();
                }
            }
        });
    }

    private void alarm(BGException ex) {
        try {
            String key = "inet.sa.error.count";
            AlarmSender.sendAlarm((String)"inet.sa.error.count", (long)600000L, (String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 [" + this.deviceRuntime.inetDeviceId + "] " + this.deviceRuntime.inetDevice.getGuiTitle()), (String)ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex1) {
            this.logError(ex1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processDoTaskException(Object task, boolean inDoTask, boolean putFirstIfInDoTask, BGException ex, boolean throwException) throws BGException {
        if (this.errorCount > this.errorAlarmCount) {
            this.alarm(ex);
        }
        if (this.errorCount > this.errorRedeliveryCount) {
            super.processDoTaskException(task, inDoTask, false, ex, false);
            if (!(task instanceof Event)) throw ex;
            Event e = (Event)task;
            if (System.currentTimeMillis() - e.getTimestamp() < this.errorRedeliveryTimeout) {
                ((EventListenerContext)this.context).publishAfterCommit((Event)task);
                this.logError(ex);
                return;
            } else {
                this.logError("Skip old event with error - " + ex.getMessage(), ex);
            }
            return;
        } else if (this.errorCount == this.errorRedeliveryCount) {
            super.processDoTaskException(task, inDoTask, false, ex, throwException);
            return;
        } else {
            super.processDoTaskException(task, inDoTask, putFirstIfInDoTask, ex, throwException);
        }
    }

    protected void taskTimeout(Object task) {
        try {
            if (!(task instanceof Object[])) {
                return;
            }
            Object[] array = (Object[])task;
            if (array.length < 2 || !(array[1] instanceof ServiceActivatorEvent)) {
                return;
            }
            ServiceActivatorEvent event = (ServiceActivatorEvent)array[1];
            InetConnection connection = event.getConnection();
            long connectionId = connection != null ? connection.getId() : 0L;
            this.getLogger().error("Timeout waiting async task (CoA/PoD/terminal/etc response) for inetServId: " + event.getInetServId() + ", connectionId: " + connectionId);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private static class InitEndTask {
        final int userId;

        public InitEndTask(int userId) {
            this.userId = userId;
        }
    }

    static class AsyncEventHolder {
        final Event event;
        final int processDeviceId;

        public AsyncEventHolder(Event event, int deviceId) {
            this.event = event;
            this.processDeviceId = deviceId;
        }
    }
}

