/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionTarifficationManager;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.worker.WorkerTask;

public abstract class AccountingWorkerTask
extends WorkerTask<ServerContext>
implements Lifecycle {
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile ScheduledFuture<?> future;
    private static final Random RANDOM = new Random();
    private volatile long delay;
    protected volatile int batchSize;
    protected String name;
    private volatile ObjectName objectName;
    protected final FrequencyCounter processTimePerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    protected final FrequencyCounter processTimePerTenMinutes = new FrequencyCounter(600L, TimeUnit.SECONDS);
    protected final FrequencyCounter invokePerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    protected final FrequencyCounter invokePerTenMinutes = new FrequencyCounter(600L, TimeUnit.SECONDS);

    public AccountingWorkerTask(int batchSize) {
        this(null, null, 0L, batchSize);
        this.delay = 0L;
    }

    public AccountingWorkerTask(ScheduledExecutorService scheduledExecutorService, String name, long delay, int batchSize) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.name = name;
        this.delay = delay <= 50L ? 50L : delay;
        this.batchSize = batchSize <= 0 ? Integer.MAX_VALUE : batchSize;
    }

    public AccountingWorkerTask(ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, ParameterMap defaultParams) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.name = name;
        long delay = params.getLong("delay.millis", defaultParams.getLong("delay.millis", params.getLong("delay", defaultParams.getLong("delay", 10L)) * 1000L));
        if (delay <= 50L) {
            delay = 50L;
        }
        this.delay = delay;
        this.batchSize = params.getInt("batchSize", defaultParams.getInt("batchSize", 0));
        if (this.batchSize <= 0) {
            this.batchSize = Integer.MAX_VALUE;
        }
    }

    @MBeanAttribute
    public long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        if (delay <= 50L) {
            delay = 50L;
        }
        this.delay = delay;
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), delay / 2L + (long)(RANDOM.nextInt((int)delay / 2) + 1), delay, TimeUnit.MILLISECONDS);
    }

    @MBeanAttribute
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            batchSize = Integer.MAX_VALUE;
        }
        this.batchSize = batchSize;
    }

    public synchronized void start() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.delay / 2L + (long)(RANDOM.nextInt((int)this.delay / 2) + 1), this.delay, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public void init() {
        this.objectName = AnnotatedMBean.register((Object)((Object)this), (String)this.name);
    }

    public void destroy() {
        MBeanUtils.unregisterMBean((ObjectName)this.objectName);
    }

    @MBeanAttribute(description="process time per minute in millis")
    public long getProcessTimePerMinute() {
        return this.processTimePerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute(description="process time per 10 minutes in millis")
    public long getProcessTimePerTenMinutes() {
        return this.processTimePerTenMinutes.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getInvokePerMinute() {
        return this.invokePerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getInvokePerTenMinutes() {
        return this.invokePerTenMinutes.get(System.currentTimeMillis());
    }

    public final boolean process(InetTariffWorkerContext workerContext, ConnectionSet connectionSet, SessionTarifficationManager tarifficationManager, InetConnectionRuntime connectionRuntime, Long hour, long millis, boolean recheckAccountingPeriod, long lockWaitTimeout) {
        Boolean result = this.process0(workerContext, connectionSet, tarifficationManager, connectionRuntime, hour, millis, 1L, recheckAccountingPeriod, lockWaitTimeout, false);
        return !Boolean.FALSE.equals(result);
    }

    protected Boolean process0(InetTariffWorkerContext workerContext, ConnectionSet connectionSet, SessionTarifficationManager tarifficationManager, InetConnectionRuntime connectionRuntime, Long hour, long millis, long minDeltaAmount, boolean recheckAccountingPeriod, long lockWaitTimeout, boolean checkAccountingPeriodError) {
        long trafficDeltaCalculateAmount;
        if (connectionRuntime.calculateType != 0) {
            return Boolean.FALSE;
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("minDeltaAmount = {}", (Object)minDeltaAmount);
            this.getLogger().trace("trafficDeltaCalculateAmount = {}", (Object)connectionRuntime.trafficDeltaCalculateAmount);
        }
        if ((trafficDeltaCalculateAmount = connectionRuntime.trafficDeltaCalculateAmount) < minDeltaAmount || trafficDeltaCalculateAmount == 0L) {
            if (this.getLogger().isTraceEnabled() && connectionRuntime.connection != null) {
                this.getLogger().trace("Skip => trafficDeltaCalculateAmount = {} == 0 || < {}", (Object)trafficDeltaCalculateAmount, (Object)minDeltaAmount);
            }
            return Boolean.FALSE;
        }
        boolean result = tarifficationManager.tarifficate(connectionSet, workerContext, connectionRuntime, millis, recheckAccountingPeriod, lockWaitTimeout, checkAccountingPeriodError);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("Result tarifficationManager.tarifficate(...) = {}", (Object)result);
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }
}

