/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.web;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.WebActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionHelpDeskTable
extends WebActionBase {
    public void doAction() throws Exception {
        boolean packageEnabled;
        boolean nonPackageMode;
        String command = this.getParameter("command", "activetopic");
        this.rootNode.setAttribute("command", command);
        String packageMode = this.getMode();
        if ("off".equals(packageMode)) {
            throw new BGMessageException("\u0423 \u0412\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u044d\u0442\u043e\u0439 \u0444\u0443\u043d\u043a\u0446\u0438\u0438");
        }
        boolean bl = nonPackageMode = !"package".equals(packageMode);
        if (nonPackageMode) {
            this.createElement(this.rootNode, "nonPackageMode");
        }
        if (packageEnabled = "package".equals(packageMode)) {
            this.createElement(this.rootNode, "packages");
        }
        ParamManager paramManager = new ParamManager(this.con, this.plugin);
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        PackageManager packageManager = new PackageManager(this.con, this.plugin);
        Element currentvaluesElement = this.createElement(this.rootNode, "currentvalues");
        if (command.equals("newtopic")) {
            if (packageEnabled && !packageManager.hasActivePackage(this.cid)) {
                this.setError("activePackageNotFound");
            }
            this.setCommData(currentvaluesElement, paramManager.getProperties(this.cid), "topic.");
            this.rootNode.setAttribute("command", command);
        }
        if (command.equals("savetopic")) {
            boolean iserror = false;
            String topic_title = this.getParameter("topic_title");
            String message_body = this.getParameter("message_body");
            int topic_comm = this.getIntParameter("topic.comm.mode", 0);
            if (packageEnabled && !packageManager.hasActivePackage(this.cid)) {
                this.setError("activePackageNotFound");
                iserror = true;
            }
            if (!iserror && (topic_title == null || topic_title.isEmpty())) {
                this.setError("subjectNotEmpty");
                iserror = true;
            }
            if (!iserror && (message_body == null || message_body.isEmpty())) {
                this.setError("bodyNotEmpty");
                throw new BGMessageException("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043a\u0441\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f. ");
            }
            if (!iserror) {
                String topicCommValue = "";
                if (topic_comm == 1) {
                    topicCommValue = this.getParameter("topic.comm.phone.value", "");
                } else if (topic_comm == 2) {
                    topicCommValue = this.getParameter("topic.comm.email.value", "");
                } else if (topic_comm == 3) {
                    topicCommValue = this.getParameter("topic.comm.sms.value", "");
                } else if (topic_comm == 4) {
                    topicCommValue = this.getParameter("topic.comm.telegram.value", "");
                }
                Topic topic = new Topic();
                topic.setContractId(this.cid);
                topic.setClosed(false);
                topic.setComm(topic_comm);
                topic.setCommValue(topicCommValue);
                topic.setDate(new Date());
                BigDecimal cost = this.plugin.getSetup().getBigDecimal("topic.default.cost." + this.cid, null);
                if (cost == null) {
                    cost = this.plugin.getSetup().getBigDecimal("topic.default.cost", new BigDecimal("0.00"));
                }
                topic.setCost(cost);
                topic.setTitle(topic_title);
                topic.setAutoClose(this.plugin.getSetup().getBoolean("topic.avto.closed.default", false));
                topicManager.updateTopic(topic);
                Message message = Message.builder().setTopicId(topic.getId()).setBody(message_body).setDateFrom(new Date()).setUserIdFrom(0).build();
                topicManager.updateTopicMessage(message);
                this.fileUploadRequest(message);
                while (packageEnabled) {
                    PackageContract pkg = packageManager.getActivePackageContract(this.cid);
                    if (pkg == null) {
                        this.setError("activePackageNotFound");
                        iserror = true;
                        break;
                    }
                    if (packageManager.updatePackageContractCount(pkg.getId(), pkg.getCountUse(), 1) != 1) continue;
                    topicManager.updateTopicPackage(topic.getId(), pkg.getId());
                    break;
                }
                if (!iserror) {
                    String url = "webexecuter?action=Topic&module=ru.bitel.bgbilling.plugins.helpdesk&mid=0&id=" + topic.getId();
                    try {
                        this.getResponse().sendRedirect(url);
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }
            this.rootNode.setAttribute("command", "newtopic");
            currentvaluesElement.setAttribute("topic_title", topic_title);
            currentvaluesElement.setAttribute("message_body", message_body);
            this.setCommData(currentvaluesElement, this.getCommData("topic."), "topic.");
        } else if (command.equals("activetopic") || command.equals("archivetopic")) {
            Boolean iclosed = !command.equals("activetopic");
            int tid = this.getIntParameter("tid", -1);
            String topicName = this.getParameter("topic");
            String searchString = this.getParameter("searchString");
            Period period = this.getPeriod();
            if (tid > 0) {
                this.rootNode.setAttribute("tid", ((Object)tid).toString());
            }
            this.rootNode.setAttribute("topic", topicName);
            this.rootNode.setAttribute("searchString", searchString);
            this.rootNode.setAttribute("date1", this.getParameter("date1"));
            this.rootNode.setAttribute("date2", this.getParameter("date2"));
            Element tableTopic = this.createElement(this.rootNode, "tableTopic");
            TopicListFilter topicListFilter = new TopicListFilter();
            topicListFilter.setContractId(this.cid);
            topicListFilter.setClosed(iclosed);
            topicListFilter.setPage(new Page(1, -1));
            topicListFilter.setAllMessage(false);
            topicListFilter.setNewUserMessage(false);
            topicListFilter.setNewManagerMessage(true);
            topicListFilter.setTopicId(tid);
            topicListFilter.setTitle(topicName);
            topicListFilter.setPeriod(period);
            topicListFilter.setSearchString(searchString);
            List<Topic> topicList = topicManager.getTopicList(topicListFilter);
            for (Topic topic : topicList) {
                Element row = this.createElement(tableTopic, "row");
                row.setAttribute("id", String.valueOf(topic.getId()));
                row.setAttribute("title", topic.getTitle());
                row.setAttribute("cid", String.valueOf(topic.getContractId()));
                row.setAttribute("closed", String.valueOf(topic.isClosed()));
                row.setAttribute("date", TimeUtils.format((Date)topic.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
                row.setAttribute("dateClose", TimeUtils.format((Date)topic.getDateClose(), (String)"dd.MM.yyyy HH:mm:ss"));
                row.setAttribute("cost", Utils.formatBigDecimalSumm((BigDecimal)topic.getCost()));
                row.setAttribute("comm", String.valueOf(topic.getComm()));
                row.setAttribute("comm_value", topic.getCommValue());
                row.setAttribute("haveNewMsg", String.valueOf(topic.getMessageNewManagerCount() > 0));
                row.setAttribute("status", topic.isClosed() ? "\u0437\u0430\u043a\u0440\u044b\u0442\u0430" : "\u043e\u0442\u043a\u0440\u044b\u0442\u0430");
                row.setAttribute("inpackage", topic.getContractPackageId() < 0 ? "\u043d\u0435\u0442" : "\u0434\u0430");
                row.setAttribute("type", topicManager.getStatusName(topic.getStatus()));
            }
        }
    }
}

