/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.common.bean;

import java.net.IDN;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.hd.common.bean.ZoneUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;

public class Zone
extends Id {
    private int contractId = -1;
    private String zone = null;
    private String zonePunycode = null;
    private String comment = null;
    private String config = null;
    private String data = null;
    private Period period = null;
    private boolean loadWhois = true;
    private boolean avto = true;
    private Date whoisLastUpdate = null;
    private Date lastUpdate = null;
    private Date freeDate = null;
    private String registrar = null;
    private Map<String, String> paramsMap = new LinkedHashMap<String, String>();

    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
        this.zonePunycode = IDN.toASCII(zone);
    }

    public String getZonePunycode() {
        return this.zonePunycode;
    }

    public void setZonePunycode(String zonePunycode) {
        this.zonePunycode = zonePunycode;
        this.zone = IDN.toUnicode(zonePunycode);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getConfig() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.paramsMap.keySet()) {
            sb.append(str);
            sb.append("=");
            sb.append(this.paramsMap.get(str));
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void setConfig(String config) {
        this.config = config;
        this.paramsMap.clear();
        this.updateMap(config);
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public boolean isLoadWhois() {
        return this.loadWhois;
    }

    public void setLoadWhois(boolean loadWhois) {
        this.loadWhois = loadWhois;
    }

    public Date getWhoisLastUpdate() {
        return this.whoisLastUpdate;
    }

    public void setWhoisLastUpdate(Date whoisLastUpdate) {
        this.whoisLastUpdate = whoisLastUpdate;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Date getFreeDate() {
        return this.freeDate;
    }

    public void setFreeDate(Date freeDate) {
        this.freeDate = freeDate;
    }

    public String getRegistrar() {
        return this.registrar;
    }

    public void setRegistrar(String registrar) {
        this.registrar = registrar;
    }

    public boolean isAvto() {
        return this.avto;
    }

    public void setAvto(boolean avto) {
        this.avto = avto;
    }

    public Map<String, String> getParamsMap() {
        return this.paramsMap;
    }

    private void updateMap(String config) {
        String[] params = config.split("\n");
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i].split("=");
            String key = param[0];
            if (!Utils.notBlankString((String)key)) continue;
            String value = null;
            try {
                value = param[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.paramsMap.put(key, value);
        }
    }

    public void updateConfigValue(String key, String value) {
        if (this.config != null && key != null && value != null) {
            Logger logger = new BGLogger().getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("key = " + key);
                logger.debug("value = " + value);
                logger.debug("config = " + this.config);
            }
            StringBuilder result = new StringBuilder("");
            int pos = this.config.indexOf(key + "=");
            if (logger.isDebugEnabled()) {
                logger.debug("pos = " + pos);
            }
            if (pos != -1) {
                int tmpValLen = 0;
                int pos1 = pos + key.length() + 1;
                String tmpVal = this.getConfigValue(key);
                if (logger.isDebugEnabled()) {
                    logger.debug("oldValue = " + tmpVal);
                }
                if (tmpVal != null) {
                    tmpValLen = tmpVal.length();
                }
                result.append(this.config.substring(0, pos1)).append(value);
                if (pos1 + tmpValLen < this.config.length()) {
                    result.append(this.config.substring(pos1 + tmpValLen, this.config.length()));
                }
            } else if (!value.equals("")) {
                result.append(this.config).append(this.config.endsWith("\n") ? "" : "\n").append(key).append("=").append(value).append("\n");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("result = " + result.toString());
            }
            this.setConfig(result.toString());
        }
    }

    public String getConfigValue(String key) {
        return ZoneUtils.getConfigValue(this.config, key);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

