/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatusLogItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class DocumentStatusDao
extends AbstractDao<DocumentStatus>
implements Directory<DocumentStatus> {
    private static final String LOG_TABLE = "documents_status_log";

    public DocumentStatusDao(Connection con) {
        super(con, -1, "documents_status");
    }

    protected void updateImpl(DocumentStatus b) throws BGException {
        boolean update = b.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            if (update) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (!update) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public DocumentStatus get(int id) throws BGException {
        DocumentStatus result = null;
        try {
            result = (DocumentStatus)this.getById(id);
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public List<DocumentStatus> list() throws BGException {
        return this.list("", "id", new Object[0]);
    }

    public List<DocumentStatusLogItem> getStatusHistory(int documentId) throws BGException {
        ArrayList<DocumentStatusLogItem> result = new ArrayList<DocumentStatusLogItem>();
        String query = "SELECT * FROM documents_status_log WHERE id_document=" + documentId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(DocumentStatusLogItem.builder().setId(rs.getInt("id")).setDocumentId(rs.getInt("id_document")).setStatusId(rs.getInt("status")).setStatusDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date"))).setComment(rs.getString("comment")).setUserId(rs.getInt("user")).build());
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public int delete(int id) throws Exception {
        return this.deleteImpl(id);
    }

    public void addStatusLog(DocumentStatusLogItem item) throws BGException {
        String query = "INSERT INTO documents_status_log(id_document, date, status, comment, user) VALUES ( ?,?,?,?,? )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, item.getDocumentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)item.getStatusDate()));
            ps.setInt(index++, item.getStatusId());
            ps.setString(index++, item.getComment());
            ps.setInt(index++, item.getUserId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public DocumentStatus get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected DocumentStatus getFromRS(ResultSet rs) throws SQLException, BGException {
        return new DocumentStatus(rs.getInt("id"), rs.getString("title"));
    }
}

