/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Check {
    protected BigDecimal paymentsum = BigDecimal.valueOf(0L, 2);
    protected List<CheckLine> lines = new ArrayList<CheckLine>();
    protected Integer paymentType = null;
    protected Integer tax = null;
    protected String customerEmail = null;
    protected boolean onlyElCheck = false;
    protected Map<Integer, Object> customTags = new HashMap<Integer, Object>();
    protected Integer payMethod = null;
    protected Integer payObject = null;
    protected Type checkType = null;
    protected String cashierName = null;
    protected String cashierINN = null;
    protected Date documentDate = null;
    protected String documentId = null;
    public static final String CUT_TEXT_COMMAND = "!CUT%)";
    public static final int OFD_TAG_SUPPLIER_INFO_PHONES = 100001171;
    public static final int OFD_TAG_SUPPLIER_INFO_NAME = 100001225;
    public static final int OFD_TAG_SUPPLIER_INFO_INN = 100001226;
    public static final int OFD_TAG_AGENT_INFO_TYPE = 100001222;
    public static final int OFD_TAG_INTERNET = 1125;
    public static final int OFD_TAG_TIMEZONE = 1011;
    public static final int PAY_CASH = 1001;
    public static final int PAY_CARD = 1002;
    public static final int PAY_PREPAYMENT = 1003;
    public static final int PAY_CREDIT = 1004;
    public static final int PAY_OTHER = 1005;
    public static final int VAT_NO = 1000999;
    public static final int VAT_0 = 1000000;
    public static final int VAT_10 = 1000010;
    public static final int VAT_18 = 1000018;
    public static final int VAT_110 = 1000110;
    public static final int VAT_118 = 1000118;
    public static final int VAT_20 = 1000020;
    public static final int VAT_120 = 1000120;
    public static final int VAT_22 = 1000022;
    public static final int VAT_122 = 1000122;
    public static final int VAT_5 = 1000005;
    public static final int VAT_105 = 1000105;
    public static final int VAT_7 = 1000007;
    public static final int VAT_107 = 1000107;
    public static final int PAYMETHOD_FULL_PREPAYMENT = 1214001;
    public static final int PAYMETHOD_PREPAYMENT = 1214002;
    public static final int PAYMETHOD_ADVANCE = 1214003;
    public static final int PAYMETHOD_FULL_PAYMENT = 1214004;
    public static final int PAYMETHOD_PARTIAL_PAYMENT = 1214005;
    public static final int PAYMETHOD_CREDIT = 1214006;
    public static final int PAYMETHOD_CREDIT_PAYMENT = 1214007;
    public static final int PAYOBJECT_COMMODITY = 1212001;
    public static final int PAYOBJECT_JOB = 1212003;
    public static final int PAYOBJECT_SERVICE = 1212004;
    public static final int PAYOBJECT_PAYMENT = 1212010;
    public static final int PAYOBJECT_AGENT_COMMISSION = 1212011;
    public static final int PAYOBJECT_ANOTHER = 1212013;

    public Check(Type checkType) {
        this();
        this.checkType = checkType;
    }

    public Check() {
    }

    public void addString(String string) {
        this.lines.add(new CheckLine(null, string, -1));
    }

    public void addPayment(BigDecimal summa, String string, int dep) {
        this.addPayment(summa, string, dep, null, null);
    }

    public void addPayment(BigDecimal summa, String string, int dep, Integer payMethod, Integer payObject) {
        this.addPayment(summa, string, dep, payMethod, payObject, null);
    }

    protected static BigDecimal _roundSum(BigDecimal summa) {
        summa = summa.setScale(2, RoundingMode.HALF_UP);
        return summa;
    }

    public void addPayment(BigDecimal summa, String string, int dep, Integer payMethod, Integer payObject, Integer tax) {
        if (summa == null) {
            throw new BGRuntimeException("addPayment.summa must not be null");
        }
        summa = Check._roundSum(summa);
        this.lines.add(new CheckLine(summa, string, dep, payMethod, payObject, tax));
        this.paymentsum = this.paymentsum.add(summa);
    }

    private CheckLine _last_CheckLine() {
        if (this.lines.size() < 1) {
            throw new BGRuntimeException("no last line/paymentposition");
        }
        CheckLine lastline = this.lines.get(this.lines.size() - 1);
        if (lastline.summa == null) {
            throw new BGRuntimeException("last line isnt paymentposition (string?)");
        }
        return lastline;
    }

    public void setLastPaymentTag(int tag, String value) {
        this._last_CheckLine().customTags.put(tag, value);
    }

    public void setLastPaymentTag(int tag, long value) {
        this._last_CheckLine().customTags.put(tag, value);
    }

    public void setLastPaymentTag(int tag, byte[] value) {
        this._last_CheckLine().customTags.put(tag, value);
    }

    public void setLastPaymentTag(int tag, STAG value) {
        this._last_CheckLine().customTags.put(tag, value);
    }

    public void setLastPaymentPayMethod(int payMethod) {
        this._last_CheckLine().payMethod = payMethod;
    }

    public void setLastPaymentPayObject(int payObject) {
        this._last_CheckLine().payObject = payObject;
    }

    public void setLastPaymentTax(int tax) {
        this._last_CheckLine().tax = tax;
    }

    public void setPaymentType(int paymentType) {
        this.paymentType = paymentType;
    }

    public void setTax(int tax) {
        this.tax = tax;
    }

    public void setOnlyElCheck(boolean onlyElCheck) {
        this.onlyElCheck = onlyElCheck;
    }

    public boolean isOnlyElCheck() {
        return this.onlyElCheck;
    }

    private void _add_pline(List<String> plines, String v1, String v2, String v3) {
        plines.add(v1 != null ? v1.trim() : "NULL");
        plines.add(v2 != null ? v2.replace('\r', ' ').replace('\n', ' ').trim() : "NULL");
        plines.add(v3 != null ? v3.trim() : "NULL");
    }

    private void _add_pline(List<String> plines, String v1, String v2) {
        this._add_pline(plines, v1, v2, "");
    }

    private String _CUSTOMTAG_encode(int ktag, Object vtag) {
        Object svtag = null;
        if (vtag instanceof Long) {
            svtag = String.valueOf(vtag);
        } else if (vtag instanceof String) {
            svtag = "\"" + vtag + "\"";
        } else if (vtag instanceof byte[]) {
            svtag = "\"0x" + Utils.bytesToString((byte[])((byte[])vtag), (boolean)true, (String)"") + "\"";
        } else if (vtag instanceof STAG) {
            svtag = ((STAG)vtag).toJson();
        } else {
            throw new RuntimeException("error custom tag type");
        }
        return String.valueOf(ktag) + ";" + (String)svtag;
    }

    public List<String> getPlines() {
        ArrayList<String> plines = new ArrayList<String>();
        for (CheckLine checkLine : this.lines) {
            if (checkLine.summa == null) {
                this._add_pline(plines, "STRING", checkLine.text);
                continue;
            }
            this._add_pline(plines, checkLine.summa.toPlainString(), checkLine.text, String.valueOf(checkLine.dep));
            if (checkLine.payMethod != null) {
                this._add_pline(plines, "PAYMETHOD_ITEM", String.valueOf(checkLine.payMethod));
            }
            if (checkLine.payObject != null) {
                this._add_pline(plines, "PAYOBJECT_ITEM", String.valueOf(checkLine.payObject));
            }
            if (checkLine.tax != null) {
                this._add_pline(plines, "TAX_ITEM", String.valueOf(checkLine.tax));
            }
            for (Map.Entry<Integer, Object> tagOperation : checkLine.customTags.entrySet()) {
                int ktag = tagOperation.getKey();
                Object vtag = tagOperation.getValue();
                this._add_pline(plines, "CUSTOMTAG_ITEM", this._CUSTOMTAG_encode(ktag, vtag));
            }
        }
        if (this.customerEmail != null) {
            this._add_pline(plines, "CUSTOMEREMAIL", this.customerEmail);
        }
        if (this.tax != null) {
            this._add_pline(plines, "TAX", String.valueOf(this.tax));
        }
        if (this.onlyElCheck) {
            this._add_pline(plines, "ONLYELCHECK", "TRUE");
        }
        if (this.paymentType != null) {
            this._add_pline(plines, "PAYMENTTYPE", String.valueOf(this.paymentType));
        }
        if (this.payMethod != null) {
            this._add_pline(plines, "PAYMETHOD", String.valueOf(this.payMethod));
        }
        if (this.payObject != null) {
            this._add_pline(plines, "PAYOBJECT", String.valueOf(this.payObject));
        }
        if (this.checkType != null) {
            this._add_pline(plines, "CHECKTYPE", this.checkType.name());
        }
        if (this.cashierName != null) {
            this._add_pline(plines, "CASHIERNAME", this.cashierName);
        }
        if (this.cashierINN != null) {
            this._add_pline(plines, "CASHIERINN", this.cashierINN);
        }
        if (this.documentDate != null) {
            this._add_pline(plines, "DOCUMENTDATE", TimeUtils.format((Date)this.documentDate, (String)"dd.MM.yyyy HH:mm:ss"));
        }
        if (this.documentId != null) {
            this._add_pline(plines, "DOCUMENTID", this.documentId);
        }
        for (Map.Entry entry : this.customTags.entrySet()) {
            int ktag = (Integer)entry.getKey();
            Object vtag = entry.getValue();
            this._add_pline(plines, "CUSTOMTAG", this._CUSTOMTAG_encode(ktag, vtag));
        }
        return plines;
    }

    public BigDecimal getPaymentsum() {
        return this.paymentsum;
    }

    public List<CheckLine> getLines() {
        return this.lines;
    }

    public Integer getPaymentType() {
        return this.paymentType;
    }

    public Integer getTax() {
        return this.tax;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public void setTag(int tag, String value) {
        this.customTags.put(tag, value);
    }

    public void setTag(int tag, long value) {
        this.customTags.put(tag, value);
    }

    public void setTag(int tag, byte[] value) {
        this.customTags.put(tag, value);
    }

    public void setTag(int tag, STAG value) {
        this.customTags.put(tag, value);
    }

    @Deprecated
    public void setPayMethod(int payMethod) {
        this.payMethod = payMethod;
    }

    @Deprecated
    public void setPayObject(int payObject) {
        this.payObject = payObject;
    }

    public Integer getPayMethod() {
        return this.payMethod;
    }

    public Integer getPayObject() {
        return this.payObject;
    }

    public Type getCheckType() {
        return this.checkType;
    }

    public void setCheckType(Type checkType) {
        this.checkType = checkType;
    }

    public Map<Integer, Object> getCustomTags() {
        return this.customTags;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    public void setCashierINN(String cashierINN) {
        this.cashierINN = cashierINN;
    }

    public String getCashierName() {
        return this.cashierName;
    }

    public String getCashierINN() {
        return this.cashierINN;
    }

    public String getCheckData() {
        StringBuilder sb = new StringBuilder(6666);
        for (String paramItemList : this.getPlines()) {
            sb.append(paramItemList != null ? paramItemList.toString() : "NULL").append("\n");
        }
        return sb.toString();
    }

    public Date getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(Date documentDate) {
        this.documentDate = documentDate;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(int documentId) {
        this.documentId = String.valueOf(documentId);
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    protected static void _CUSTOMTAG_decode(String t, Map<Integer, Object> customTags) {
        String[] tv = t.split(";");
        if (tv.length == 2) {
            int tag = Integer.parseInt(tv[0]);
            String svtag = tv[1];
            if (svtag.startsWith("\"0x")) {
                svtag = svtag.substring(3, svtag.length() - 1);
                byte[] value = Utils.stringToBytes((String)svtag, (String)"");
                customTags.put(tag, value);
            } else if (svtag.startsWith("\"")) {
                svtag = svtag.substring(1, svtag.length() - 1);
                customTags.put(tag, svtag);
            } else if (svtag.startsWith("{")) {
                customTags.put(tag, STAG.fromJson(svtag));
            } else {
                customTags.put(tag, Long.parseLong(svtag));
            }
        }
    }

    public static Check processCommandCheckParameters(String[] parameters, Logger logger) throws BGException {
        Check commandCheckParameters = new Check();
        BigDecimal summa = BigDecimal.valueOf(0L, 2);
        for (int i = 2; i < parameters.length; i += 3) {
            String s = parameters[i];
            String t = parameters[i + 1];
            String d = parameters[i + 2];
            if ("STRING".equals(s)) {
                commandCheckParameters.lines.add(new CheckLine(null, t, -1));
                if (logger == null) continue;
                logger.debug("Driver: TEXT: " + t);
                continue;
            }
            if ("CUSTOMEREMAIL".equals(s)) {
                commandCheckParameters.customerEmail = t;
                if (logger == null) continue;
                logger.debug("Driver: CUSTOMER EMAIL: " + t);
                continue;
            }
            if ("TAX".equals(s)) {
                commandCheckParameters.tax = Integer.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: TAX: " + t);
                continue;
            }
            if ("PAYMENTTYPE".equals(s)) {
                commandCheckParameters.paymentType = Integer.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: PAYMENT TYPE: " + t);
                continue;
            }
            if ("ONLYELCHECK".equals(s)) {
                commandCheckParameters.onlyElCheck = Utils.parseBoolean((String)t, (boolean)false);
                if (logger == null) continue;
                logger.debug("Driver: ONLYELCHECK: " + t);
                continue;
            }
            if ("CUSTOMTAG".equals(s)) {
                Check._CUSTOMTAG_decode(t, commandCheckParameters.customTags);
                if (logger == null) continue;
                logger.debug("Driver: CUSTOMTAG: " + t);
                continue;
            }
            if ("PAYMETHOD".equals(s)) {
                commandCheckParameters.payMethod = Integer.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: PAY METHOD: " + t);
                continue;
            }
            if ("PAYOBJECT".equals(s)) {
                commandCheckParameters.payObject = Integer.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: PAY OBJECT: " + t);
                continue;
            }
            if ("CHECKTYPE".equals(s)) {
                commandCheckParameters.checkType = Type.valueOf(t);
                if (logger == null) continue;
                logger.debug("Driver: CHECK TYPE: " + t);
                continue;
            }
            if ("CASHIERNAME".equals(s)) {
                commandCheckParameters.cashierName = t;
                if (logger == null) continue;
                logger.debug("Driver: CASHIER NAME: " + t);
                continue;
            }
            if ("CASHIERINN".equals(s)) {
                commandCheckParameters.cashierINN = t;
                if (logger == null) continue;
                logger.debug("Driver: CASHIER INN: " + t);
                continue;
            }
            if ("DOCUMENTDATE".equals(s)) {
                commandCheckParameters.documentDate = TimeUtils.parseDate((String)t, (String)"dd.MM.yyyy HH:mm:ss");
                if (logger == null) continue;
                logger.debug("Driver: DOCUMENT DATE: " + t);
                continue;
            }
            if ("DOCUMENTID".equals(s)) {
                commandCheckParameters.documentId = t;
                if (logger == null) continue;
                logger.debug("Driver: DOCUMENT ID: " + t);
                continue;
            }
            if ("PAYMETHOD_ITEM".equals(s)) {
                int PAYMETHOD_value = Integer.parseInt(t);
                if (logger != null) {
                    logger.debug("Driver: PAYMETHOD_ITEM: " + PAYMETHOD_value);
                }
                commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).payMethod = PAYMETHOD_value;
                continue;
            }
            if ("PAYOBJECT_ITEM".equals(s)) {
                int PAYOBJECT_value = Integer.parseInt(t);
                if (logger != null) {
                    logger.debug("Driver: PAYOBJECT_ITEM: " + PAYOBJECT_value);
                }
                commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).payObject = PAYOBJECT_value;
                continue;
            }
            if ("TAX_ITEM".equals(s)) {
                int TAX_value = Integer.parseInt(t);
                if (logger != null) {
                    logger.debug("Driver: TAX_ITEM: " + TAX_value);
                }
                commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).tax = TAX_value;
                continue;
            }
            if ("CUSTOMTAG_ITEM".equals(s)) {
                if (logger != null) {
                    logger.debug("Driver: CUSTOMTAG_ITEM: " + t);
                }
                Check._CUSTOMTAG_decode(t, commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).customTags);
                continue;
            }
            if (!d.isEmpty()) {
                BigDecimal sum = new BigDecimal(s);
                sum = Check._roundSum(sum);
                int dep = Integer.parseInt(d);
                commandCheckParameters.lines.add(new CheckLine(sum, t, dep));
                if (logger != null) {
                    logger.debug("Driver: SALE: sum=" + s + ";txt=" + t + ";dep=" + dep);
                }
                summa = summa.add(sum);
                continue;
            }
            if (logger == null) continue;
            logger.error("Driver: UNKNOWN TAG: " + s + "|" + t + "|" + d);
        }
        commandCheckParameters.paymentsum = summa;
        return commandCheckParameters;
    }

    public static enum Type {
        PAYMENT,
        PAYMENTREFUND,
        PAYMENTCORRECTION,
        PAYMENTREFUNDCORRECTION;

    }

    public static class CheckLine {
        public BigDecimal summa;
        public String text;
        public int dep;
        public Integer payMethod = null;
        public Integer payObject = null;
        public Integer tax = null;
        public Map<Integer, Object> customTags = new HashMap<Integer, Object>();

        public CheckLine(BigDecimal summa, String text, int dep) {
            this(summa, text, dep, null, null);
        }

        public CheckLine(BigDecimal summa, String text, int dep, Integer payMethod, Integer payObject) {
            this(summa, text, dep, payMethod, payObject, null);
        }

        public CheckLine(BigDecimal summa, String text, int dep, Integer payMethod, Integer payObject, Integer tax) {
            this.summa = summa;
            this.text = text;
            this.dep = dep;
            this.payMethod = payMethod;
            this.payObject = payObject;
            this.tax = tax;
        }

        public BigDecimal getSumma() {
            return this.summa;
        }

        public String getText() {
            return this.text;
        }

        public int getDep() {
            return this.dep;
        }

        public String toString() {
            return "[" + (this.summa != null ? this.summa.toPlainString() : null) + "," + this.text + "," + this.dep + "]@" + Integer.toHexString(this.hashCode());
        }
    }

    public static class STAG
    extends HashMap<Integer, Object> {
        public String toJson() {
            JSONObject vtag_data = new JSONObject((Map)this);
            return vtag_data.toString(0);
        }

        public static STAG fromJson(String svtag) {
            JSONTokener tokener = new JSONTokener(svtag);
            JSONObject tag_val = (JSONObject)tokener.nextValue();
            STAG stag = new STAG();
            for (Map.Entry tag : tag_val.toMap().entrySet()) {
                int tag_n = Integer.parseInt((String)tag.getKey());
                Object tag_v = tag.getValue();
                if (tag_v instanceof Long) {
                    stag.tag(tag_n, (Long)tag_v);
                    continue;
                }
                if (tag_v instanceof Integer) {
                    stag.tag(tag_n, ((Integer)tag_v).intValue());
                    continue;
                }
                if (tag_v instanceof String) {
                    stag.tag(tag_n, (String)tag_v);
                    continue;
                }
                if (tag_v instanceof ArrayList) {
                    stag.tag(tag_n, STAG._ArrayList_to_bytes((ArrayList)tag_v));
                    continue;
                }
                throw new BGRuntimeException("error tag type " + tag_v.getClass());
            }
            return stag;
        }

        private static byte[] _ArrayList_to_bytes(ArrayList<?> array) {
            byte[] bytearray = new byte[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                bytearray[i] = ((Integer)array.get(i)).byteValue();
            }
            return bytearray;
        }

        public void tag(int tag, String value) {
            this.put(tag, value);
        }

        public void tag(int tag, long value) {
            this.put(tag, value);
        }

        public void tag(int tag, byte[] value) {
            this.put(tag, value);
        }
    }
}

