/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotDialogConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.Utils;

public abstract class ExportImport {
    protected BotManagerService botManagerService;
    protected DynamicCodeService dynamicCodeService;
    protected BotDialogConfigurePanel parentPanel;
    private String approveButtonText;
    private String titleOfDialogWindows;

    protected ExportImport(BotDialogConfigurePanel parentPanel, String titleOfDialogWindows, String approveButtonText) {
        this.botManagerService = (BotManagerService)((ClientContext)parentPanel.getContext()).getPort(BotManagerService.class, ((ClientContext)parentPanel.getContext()).getModuleId());
        this.dynamicCodeService = (DynamicCodeService)((ClientContext)parentPanel.getContext()).getPort(DynamicCodeService.class, 0);
        this.parentPanel = parentPanel;
        this.approveButtonText = approveButtonText;
        this.titleOfDialogWindows = titleOfDialogWindows;
    }

    public void showDialog() {
        JFileChooser fileChooser = this.configureFileChooser(this.titleOfDialogWindows);
        try {
            int response = fileChooser.showDialog((Component)((Object)this.parentPanel), this.approveButtonText);
            if (response == 0) {
                this.process(fileChooser);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private JFileChooser configureFileChooser(String titleDialog) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(Utils.maskBlank((String)titleDialog, (String)""));
        fileChooser.setFileFilter(new ExportImportFileFilter());
        this.configurateFileChooser(fileChooser);
        return fileChooser;
    }

    protected abstract void configurateFileChooser(JFileChooser var1);

    protected abstract void process(JFileChooser var1) throws Exception;

    private static final class ExportImportFileFilter
    extends FileFilter {
        private ExportImportFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".bm");
        }

        @Override
        public String getDescription() {
            return "(*.bm)";
        }
    }
}

