/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotDialogConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotDialogSelectDialogProcessingPanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotDialogSelectGroupPanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.ElementsListCellRenderer;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.ElementsListTransferHandler;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.event.DialogElementUpdateEvent;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.event.OpenDialogEditorEvent;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;

public class BotDialogEditor
extends JPanel
implements EventSubscriber<DialogElementUpdateEvent> {
    private final JTextField titleDialog = new JTextField();
    private JPanel elementsOfDialogPanel;
    private final JTextField command = new JTextField();
    private final JCheckBox onlySigned = new JCheckBox("\u0421\u0434\u0435\u043b\u0430\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u043c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c");
    private BGUList<BotDialogElement> dialogElements;
    private BotDialogSelectGroupPanel selectGroupPanel;
    private BotDialogSelectDialogProcessingPanel selectDialogProcessingPanel;
    private BotDialog currentDialog;
    private BotConfigurePanel botConfigurePanel;
    private BotDialogConfigurePanel botDialogConfigurePanel;

    public BotDialogEditor(final BotConfigurePanel botConfigurePanel, BotDialogConfigurePanel botDialogConfigurePanel) throws Exception {
        this.botConfigurePanel = botConfigurePanel;
        this.botDialogConfigurePanel = botDialogConfigurePanel;
        this.setVisible(false);
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u0438\u0430\u043b\u043e\u0433\u0430");
        this.selectGroupPanel = new BotDialogSelectGroupPanel(botConfigurePanel.getBotManagerService());
        this.selectDialogProcessingPanel = new BotDialogSelectDialogProcessingPanel(botConfigurePanel.getBotManagerService());
        JToggleButton selectGroupButton = new JToggleButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c/\u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0438\u0430\u043b\u043e\u0433 \u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b");
        selectGroupButton.setActionCommand("selectGroupButton");
        JToggleButton selectDialogProcessing = new JToggleButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441-\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a");
        selectDialogProcessing.setActionCommand("selectDialogProcessing");
        ActionListener toggleButtonListener = e -> {
            boolean isSelected = ((AbstractButton)e.getSource()).isSelected();
            this.elementsOfDialogPanel.setVisible(!isSelected);
            if (e.getActionCommand().equals("selectGroupButton")) {
                this.selectGroupPanel.setVisible(isSelected);
            } else if (e.getActionCommand().equals("selectDialogProcessing")) {
                this.selectDialogProcessingPanel.setVisible(isSelected);
            }
        };
        selectGroupButton.addActionListener(toggleButtonListener);
        selectDialogProcessing.addActionListener(toggleButtonListener);
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432").addActionListener(e -> {
            BotDialogElement selectedElement = (BotDialogElement)this.dialogElements.getSelectedValue();
            if (selectedElement != null) {
                botConfigurePanel.selectElementOnElementPanel(selectedElement);
            }
        });
        popupMenu.add("\u0423\u0431\u0440\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430").addActionListener(e -> {
            BotDialogElement selectedElement = (BotDialogElement)this.dialogElements.getSelectedValue();
            if (selectedElement != null) {
                this.dialogElements.getModel().removeElement(selectedElement);
            }
        });
        this.dialogElements = new BGUList();
        this.dialogElements.setSelectionMode(0);
        this.dialogElements.setModel(new DefaultListModel());
        this.dialogElements.setCellRenderer((ListCellRenderer)new ElementsListCellRenderer(botConfigurePanel.getBotManagerService().getDialogs()));
        this.dialogElements.setTransferHandler((TransferHandler)new ElementsListTransferHandler());
        this.dialogElements.setDragEnabled(true);
        this.dialogElements.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BotDialogElement selectedElement;
                if (e.getClickCount() == 1 && e.getButton() == 3) {
                    popupMenu.show((Component)BotDialogEditor.this.dialogElements, e.getX(), e.getY());
                } else if (e.getClickCount() == 2 && e.getButton() == 1 && (selectedElement = (BotDialogElement)BotDialogEditor.this.dialogElements.getSelectedValue()) != null) {
                    botConfigurePanel.openDialogElementEditor(selectedElement);
                }
            }
        });
        JScrollPane elementsOfDialogScrollPane = new JScrollPane();
        elementsOfDialogScrollPane.setHorizontalScrollBarPolicy(31);
        elementsOfDialogScrollPane.getViewport().add((Component)this.dialogElements);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("ok")) {
                if (this.saveDialog()) {
                    botDialogConfigurePanel.showListDialogPanel(true);
                }
            } else if (actionCommand.equals("cancel")) {
                botDialogConfigurePanel.showListDialogPanel(true);
                EventBus.publish((Object)new OpenDialogEditorEvent(null, false));
            }
            if (selectGroupButton.isSelected()) {
                selectGroupButton.doClick();
            }
            if (selectDialogProcessing.isSelected()) {
                selectDialogProcessing.doClick();
            }
        });
        JLabel helpLabel = new JLabel("(\u041f\u0435\u0440\u0435\u0442\u0430\u0449\u0438\u0442\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u0438\u0430\u043b\u043e\u0433\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430)");
        helpLabel.setFont(new Font("Monospaced", 2, 11));
        this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)this.titleDialog, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)selectGroupButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)selectDialogProcessing, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u041a\u043e\u043c\u0430\u043d\u0434\u0430"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)BGSwingUtilites.createHelpLabel((String)"\u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u043c\u043e\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0431\u0443\u0434\u0435\u0442 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0434\u0430\u043d\u043d\u044b\u0439 \u0434\u0438\u0430\u043b\u043e\u0433. \u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \"/command\"", (int)-1), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 0, 3), 0, 0));
        this.add((Component)this.command, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.elementsOfDialogPanel = new JPanel(new GridBagLayout());
        this.elementsOfDialogPanel.add((Component)this.onlySigned, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        this.elementsOfDialogPanel.add((Component)new JLabel("\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0434\u0438\u0430\u043b\u043e\u0433\u0430"), new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.elementsOfDialogPanel.add((Component)helpLabel, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 13, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.elementsOfDialogPanel.add((Component)elementsOfDialogScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 3), 0, 0));
        this.add((Component)this.elementsOfDialogPanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 0), 0, 0));
        this.add((Component)((Object)this.selectGroupPanel), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.selectDialogProcessingPanel), new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 0, 3), 0, 0));
        EventBus.subscribe(DialogElementUpdateEvent.class, (EventSubscriber)this);
    }

    public void onEvent(DialogElementUpdateEvent event) {
        BotDialogElement dialogElement = event.getElement();
        if (dialogElement != null && this.currentDialog != null && this.currentDialog.getDialogElements().contains(dialogElement)) {
            this.currentDialog.getDialogElements().remove(dialogElement);
            this.openEditor(this.currentDialog);
        }
    }

    public void openEditor(BotDialog dialog) {
        if (dialog != null) {
            this.currentDialog = dialog;
            this.titleDialog.setText(dialog.getTitle());
            this.dialogElements.setData(dialog.getDialogElements());
            this.onlySigned.setSelected(dialog.isOnlySignedUser());
            this.command.setText(dialog.getCommand());
        } else {
            this.currentDialog = null;
            this.titleDialog.setText("");
            this.command.setText("");
            this.dialogElements.setData(Collections.emptyList());
            this.onlySigned.setSelected(false);
        }
        this.selectGroupPanel.performAction("refresh");
        this.selectGroupPanel.setCurrentDialog(this.currentDialog);
        this.selectDialogProcessingPanel.performAction("refresh");
        this.selectDialogProcessingPanel.setProcessingClass(this.currentDialog);
        this.botDialogConfigurePanel.showListDialogPanel(false);
    }

    private boolean saveDialog() {
        String title = this.titleDialog.getText();
        if (Utils.isBlankString((String)title)) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0438\u043c\u044f \u0434\u0438\u0430\u043b\u043e\u0433\u0430");
            return false;
        }
        ArrayList<BotDialogElement> elements = Collections.list(this.dialogElements.getModel().elements());
        if (Utils.isEmptyCollection(elements)) {
            ClientUtils.showErrorMessageDialog((String)"\u0414\u0438\u0430\u043b\u043e\u0433 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u0435\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432");
            return false;
        }
        if (this.currentDialog == null) {
            this.currentDialog = new BotDialog();
        }
        this.currentDialog.setTitle(this.titleDialog.getText());
        this.currentDialog.setDialogElements(elements);
        this.currentDialog.setGroups(this.selectGroupPanel.getSelectedGroupsOfCurrentDialog());
        this.currentDialog.setProcessingClass(this.selectDialogProcessingPanel.getSelectedPathToProcessingClass());
        this.currentDialog.setOnlySignedUser(this.onlySigned.isSelected());
        Object commandText = this.command.getText();
        if (Utils.notBlankString((String)commandText) && !((String)commandText).startsWith("/")) {
            commandText = "/" + (String)commandText;
        }
        this.currentDialog.setCommand((String)commandText);
        try {
            for (BotDialogElement element : elements) {
                element.getDialogIds().add(this.currentDialog.getId());
            }
            this.botConfigurePanel.getBotManagerService().updateDialogElements(elements);
            this.botConfigurePanel.getBotManagerService().updateDialog(this.currentDialog);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return false;
        }
        this.botDialogConfigurePanel.performAction("refresh");
        return true;
    }
}

