/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.common.service;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.MTOM;
import java.math.BigDecimal;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.DocTypes;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentPosition;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.InvoiceDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.NumerationPool;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.BillPositionType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLink;
import ru.bitel.bgbilling.modules.bill.common.export.BillExportInfo;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.LoggableService;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@MTOM
@WebService
@XmlSeeAlso(value={BillDocument.class, DocType.class, BankAccount.class, DocumentPosition.class, IdTitle.class, KeyValue.class})
public interface BillService
extends LoggableService {
    public Result<BillDocument> billDocumentListForContract(@WebParam(name="contractId") int var1, @WebParam(name="page") Page var2) throws BGException;

    public void billDelete(@WebParam(name="billIds") List<Integer> var1) throws BGException;

    public void billDocumentDelete(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2, @WebParam(name="customer") boolean var3) throws BGException;

    public List<DocType> documentSpecListForCustomer(@WebParam(name="contractId") int var1) throws BGException;

    public List<BankAccount> bankAccountList() throws BGException;

    public List<DocumentPosition> templateDocumentPositionList(@WebParam(name="contractId") int var1, @WebParam(name="documentSpecId") int var2, @WebParam(name="year") int var3, @WebParam(name="month") int var4) throws BGException;

    public int billDocumentCreate(@WebParam(name="contractId") int var1, @WebParam(name="documentSpecId") int var2, @WebParam(name="bankAccountId") int var3, @WebParam(name="year") int var4, @WebParam(name="month") int var5, @WebParam(name="documentPositionList") List<DocumentPosition> var6) throws BGException;

    public FileDto billDocumentDownload(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2) throws BGException;

    public Result<InvoiceDocument> invoiceDocumentListForContract(@WebParam(name="contractId") int var1, @WebParam(name="onlyReady") boolean var2, @WebParam(name="page") Page var3) throws BGException;

    public void invoiceDelete(@WebParam(name="invoiceIds") List<Integer> var1) throws BGException;

    public FileDto invoiceDocumentDownload(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2) throws BGException;

    @WebMethod
    public List<BankAccount> getBankAccountList(int var1, Boolean var2) throws BGException;

    @WebMethod
    public BankAccount getDefaultBankAccount(int var1) throws BGException;

    @WebMethod
    public void setDefaultBankAccount(BankAccount var1) throws BGException;

    @WebMethod
    public List<IdTitle> getBankAccountTitleList(int var1, int var2, Boolean var3, Holder<Integer> var4) throws BGException;

    @WebMethod
    public void setBankAccount(@WebParam(name="contractId") int var1, @WebParam(name="bankAccountId") int var2) throws BGException;

    @WebMethod
    public void copyBankAccount(@WebParam(name="fromContractId") int var1, @WebParam(name="toContractId") int var2) throws BGException;

    @WebMethod
    public void updateBankAccount(BankAccount var1) throws BGException;

    @WebMethod
    public void deleteBankAccount(int var1) throws BGException;

    @WebMethod
    public BankAccount getBankAccount(int var1) throws BGException;

    @WebMethod
    public List<Organization> getOrganizationList() throws BGException;

    @WebMethod
    public Organization getDefaultOrganization() throws BGException;

    @WebMethod
    public Organization getOrganization(int var1) throws BGException;

    @WebMethod
    public void updateOrganization(Organization var1) throws BGException;

    @WebMethod
    public void deleteOrganization(int var1) throws BGException;

    @WebMethod
    public void setDefaultOrganization(int var1) throws BGException;

    @WebMethod
    public List<IdTitle> getOrganizationTitleList(int var1, Boolean var2, Holder<Integer> var3) throws BGException;

    @WebMethod
    public void setOrganization(@WebParam(name="contractId") int var1, @WebParam(name="organizationId") int var2) throws BGException;

    @WebMethod
    public void copyOrganization(@WebParam(name="fromContractId") int var1, @WebParam(name="toContractId") int var2) throws BGException;

    @WebMethod
    public List<DocType> docTypeList(DocumentType var1) throws BGException;

    @WebMethod
    public List<DocType> docTypeListForContract(int var1, DocumentType var2) throws BGException;

    @WebMethod
    public DocType docTypeGet(int var1) throws BGException;

    @WebMethod
    public void docTypeUpdate(DocType var1) throws BGException;

    @WebMethod
    public void docTypeDelete(int var1) throws BGException;

    @WebMethod
    public List<IdTitle> positionList(DocumentType var1) throws BGException;

    @WebMethod
    public MapHolder<Integer, List<IdTitle>> xmlComposition() throws BGException;

    @WebMethod
    public SearchResult<Position> searchPositionList(DocumentType var1, Page var2) throws BGException;

    @WebMethod
    public Position positionGet(@WebParam(name="documentType") DocumentType var1, @WebParam(name="positionId") int var2) throws BGException;

    @WebMethod
    public Position positionUpdate(DocumentType var1, Position var2) throws BGException;

    @WebMethod
    public boolean positionDelete(@WebParam(name="documentType") DocumentType var1, @WebParam(name="positionId") int var2) throws BGException;

    @WebMethod
    public void sendDocsForAll(@WebParam(name="senderTaskParameters") DocumentSendParameters var1) throws BGException;

    @WebMethod
    public void sendDocs(@WebParam(name="senderTaskParameters") DocumentSendParameters var1) throws BGException;

    public List<AttributeType> attributeTypeList() throws BGException;

    public void attributeTypeUpdate(@WebParam(name="attributeType") AttributeType var1) throws BGException;

    public void attributeTypeDelete(@WebParam(name="attributeTypeId") int var1) throws BGException;

    public List<Attribute> attributeList(@WebParam(name="contractId") int var1) throws BGException;

    public void attributeUpdate(@WebParam(name="contractId") int var1, @WebParam(name="attribute") Attribute var2) throws BGException;

    public void attributeDelete(@WebParam(name="contractId") int var1, @WebParam(name="attributeId") int var2) throws BGException;

    @WebMethod
    public List<String> positionSearch(@WebParam(name="billPositionType") BillPositionType var1, @WebParam(name="page") Page var2) throws BGException;

    @WebMethod
    public void positionDataUpdate(@WebParam(name="billPositionType") BillPositionType var1, @WebParam(name="positionData") String var2) throws BGException;

    @WebMethod
    public void positionDataDelete(@WebParam(name="billPositionType") BillPositionType var1, @WebParam(name="key") String var2) throws BGException;

    @WebMethod
    public void numerationPoolUpdate(@WebParam(name="numerationPool") NumerationPool var1) throws BGException;

    @WebMethod
    public void numerationPoolDelete(@WebParam(name="id") int var1) throws BGException;

    @WebMethod
    public NumerationPool numerationPoolGet(@WebParam(name="id") int var1) throws BGException;

    @WebMethod
    public List<NumerationPool> numerationPoolList() throws BGException;

    @WebMethod
    public DocTypes documentTypes(@WebParam(name="contractId") int var1, @WebParam(name="documentType") DocumentType var2) throws BGException;

    @WebMethod
    public List<IdTitle> docTypeTitles(@WebParam(name="contractId") int var1, @WebParam(name="documentType") DocumentType var2) throws BGException;

    @WebMethod
    public List<IdTitle> contractParameters() throws BGException;

    @WebMethod
    public BigDecimal rateVATGet() throws BGException;

    @WebMethod
    public List<KeyValue> exportFormats(@WebParam(name="docType") String var1) throws BGException;

    @WebMethod
    public BillExportInfo exportInfo(@WebParam(name="exportKey") String var1) throws BGException;

    @WebMethod
    public String billExport(@WebParam(name="exportClass") String var1, @WebParam(name="billListFilter") BillListFilter var2, @WebParam(name="saveOnServer") boolean var3) throws BGException;

    @WebMethod
    public List<BillLink> billLinkList() throws BGException;

    @WebMethod
    public void billLinkUpdate(BillLink var1) throws BGException;
}

