/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class DocTypeManager {
    private Connection con;
    private String tableName;

    public DocTypeManager(Connection con, int moduleId) {
        this.con = con;
        this.tableName = "bill_doc_type_" + moduleId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocType getType(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE id=" + id);){
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            DocType docType = DocTypeManager.getTypeFromRs(rs);
            return docType;
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public Map<Integer, DocType> getTypeMap() throws BGException {
        HashMap<Integer, DocType> result = new HashMap<Integer, DocType>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocType type = DocTypeManager.getTypeFromRs(rs);
                result.put(type.getId(), type);
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<DocType> getTypeList(DocumentType documentType) throws BGException {
        ArrayList<DocType> result = new ArrayList<DocType>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE type=? ORDER BY title");){
            ps.setInt(1, documentType.getCode());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(DocTypeManager.getTypeFromRs(rs));
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void updateType(DocType type) throws BGException {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " ( title, pos_list, comment, pattern, opt, setup, npid, xmlConsist, type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(9, type.getDocumentType().getCode());
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, pos_list=?, comment=?, pattern=?, opt=?, setup=?, npid=?, xmlConsist=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(9, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setString(2, Utils.toString((Iterable)type.getPositionList()));
            ps.setString(3, type.getComment());
            ps.setString(4, type.getPattern());
            int options = type.isCreateWhenLessOrEqZero() ? 1 : 0;
            options |= (type.isSubContractPositions() ? 1 : 0) << 1;
            options |= (type.isCreateWhenStronglyLessZero() ? 1 : 0) << 2;
            ps.setInt(5, options |= (type.isNSubContractPositions() ? 1 : 0) << 3);
            ps.setString(6, type.getSetupString());
            ps.setInt(7, type.getNpid());
            ps.setString(8, Utils.toString((Iterable)type.getXmlContractConsist()) + ";" + Utils.toString((Iterable)type.getXmlModulesConsist()) + ";" + Utils.toString((Iterable)type.getXmlPluginsConsist()));
            ps.executeUpdate();
            if (type.getId() <= 0) {
                type.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteType(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=" + id);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public static DocType getTypeFromRs(ResultSet rs) throws SQLException {
        int options = rs.getInt("opt");
        DocType result = DocType.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setComment(rs.getString("comment")).setDocumentType(rs.getInt("type") == 1 ? DocumentType.BILL : DocumentType.INVOICE).setPositionList(Utils.toIntegerSet((String)rs.getString("pos_list"))).setPattern(rs.getString("pattern")).setSetupString(rs.getString("setup")).setCreateWhenLessOrEqZero((options & 1) > 0).setSubContractPositions((options & 2) > 0).setCreateWhenStronglyLessZero((options & 4) > 0).setNSubContractPositions((options & 8) > 0).setNpid(rs.getInt("npid")).build();
        String xmlConsist = rs.getString("xmlConsist");
        if (xmlConsist != null) {
            int index = 0;
            int posS = 0;
            int posE = xmlConsist.indexOf(59, posS + 1);
            while (posE > -1) {
                String token = xmlConsist.substring(posS, posE);
                switch (index) {
                    case 0: {
                        result.setXmlContractConsist(Utils.toIntegerSet((String)token));
                        break;
                    }
                    case 1: {
                        result.setXmlModulesConsist(Utils.toIntegerSet((String)token));
                        break;
                    }
                    case 3: {
                        result.setXmlPluginsConsist(Utils.toIntegerSet((String)token));
                    }
                }
                ++index;
                posS = posE + 1;
                posE = xmlConsist.indexOf(59, posS);
            }
            if (xmlConsist.endsWith(";")) {
                result.setXmlPluginsConsist(Collections.emptySet());
            }
        }
        return result;
    }
}

