/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.agr.server.bean;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.agr.common.bean.AGREnvironment;
import ru.bitel.bgbilling.modules.agr.common.bean.Transaction;
import ru.bitel.bgbilling.modules.agr.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final String TABLE_NAME = "agr_transaction";
    protected static final String CONTRACT = "{CONTRACT}";
    protected static final String TRANSACTION_ID = "{TRANSACTION_ID}";

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, TABLE_NAME);
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, SearchParam searchParam, String agrPaymentName) throws SQLException {
        if (searchResult != null) {
            String status = searchParam.getStatus();
            status = Utils.maskBlank((String)status, (String)TransactionStatus.ALL.getCode());
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS agr.*, c.title, c.comment FROM " + this.tableName + " AS agr LEFT JOIN contract c ON c.id=agr.contractId WHERE true";
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query = query + " AND agr.createDate>=?";
                }
                if (period.getDateTo() != null) {
                    query = query + " AND agr.createDate<=?";
                }
            }
            if (!TransactionStatus.ALL.getCode().equals(status)) {
                query = query + " AND agr.status=?";
            }
            if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                query = query + " AND c.title LIKE ?";
            }
            if (searchParam.getContractId() > 0) {
                query = query + " AND c.id=" + searchParam.getContractId();
            }
            if (Utils.notBlankString((String)agrPaymentName)) {
                query = query + " AND agr.agrPaymentName=?";
            }
            query = query + this.sqlLimit(page);
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                if (!TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                    ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                }
                if (Utils.notBlankString((String)agrPaymentName)) {
                    ps.setString(index++, agrPaymentName);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                    if (page != null) {
                        page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                    }
                    BigDecimal totalSum = BigDecimal.ZERO;
                    for (Transaction transaction : list) {
                        totalSum = totalSum.add(transaction.getSum());
                    }
                    searchResult.setSum(totalSum);
                }
            }
        }
    }

    public Transaction getTransaction(int transactionId) throws SQLException {
        return (Transaction)this.getById(transactionId);
    }

    protected String getQueryById() {
        return "SELECT agr.*, c.title, c.comment FROM " + this.tableName + " AS agr LEFT JOIN contract AS c ON c.id=agr.contractId WHERE agr.id=?";
    }

    public Transaction getTransaction(String agrTransactionId) throws SQLException {
        Transaction result = null;
        if (Utils.notBlankString((String)agrTransactionId)) {
            String query = "SELECT agr.*, c.title, c.comment FROM " + this.tableName + " AS agr LEFT JOIN contract AS c ON c.id=agr.contractId WHERE agrPaymentId=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setString(1, agrTransactionId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result = this.getFromRS(rs);
                    }
                }
            }
        }
        return result;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        Transaction result = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("agr.id"))).setContractId(rs.getInt("agr.contractId"))).setContractTitle(rs.getString("c.title"))).setContractComment(rs.getString("c.comment"))).setSum(rs.getBigDecimal("agr.sum"))).setStatus(rs.getString("agr.status"))).setTransactionId(rs.getString("agr.agrPaymentId"))).setPaymentId(rs.getInt("agr.paymentId"))).setAgrPaymentName(rs.getString("agr.agrPaymentName")).setCreateDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("agr.createDate")))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("agr.paymentDate")))).setEnvironment(rs.getInt("agr.environment") == 0 ? AGREnvironment.live : AGREnvironment.sandbox).build();
        return result;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contractId=?, sum=?, status=?, createDate=?, paymentDate=?, agrPaymentId=?, agrPaymentName=?, paymentId=?, environment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setString(index++, transaction.getStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getAgrPaymentName());
            if (transaction.getPaymentId() > 0) {
                ps.setInt(index++, transaction.getPaymentId());
            } else {
                ps.setNull(index++, 4);
            }
            ps.setInt(index++, transaction.getEnvironment().ordinal());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public List<IdTitle> getAGRPaymentSystemList() throws SQLException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        String query = "SELECT agrPaymentName FROM " + this.tableName + " agr GROUP BY agrPaymentName";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(new IdTitle(0, rs.getString(1)));
            }
        }
        return result;
    }

    public void deleteTransactionByContractId(int contractId) throws SQLException {
        this.delete("contractId=?", new Object[]{contractId});
    }

    public String getRedirectUrl(int contractId, String contractTitle, BigDecimal amount, Map<String, Object> dataMap, ModuleSetup moduleSetup) throws Exception {
        String agrMode;
        this.getLogger().debug("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 {} [#{}] \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 {}", new Object[]{contractTitle, contractId, amount.toString()});
        int vendorId = moduleSetup.getInt("agr.vendor.id", -1);
        this.getLogger().debug("\tvendorId = {}", (Object)vendorId);
        if (vendorId < 1) {
            this.getLogger().error("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 vendorId");
            dataMap.put("errorCode", 1);
            dataMap.put("errorMessage", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 vendorId");
            return null;
        }
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setSum(amount)).setCreateDate(new Date())).setStatus(TransactionStatus.NEW.getCode())).build();
        this.update(transaction);
        this.getLogger().debug("\t\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c {}", (Object)transaction.getId());
        String currency = moduleSetup.get("agr.currency", "sum");
        DecimalFormat decimalFormat = new DecimalFormat(moduleSetup.get("agr.transaction.format", "BG000000000"));
        String merchantTransId = decimalFormat.format(transaction.getId());
        String transactionComment = moduleSetup.get("agr.transaction.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {CONTRACT}. \u041a\u043e\u0434 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 {TRANSACTION_ID}");
        if (transactionComment.contains(TRANSACTION_ID)) {
            transactionComment = transactionComment.replace(TRANSACTION_ID, merchantTransId);
        }
        if (transactionComment.contains(CONTRACT)) {
            if (contractTitle == null) {
                try (ContractDao contractDao = new ContractDao(this.con, 0);){
                    contractTitle = ((Contract)contractDao.get(contractId)).getTitle();
                }
            }
            transactionComment = transactionComment.replace(CONTRACT, contractTitle);
        }
        long signTime = System.currentTimeMillis();
        String string2Sign = vendorId + merchantTransId + amount + currency + signTime;
        String secret = moduleSetup.get("agr.secret");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\t\u0421\u0442\u0440\u043e\u043a\u0430 \u0434\u043b\u044f \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438: {}", (Object)(secret + string2Sign));
        }
        String sign = Utils.getDigest((String)(secret + string2Sign), (String)"UTF-8");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\t\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u043c\u0435\u0440\u0435\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430: VENDOR_ID = {}; MERCHANT_TRANS_ID = {}; MERCHANT_TRANS_AMOUNT = {}; MERCHANT_CURRENCY = {}; MERCHANT_TRANS_NOTE = {}; SIGN_TIME = {}; SIGN_STRING = {};", new Object[]{vendorId, merchantTransId, amount.toString(), currency, transactionComment, signTime, sign});
        }
        StringBuilder redirectUrl = new StringBuilder(("sandbox".equals(agrMode = moduleSetup.get("agr.mode", "sandbox")) ? "https://agr.uz/sandbox" : "https://agr.uz/pay") + "?");
        this.addRequestParamPair(redirectUrl, "VENDOR_ID", String.valueOf(vendorId));
        this.addRequestParamPair(redirectUrl, "MERCHANT_TRANS_ID", merchantTransId);
        this.addRequestParamPair(redirectUrl, "MERCHANT_TRANS_AMOUNT", amount.toString());
        this.addRequestParamPair(redirectUrl, "MERCHANT_CURRENCY", currency);
        this.addRequestParamPair(redirectUrl, "MERCHANT_TRANS_NOTE", transactionComment);
        this.addRequestParamPair(redirectUrl, "SIGN_TIME", String.valueOf(signTime));
        this.addRequestParamPair(redirectUrl, "SIGN_STRING", sign);
        this.getLogger().debug("\t Redirect Url: {}", (Object)redirectUrl.toString());
        dataMap.put("formUrl", redirectUrl.toString());
        return (String)dataMap.get("formUrl");
    }

    private void addRequestParamPair(StringBuilder request, String name, String value) throws UnsupportedEncodingException {
        if (value != null) {
            request.append(URLEncoder.encode(name, "UTF-8"));
            request.append("=");
            request.append(URLEncoder.encode(value, "UTF-8"));
            request.append("&");
        }
    }
}

