/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.bean;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.common.bean.emuns.PaymentType;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.YoomoneyPaymentType;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static Pattern pcontr = Pattern.compile("\\$\\{contract\\}");
    private static Pattern pcontrComment = Pattern.compile("\\$\\{contract_comment\\}");
    private static Pattern pOrderSumAmount = Pattern.compile("\\$\\{orderSumAmount\\}");
    private static Pattern pShopSumAmount = Pattern.compile("\\$\\{shopSumAmount\\}");
    private static Pattern pDate = Pattern.compile("\\$\\{date\\}");
    private static Pattern pPaymentPayerCode = Pattern.compile("\\$\\{paymentPayerCode\\}");
    static final Map<String, String> PAYMENT_DATA = new HashMap<String, String>(){
        {
            this.put("/id", "yoomoney.id");
            this.put("/payment_method/type", "yoomoney.payment_method.type");
            this.put("/payment_method/sbp_operation_id", "yoomoney.sbp_operation_id");
            this.put("/payment_method/payer_bank_details/bank_id", "yoomoney.payer.bank_id");
            this.put("/payment_method/payer_bank_details/bic", "yoomoney.payer.bic");
            this.put("/payment_method/title", "yoomoney.title");
            this.put("/payment_method/card/card_type", "yoomoney.card_type");
            this.put("/payment_method/card/first6", "yoomoney.card_first6");
            this.put("/payment_method/card/last4", "yoomoney.card_last4");
            this.put("/payment_method/card/expiry_month", "yoomoney.card_expiry_month");
            this.put("/payment_method/card/expiry_year", "yoomoney.card_expiry_year");
            this.put("/payment_method/card/issuer_country", "yoomoney.card_issuer_country");
            this.put("/payment_method/card/issuer_name", "yoomoney.card_issuer_name");
        }
    };

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "yoomoney_transactions");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("paymentDateTime", "paymentDateTime");
        this.fields.put("invoiceId", "invoiceId");
        this.fields.put("shopSumAmount", "shopSumAmount");
    }

    public void searchTransactionList(SearchResult<Transaction> searchResult, SearchParam searchParam) throws BGException {
        if (searchResult != null) {
            ResultSet rs;
            int index;
            PreparedStatement ps;
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
            }
            boolean typeFilter = searchParam.getType() != null && PaymentType.NO_SELECT != searchParam.getType();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract ON contract.id=pt.contract_id WHERE true").append(this.queryPeriod(period, "pt.paymentDateTime"));
            this.queryId(query, searchParam.getRecordId());
            this.queryStatus(query, searchParam.getStatus());
            query.append(typeFilter ? " AND pt.autopayment=?" : "");
            if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                query.append(" AND contract.title LIKE ?");
            }
            if (searchParam.getContractId() > 0) {
                query.append(" AND pt.contract_id=").append(searchParam.getContractId());
            }
            String selectQuery = "SELECT SUM(pt.shopSumAmount), SUM(pt.transaction_sum), COUNT(*) " + query.toString();
            try {
                ps = this.con.prepareStatement(selectQuery);
                try {
                    index = 1;
                    index = this.psSetPeriod(ps, index, period);
                    index = this.psSetId(ps, index, searchParam.getRecordId());
                    index = this.psSetStatus(ps, index, searchParam.getStatus());
                    if (typeFilter) {
                        ps.setBoolean(index++, PaymentType.AUTO == searchParam.getType());
                    }
                    if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                        ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                    }
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            BigDecimal sumShop = rs.getBigDecimal(1);
                            BigDecimal sumOrder = rs.getBigDecimal(2);
                            if (sumShop != null && sumOrder != null) {
                                searchResult.setSum(sumShop.compareTo(BigDecimal.ZERO) == 0 ? sumOrder : sumShop);
                            }
                            page.setRecordCount(rs.getInt(3));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
            if (page.getPageIndex() > page.getPageCount()) {
                page.setPageIndex(page.getPageCount());
            }
            selectQuery = "SELECT pt.*, contract.title, contract.comment AS con_comment" + query.toString() + this.getSQLOrder(sort, this.fields) + this.sqlLimit(page);
            try {
                ps = this.con.prepareStatement(selectQuery);
                try {
                    index = 1;
                    index = this.psSetPeriod(ps, index, period);
                    index = this.psSetId(ps, index, searchParam.getRecordId());
                    index = this.psSetStatus(ps, index, searchParam.getStatus());
                    if (typeFilter) {
                        ps.setBoolean(index++, PaymentType.AUTO == searchParam.getType());
                    }
                    if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                        ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                    }
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            list.add(this.getFromRS(rs));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> getCheckIds(int intervalMinute) throws BGException {
        String query = "SELECT yoomoneyId FROM " + this.tableName + " WHERE status='pending' AND payment_id < 1 AND paymentDateTime < DATE_SUB( NOW(), INTERVAL " + intervalMinute + " MINUTE)";
        try (Statement st = this.con.createStatement();){
            ArrayList<String> arrayList;
            block15: {
                ResultSet rs = st.executeQuery(query);
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    while (rs.next()) {
                        list.add(rs.getString(1));
                    }
                    arrayList = list;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public Transaction getTransactionForInvoice(long invoiceId) throws BGException {
        Transaction transaction = null;
        String query = "SELECT payment.*, contract.title, contract.comment AS con_comment FROM " + this.tableName + " AS payment LEFT JOIN contract ON contract.id=payment.contract_id WHERE payment.invoiceId=" + invoiceId;
        try (Statement ps = this.con.createStatement();
             ResultSet rs = ps.executeQuery(query);){
            if (rs.next() && rs.next()) {
                transaction = this.getFromRS(rs);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return transaction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transaction getTransactionByYoomoneyId(String yoomoneyId) throws BGException {
        if (Utils.isBlankString((String)yoomoneyId)) {
            return null;
        }
        String query = "SELECT payment.*, contract.title, contract.comment AS con_comment FROM " + this.tableName + " AS payment LEFT JOIN contract ON contract.id=payment.contract_id WHERE payment.yoomoneyId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, yoomoneyId);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                Transaction transaction = this.getFromRS(rs);
                return transaction;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Transaction getTransactionByPaymentId(int paymentId) throws SQLException {
        return (Transaction)this.get("payment_id=?", new Object[]{paymentId});
    }

    public int getFirstYear(int contractId) throws SQLException {
        String query = "SELECT MIN(paymentDateTime) FROM " + this.tableName + " WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            Date date = null;
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    date = rs.getDate(1);
                }
            }
            int n = (date != null ? TimeUtils.convertDateToCalendar((java.util.Date)date) : new GregorianCalendar()).get(1);
            return n;
        }
    }

    public void deleteTransaction(int id) throws SQLException {
        try (Statement st = this.con.createStatement();){
            st.executeUpdate("DELETE FROM " + this.tableName + " WHERE id=" + id);
        }
    }

    @Deprecated
    public void carryOutPayment(Transaction transaction) throws Exception {
        if (transaction != null) {
            int paymentType = this.moduleSetup.getInt("yoomoney.payment.type.id", this.moduleSetup.getInt("paymenttype", 0));
            String paymentComment = this.formatComment(this.moduleSetup.get("yoomoney.payment.comment", this.moduleSetup.get("paymentCommentPattern", "\u041f\u043b\u0430\u0442\u0451\u0436 \u0447\u0435\u0440\u0435\u0437 \u042eKassa")), transaction);
            boolean isOrderSumAmount = "order".equals(this.moduleSetup.get("yoomoney.payment.sum.amount", this.moduleSetup.get("paymentSumAmount", null)));
            Payment payment = Payment.builder().setContractId(transaction.getContractId()).setTypeId(paymentType).setDate(transaction.getTransactionDate()).setSum(isOrderSumAmount ? transaction.getSum() : transaction.getShopSumAmount()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(paymentComment).build();
            new PaymentDao(this.con).update((Object)payment);
            transaction.setPaymentId(payment.getId());
            this.update(transaction);
            ServerUtils.commitConnection((Connection)this.con);
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                bu.updateBalance(payment.getDate(), transaction.getContractId());
            }
            ServerUtils.commitConnection((Connection)this.con);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
        }
    }

    public String formatComment(String pattern, Transaction transaction) {
        String desc = pOrderSumAmount.matcher(pattern).replaceAll(transaction.getSum() != null ? transaction.getSum().toString() : "?");
        desc = pShopSumAmount.matcher(desc).replaceAll(transaction.getShopSumAmount() != null ? transaction.getShopSumAmount().toString() : "?");
        desc = pDate.matcher(desc).replaceAll(TimeUtils.format((java.util.Date)transaction.getTransactionDate(), (String)"dd.MM.yyyy HH:mm:ss"));
        if (pcontr.matcher(desc = pPaymentPayerCode.matcher(desc).replaceAll(transaction.getPaymentPayerCode() != null ? transaction.getPaymentPayerCode() : "?")).matches() || pcontrComment.matcher(desc).matches()) {
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                Contract contract = (Contract)contractDao.get(transaction.getContractId());
                if (contract != null) {
                    desc = pcontr.matcher(desc).replaceAll(contract.getTitle() != null ? contract.getTitle() : "?");
                    desc = pcontrComment.matcher(desc).replaceAll(contract.getComment() != null ? contract.getComment() : "?");
                }
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        return desc;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        BGTransactionType type = switch (rs.getString("paymentType")) {
            case "bank_card" -> BGTransactionType.CARD;
            case "sbp" -> BGTransactionType.QR_SBP;
            default -> BGTransactionType.OTHER;
        };
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setAutopayment(rs.getBoolean("autopayment"))).setSum(rs.getBigDecimal("transaction_sum"))).setShopSumAmount(rs.getBigDecimal("shopSumAmount")).setPaymentPayerCode(rs.getString("paymentPayerCode")).setTransactionDate((java.util.Date)rs.getTimestamp("paymentDateTime"))).setTransactionType(type)).setPaymentType(rs.getString("paymentType")).setRawRequest(rs.getString("rawRequest")).setPaymentId(rs.getInt("payment_id"))).setStatus(rs.getString("status"))).setYoomoneyId(rs.getString("yoomoneyId")).setContractTitle(rs.getString("contract.title"))).setContractComment(rs.getString("con_comment"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, yoomoneyId=?, transaction_sum=?, paymentDateTime=?, paymentType=?, payment_id=?, status=?, rawRequest=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setString(index++, transaction.getYoomoneyId());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getPaymentType());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getRawRequest());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        connection.setConnectTimeout(moduleSetup.getInt("yoomoney.connect.timeout", 5000));
        connection.setReadTimeout(moduleSetup.getInt("yoomoney.read.timeout", 3000));
    }

    public JSONObject getPaymentRequestJSON(BigDecimal sum, int contractId, String contractTitle, String autoId, YoomoneyPaymentType paymentType) throws BGException {
        JSONObject amount = new JSONObject().put("value", (Object)sum.toPlainString()).put("currency", (Object)"RUB");
        JSONObject metadata = new JSONObject().put("contractId", contractId);
        if (autoId != null) {
            metadata.put("autopayment", true);
        }
        JSONObject receipt = null;
        if (this.moduleSetup.getBoolean("yoomoney.fiscalization.enable", false)) {
            String customerAddress = ContractModuleConfigDao.getPaymentCheckAddress((Connection)this.con, (int)this.moduleId, (int)contractId);
            JSONObject customer = new JSONObject();
            if (!Utils.isBlankString((String)customerAddress)) {
                customer.put(customerAddress.contains("@") ? "email" : "phone", (Object)customerAddress);
            }
            JSONObject itemAmount = new JSONObject().put("value", (Object)sum.setScale(2, RoundingMode.HALF_UP).toPlainString().replace(',', '.')).put("currency", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.currency", "RUB"));
            JSONObject item = new JSONObject().put("description", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle)).put("quantity", (Object)String.valueOf(this.moduleSetup.getInt("yoomoney.fiscalization.receipt.qty", 1))).put("amount", (Object)itemAmount).put("vat_code", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.vat_code", 1)).put("payment_mode", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.method.type", "full_prepayment")).put("payment_subject", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.subject.type", "service"));
            int taxSystemCode = this.moduleSetup.getInt("yoomoney.fiscalization.receipt.tax.system", 0);
            receipt = new JSONObject().put("customer", (Object)customer).put("tax_system_code", (Object)(taxSystemCode > 0 ? Integer.valueOf(taxSystemCode) : null)).put("items", (Object)new JSONArray().put((Object)item));
        }
        JSONObject data = new JSONObject().put("amount", (Object)amount).put("capture", true).put("description", (Object)("\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116" + contractTitle)).put("metadata", (Object)metadata);
        if (receipt != null) {
            data.put("receipt", receipt);
        }
        if (paymentType == YoomoneyPaymentType.AUTO) {
            data.put("payment_method_id", (Object)autoId);
        } else {
            JSONObject paymentMethodData = new JSONObject();
            JSONObject confirmation = new JSONObject();
            if (paymentType == YoomoneyPaymentType.SBP) {
                confirmation.put("type", (Object)"qr");
                paymentMethodData.put("type", (Object)"sbp");
            } else {
                confirmation.put("type", (Object)"redirect");
                confirmation.put("return_url", (Object)this.moduleSetup.get("yoomoney.shop.return.url", ""));
                String type = this.moduleSetup.get("yoomoney.payment.method.type", "bank_card");
                if (Utils.notEmptyString((String)type)) {
                    paymentMethodData.put("type", (Object)type);
                }
            }
            if (!paymentMethodData.isEmpty()) {
                data.put("payment_method_data", (Object)paymentMethodData);
            }
            data.put("confirmation", (Object)confirmation);
            data.put("save_payment_method", (Object)(paymentType == YoomoneyPaymentType.CARD_SAVE || paymentType == YoomoneyPaymentType.SBP_SAVE ? "true" : "false"));
        }
        return data;
    }

    public String doPaymentRequest(String data, String idempotenceKey) {
        StringBuilder spec = new StringBuilder(this.moduleSetup.get("yoomoney.payment.api.url", "https://api.yookassa.ru/v3/payments"));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)spec.toString());
            this.getLogger().debug("\t {}", (Object)data);
        }
        StringBuilder resultJson = null;
        try {
            String shopId = this.moduleSetup.get("yoomoney.shopId", null);
            String apiKey = this.moduleSetup.get("yoomoney.api.key", null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Content-Type", "application/json; charset=utf-8");
            map.put("Idempotence-Key", idempotenceKey);
            map.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((shopId + ":" + apiKey).getBytes("UTF-8")));
            resultJson = this.doConnection(spec.toString(), "POST", true, data, map);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: {}", (Object)resultJson);
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        return String.valueOf(resultJson);
    }

    public void doCheckRequest(String objectId) {
        StringBuilder spec = new StringBuilder(this.moduleSetup.get("yoomoney.payment.api.url", "https://api.yookassa.ru/v3/payments")).append("/").append(objectId);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)spec.toString());
        }
        StringBuilder resultJson = null;
        try {
            String shopId = this.moduleSetup.get("mobile.shopId", this.moduleSetup.get("yoomoney.shopId", null));
            String apiKey = this.moduleSetup.get("yoomoney.api.key", null);
            HashMap<String, CallSite> map = new HashMap<String, CallSite>();
            map.put("Authorization", (CallSite)((Object)("Basic " + Base64.getEncoder().encodeToString((shopId + ":" + apiKey).getBytes("UTF-8")))));
            resultJson = this.doConnection(spec.toString(), "GET", true, null, map);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + resultJson);
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        JSONObject resultJsonObject = null;
        if (resultJson != null) {
            resultJsonObject = new JSONObject(resultJson.toString());
            Object type = resultJsonObject.optQuery("/type");
            if (type != null && String.valueOf(type).equals("error")) {
                this.getLogger().error("resultJson = {}", (Object)resultJson);
            } else {
                String yoomoneyId = String.valueOf(resultJsonObject.optQuery("/id"));
                String status = String.valueOf(resultJsonObject.optQuery("/status"));
                BigDecimal sum = new BigDecimal(String.valueOf(resultJsonObject.optQuery("/amount/value")));
                this.doTransaction(yoomoneyId, status, sum, resultJsonObject);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doTransaction(String yoomoneyId, String status, BigDecimal sum, JSONObject resultJsonObject) {
        block22: {
            try {
                transaction = this.getTransactionByYoomoneyId(yoomoneyId);
                if (transaction == null) break block22;
                transaction.setAutopayment(Boolean.valueOf(String.valueOf(resultJsonObject.optQuery("/metadata/autopayment"))).booleanValue());
                transaction.setRawRequest(resultJsonObject.toString(2));
                transaction.setSum(sum);
                var6_7 = status;
                var7_8 = -1;
                switch (var6_7.hashCode()) {
                    case 945734241: {
                        if (!var6_7.equals("succeeded")) break;
                        var7_8 = 0;
                        break;
                    }
                    case -123173735: {
                        if (!var6_7.equals("canceled")) break;
                        var7_8 = 1;
                    }
                }
                switch (var7_8) {
                    case 0: {
                        if (transaction.getPaymentId() >= 1) break;
                        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                        capturedAt = String.valueOf(resultJsonObject.optQuery("/captured_at"));
                        if (capturedAt == null) {
                            capturedAt = String.valueOf(resultJsonObject.optQuery("/created_at"));
                        }
                        payment = Payment.builder().setContractId(transaction.getContractId()).setSum(transaction.getSum()).setDate((java.util.Date)new Date(dateFormat.parse(capturedAt).getTime() / 1000L * 1000L)).setTypeId(this.moduleSetup.getInt("yoomoney.payment.type.id", 0)).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("yoomoney.payment.comment", "\u041f\u043b\u0430\u0442\u0451\u0436 \u0447\u0435\u0440\u0435\u0437 \u042eKassa")).setData(this.getPaymentData(transaction)).build();
                        balanceUtils = new BalanceUtils(this.con);
                        try {
                            new PaymentDao(this.con).update((Object)payment);
                            ServerUtils.commitConnection((Connection)this.con);
                            balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                        }
                        finally {
                            balanceUtils.close();
                        }
                        transaction.setPaymentId(payment.getId());
                        transaction.setStatus(TransactionStatus.SUCCEEDED.getCode());
                        this.update(transaction);
                        EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
                        EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
                        this.checkAutopayment(transaction.getContractId(), resultJsonObject);
                        break;
                    }
                    case 1: {
                        payment = null;
                        if (transaction.getPaymentId() > 0) {
                            paymentDao = new PaymentDao(this.con);
                            payment = (Payment)paymentDao.get(transaction.getPaymentId());
                            paymentDao.delete(transaction.getPaymentId());
                            transaction.setPaymentId(0);
                        }
                        transaction.setStatus(TransactionStatus.CANCELED.getCode());
                        this.update(transaction);
                        if (payment == null) ** GOTO lbl66
                        balanceUtils = new BalanceUtils(this.con);
                        try {
                            balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                        }
                        finally {
                            balanceUtils.close();
                        }
                        EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
lbl66:
                        // 2 sources

                        if (!"payment_method_restricted".equals(cancellationDetailsReason = String.valueOf(resultJsonObject.optQuery("/cancellation_details/reason"))) && !"permission_revoked".equals(cancellationDetailsReason) && !"card_expired".equals(cancellationDetailsReason)) break;
                        this.cancelAutopayment(transaction.getContractId());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    protected void checkAutopayment(int contractId, JSONObject resultJsonObject) {
        boolean saved;
        JSONObject paymentMethod = resultJsonObject.optJSONObject("payment_method");
        if (paymentMethod != null && (saved = paymentMethod.optBoolean("saved"))) {
            String id = paymentMethod.optString("id");
            try {
                AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                if (autopayment != null) {
                    PeriodWithTime period = autopayment.getPeriod();
                    if (period.getDateFrom() == null) {
                        period.setLocalDateTimeFrom(LocalDateTime.now());
                    }
                    autopayment.setAccessToken(id);
                    autopaymentManager.update(autopayment);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    protected void cancelAutopayment(int contractId) {
        try {
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
            autopaymentManager.autopaymentOff(autopayment);
            autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
            autopaymentManager.updateAutopayment(autopayment);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    protected <T extends BGAbstractTransaction> String getPaymentData(T transaction) {
        JSONObject jsonObject = new JSONObject(((Transaction)transaction).getRawRequest());
        StringBuilder data = new StringBuilder();
        PAYMENT_DATA.entrySet().stream().forEach(a -> Optional.ofNullable(jsonObject.optQuery((String)a.getKey())).ifPresent(b -> data.append((String)a.getValue()).append("=").append(b).append("\n")));
        return data.toString();
    }
}

