/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.voice.common.bean.AbtractVoiceAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class VoiceCommonAccountDao {
    public static final String TABLE_COMMON_VOICE_ACCOUNT = "voice_account_base";
    private String tableName;
    Connection con;

    public VoiceCommonAccountDao(Connection con, int moduleId) {
        this.tableName = "voice_account_base_" + moduleId;
        this.con = con;
    }

    protected void fillFromRS(ResultSet rs, AbtractVoiceAccount account, boolean contractLoad) throws SQLException {
        account.setId(rs.getInt("id"));
        account.setContractId(rs.getInt("contractId"));
        if (contractLoad) {
            account.setContractTitle(rs.getString("contractTitle"));
            account.setContractComment(rs.getString("contractComment"));
        }
        account.setTypeId(rs.getInt("typeId"));
        account.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        account.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        account.setDeviceId(rs.getInt("deviceId"));
        account.setTitle(rs.getString("title"));
    }

    protected void update(AbtractVoiceAccount account) throws SQLException {
        boolean update = account.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET contractId=?,  typeId=?, deviceId=?, dateFrom=?, dateTo=?, title=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, account.getContractId());
            ps.setInt(index++, account.getTypeId());
            ps.setInt(index++, account.getDeviceId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)account.getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)account.getDateTo()));
            ps.setString(index++, account.getTitle());
            if (update) {
                ps.setInt(index++, account.getId());
            }
            ps.executeUpdate();
            if (!update) {
                account.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    protected int delete(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            int n = ps.executeUpdate();
            return n;
        }
    }

    protected void delete(List<Integer> ids) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (int i : ids) {
                ps.setInt(1, i);
                ps.addBatch();
            }
            ps.executeBatch();
            this.con.commit();
        }
    }
}

