/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.AbtractVoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountPortDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceCommonAccountDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class VoiceOperAccountDao
extends AbstractIdDao<VoiceOperAccount> {
    private final VoiceCommonAccountDao commonDao;

    public VoiceOperAccountDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_oper_account");
        this.commonDao = new VoiceCommonAccountDao(con, moduleId);
    }

    protected VoiceOperAccount getFromRS(ResultSet rs) throws SQLException {
        VoiceOperAccount account = VoiceOperAccount.builder().setRegexpFromPorts(rs.getString("regexpFromPorts")).setRegexpToPorts(rs.getString("regexpToPorts")).setRegexpA(rs.getString("regexpA")).setNoRegexpA(rs.getString("noRegexpA")).setRegexpB(rs.getString("regexpB")).setNoRegexpB(rs.getString("noRegexpB")).setCallType(rs.getByte("callType")).setServiceId(rs.getInt("serviceId")).build();
        VoiceAccountPortDao voiceAccountPortDao = new VoiceAccountPortDao(this.con, this.moduleId);
        Map map = voiceAccountPortDao.list(account.getId()).stream().collect(Collectors.partitioningBy(p -> p.isOut(), Collectors.toList()));
        account.setFromPortList(map.get(false));
        account.setToPortList(map.get(true));
        this.commonDao.fillFromRS(rs, (AbtractVoiceAccount)account, false);
        return account;
    }

    protected void updateImpl(VoiceOperAccount account) throws SQLException {
        boolean isNew = account.getId() <= 0;
        this.commonDao.update((AbtractVoiceAccount)account);
        String query = (isNew ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET regexpFromPorts=?, regexpToPorts=?, regexpA=?, noRegexpA=?, regexpB=?, noRegexpB=?, callType=?, serviceId=?" + (isNew ? ", id = ?" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, account.getRegexpFromPorts());
            ps.setString(index++, account.getRegexpToPorts());
            ps.setString(index++, account.getRegexpA());
            ps.setString(index++, account.getNoRegexpA());
            ps.setString(index++, account.getRegexpB());
            ps.setString(index++, account.getNoRegexpB());
            ps.setByte(index++, account.getCallType());
            if (account.getServiceId() > 0) {
                ps.setInt(index++, account.getServiceId());
            } else {
                ps.setNull(index++, 4);
            }
            ps.setInt(index++, account.getId());
            ps.executeUpdate();
        }
    }

    public List<VoiceOperAccount> list() throws SQLException {
        return this.listImpl(new Page(), this.getWhat(), this.getJoins(), "", "", new Object[0]);
    }

    public List<VoiceOperAccount> list(int contractId, Period period) throws SQLException {
        Object filter = "contractId = ?";
        if (period != null) {
            filter = (String)filter + " AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND(dateTo IS NULL OR ? IS NULL OR dateTo>=?)";
        }
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        params.add(Integer.valueOf(contractId));
        if (period != null) {
            params.addAll(Arrays.asList(period.getDateTo(), period.getDateTo(), period.getDateFrom(), period.getDateFrom()));
        }
        return this.listImpl(new Page(), this.getWhat(), this.getJoins(), (String)filter, "contractId", params.toArray());
    }

    private String getWhat() {
        return " ancestor.*, " + this.tableName + ".* ";
    }

    private String getJoins() {
        return " INNER JOIN " + this.getTableName("voice_account_base", this.moduleId, null) + " as ancestor  ON ancestor.id = " + this.tableName + ".id ";
    }

    protected VoiceOperAccount getById(int id) throws SQLException {
        VoiceOperAccount result;
        String query = "SELECT " + this.getWhat() + " FROM " + this.tableName + this.getJoins() + " WHERE " + this.tableName + ".id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                result = rs.next() ? this.getFromRS(rs) : null;
            }
        }
        return result;
    }

    protected int deleteImpl(int id) throws SQLException {
        this.commonDao.delete(id);
        return super.deleteImpl(id);
    }
}

