/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.server.admin.bean.AddressManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectDao;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.upload.CustomSormFileWriter;
import ru.bitel.bgbilling.modules.sorm.server.upload.CustomUploadHandler;
import ru.bitel.bgbilling.modules.sorm.server.upload.PaymentsToUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadVersion;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadHelper;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterDao;

public abstract class Upload
implements UploadVersion {
    protected static final Logger logger = LogManager.getLogger();
    protected ServerContext serverContext;
    protected Connection con;
    protected SormProject sormProject;
    protected Preferences config;
    protected List<SormContract> contracts;
    protected AddressManager addressManager;
    protected ParameterDao parameterDao;
    protected HouseDao houseDao;
    protected ContractManager contractManager;
    protected ContractDao contractDao;
    protected ContractObjectDao contractObjectDao;
    protected ContractParameterManager cpm;
    protected ObjectDao objectManager;
    protected PaymentsToUpload paymentsToUpload;
    protected SormUploadHelper helper;
    protected String localUserPath;
    protected final String adminEmail;
    private final List<String> installedSormModules = new ArrayList<String>();
    protected final boolean isFullUpload;
    private final int moduleId;
    protected CustomSormFileWriter customSormFileWriter;

    public Upload(SormProject sormProject, boolean isFullUpload) {
        this(-1, sormProject, isFullUpload);
    }

    public Upload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        logger.debug("Upload \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        this.moduleId = moduleId;
        this.isFullUpload = isFullUpload;
        this.serverContext = (ServerContext)ServerContext.get();
        this.con = this.serverContext.getConnection();
        this.sormProject = sormProject;
        this.config = sormProject.getLoadedConfig();
        this.contractManager = new ContractManager(this.con);
        this.addressManager = new AddressManager(this.con);
        this.parameterDao = new ParameterDao(this.con);
        this.houseDao = new HouseDao(this.con);
        this.contractDao = new ContractDao(this.con, 0);
        this.contractObjectDao = new ContractObjectDao(this.con, 0);
        this.cpm = new ContractParameterManager(this.con);
        this.objectManager = new ObjectDao(this.con);
        this.contracts = SormUtils.getUploadContracts(this);
        logger.debug("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + this.contracts.size());
        this.localUserPath = Utils.maskBlank((String)this.config.get("sorm.local.catalog"), (String)"");
        if (this.localUserPath.endsWith("/")) {
            this.localUserPath = this.localUserPath.substring(0, this.localUserPath.length() - 1);
        }
        this.adminEmail = SormUtils.getAdminEmail(this.config);
        logger.debug("PaymentsToUpload init. ModuleId=" + moduleId);
        this.paymentsToUpload = new PaymentsToUpload(this.serverContext, isFullUpload, sormProject, moduleId);
        logger.debug("PaymentsToUpload init end");
        try {
            this.helper = new SormUploadHelper(this.config, this.con, this.addressManager, this.contracts.stream().mapToInt(SormContract::getContractId).boxed().toList());
            ((SormService)this.serverContext.getService(SormService.class, this.moduleId)).getInstalledSormModules().forEach(module -> this.installedSormModules.add(module.getTitleModule()));
            this.defineCustomUploadHandler();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private void defineCustomUploadHandler() throws Exception {
        List classes = ((DynamicCodeService)this.serverContext.getService(DynamicCodeService.class, 0)).getDynamicClassesByInterface(CustomUploadHandler.class.getName());
        if (Utils.notEmptyCollection((Collection)classes)) {
            if (classes.size() > 1) {
                logger.warn("\u0412 \u0434\u0438\u043d.\u043a\u043e\u0434\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 1 CustomUploadHandler!");
            }
            DynamicClass customUploadHandler = (DynamicClass)classes.get(0);
            logger.debug("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d CustomUploadHandler: {}", (Object)customUploadHandler.getClassName());
            this.customSormFileWriter = new CustomSormFileWriter((CustomUploadHandler)DynamicClassManager.getInstance().newInstance(CustomUploadHandler.class, customUploadHandler.getClassName()), this);
        }
    }

    public void uploadForStatistic(SormUploadStatistic statistic) {
        this.contracts.removeIf(contract -> contract.getContractId() < statistic.getFirstUploadContractId() || contract.getContractId() > statistic.getLastUploadContractId());
    }

    public void closeResources() {
        if (Utils.notEmptyCollection(this.contracts)) {
            SormUtils.clearChangedContractsTable(this.con, this.moduleId);
        }
    }

    protected boolean checkInstalledModule(UploadModulesTitle module) {
        return this.installedSormModules.contains(module.getTitleModule());
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public Connection getConnection() {
        return this.con;
    }

    public SormProject getSormProject() {
        return this.sormProject;
    }

    public Preferences getConfig() {
        return this.config;
    }

    public boolean isFullUpload() {
        return this.isFullUpload;
    }

    public List<SormContract> getContracts() {
        return this.contracts;
    }

    public ServerContext getServerContext() {
        return this.serverContext;
    }

    public AddressManager getAddressManager() {
        return this.addressManager;
    }

    public ParameterDao getParameterDao() {
        return this.parameterDao;
    }

    public String getLocalUserPath() {
        return this.localUserPath;
    }

    protected void writeItemToFile(String[] item, int cid, String filename, CSVWriter csvWriter) throws BGException {
        if (this.customSormFileWriter == null) {
            csvWriter.writeNext(item);
        } else if (!this.customSormFileWriter.writeCustomLine(cid, item, csvWriter, filename, this.helper)) {
            csvWriter.writeNext(item);
        }
    }
}

