/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.searchimpl;

import jakarta.xml.ws.Holder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractSearchableFilters;
import ru.bitel.bgbilling.kernel.contract.search.server.AbstractContractSearchable;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;

public class SearchNextContractUploadToSorm
extends AbstractContractSearchable {
    private final String COMMENT = "comment";
    private final String STATUS = "status";
    private final String DATE_FROM = "dateFrom";
    private final String DATE_TO = "dateTo";
    private final String EVENT = "event";
    private final String EVENT_DATE = "event_date";

    public boolean check(String searchData) {
        return true;
    }

    public List<JSONObject> search(String searchData, int moduleId, ContractSearchableFilters filters, Holder<Page> pageHolder) throws BGException {
        String tableName;
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection connection = serverContext.getConnection();
        if (!ServerUtils.tableExists((Connection)connection, (String)(tableName = ServerUtils.getModuleTableName((String)"sorm_changed_contract_upload", (int)moduleId)))) {
            throw new BGException("Table " + tableName + " is not exist.");
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        String query = "SELECT scu.*, c.title AS title, c.status, c.comment, c.date1, c.date2 FROM " + tableName + " AS scu LEFT JOIN contract AS c ON scu.contractId=c.id WHERE 1=1";
        if (filters.getTypeContract() > -1) {
            query = query + " AND c.fc=" + filters.getTypeContract();
        }
        Page page = null;
        if (pageHolder != null) {
            page = (Page)pageHolder.value;
        }
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                JSONObject object = new JSONObject();
                object.put("cid", (Object)rs.getString("scu.contractId"));
                object.put("contractTitle", (Object)rs.getString("title"));
                object.put("comment", (Object)rs.getString("comment"));
                object.put("status", (Object)rs.getString("c.status"));
                object.put("event", (Object)rs.getString("scu.eventClass"));
                Date dateFrom = TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("c.date1"));
                object.put("dateFrom", (Object)(dateFrom == null ? "" : TimeUtils.formatFullDate((Date)dateFrom)));
                Date dateTo = TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("c.date2"));
                object.put("dateTo", (Object)(dateTo == null ? "" : TimeUtils.formatFullDate((Date)dateTo)));
                Date eventDate = TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("scu.date"));
                object.put("event_date", (Object)(eventDate == null ? "" : TimeUtils.formatFullDate((Date)eventDate)));
                result.add(object);
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)connection));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public JSONObject metadata() {
        JSONObject metadata = new JSONObject();
        JSONArray titles = new JSONArray();
        titles.put((Object)this.getTitleContractId("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        titles.put((Object)this.getTitleContractTitle("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"));
        titles.put((Object)this.getTitle("comment", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        titles.put((Object)this.getTitle("dateFrom", "\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430"));
        titles.put((Object)this.getTitle("dateTo", "\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f"));
        titles.put((Object)this.getTitle("status", "\u0421\u0442\u0430\u0442\u0443\u0441"));
        titles.put((Object)this.getTitle("event", "\u0421\u043e\u0431\u044b\u0442\u0438\u0435", 200));
        titles.put((Object)this.getTitle("event_date", "\u0414\u0430\u0442\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u044f", 200));
        metadata.put("titles", (Object)titles);
        return metadata;
    }

    public String getTitle() {
        return "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0434\u043b\u044f \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0435\u0439 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0432 \u0421\u041e\u0420\u041c";
    }
}

