/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.sputnik;

import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.smarthouse.server.api.SmarthouseManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class SputnikManager
extends SmarthouseManager {
    public SputnikManager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("sputnik.server.url", "https://api.sputnik.systems/api/v1");
        this.token = moduleSetup.get("sputnik.token", null);
        this.readTimeout = moduleSetup.getInt("sputnik.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("sputnik.request.timeout.connect", 10000);
    }

    public boolean isEnabled() {
        return this.token != null;
    }

    public JSONObject getAccountTokens() throws Exception {
        return this.doRequest("/account/tokens", "GET");
    }

    public JSONObject getAccountDevicesIntercoms(int page) throws Exception {
        return this.doRequest("/account/devices/intercoms?page=" + page, "GET");
    }

    public JSONObject getAccountDevicesIntercomsFlats(String uuid) throws Exception {
        return this.doRequest("/account/devices/intercoms/" + uuid + "/flats", "GET");
    }

    public JSONObject getAccountDevicesIntercomsShadow(String uuid) throws Exception {
        return this.doRequest("/account/devices/intercoms/" + uuid + "/shadow", "GET");
    }

    public JSONObject patchAccountDevicesIntercomsChangeFlatConfig(String uuid, int flatNum, boolean blocked) throws BGException, Exception {
        JSONObject flat = null;
        JSONObject resultJson = this.getAccountDevicesIntercomsFlats(uuid);
        JSONObject flatsConfigJson = resultJson.getJSONObject("flats_config");
        JSONArray flats = flatsConfigJson.getJSONArray("flats");
        for (int index = 0; index < flats.length(); ++index) {
            JSONObject json = flats.getJSONObject(index);
            if (json.getInt("num") != flatNum) continue;
            flat = json;
            break;
        }
        if (flat == null) {
            throw new BGException("FlatConfig not found [uuid=" + uuid + "; flatNum=" + flatNum + "]");
        }
        flat.put("blocked", blocked);
        flat.getJSONObject("analog_settings").put("blocked", blocked);
        JSONObject json = new JSONObject();
        json.put("flats_config", (Object)flat);
        return this.doRequest("/account/devices/intercoms/" + uuid + "/change_flat_config", "PATCH", json.toString());
    }

    @Override
    protected void errorSetServerUrl() throws Exception {
        throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"sputnik.server.url=\"");
    }

    @Override
    protected void errorGetToken() throws Exception {
        throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"sputnik.token=\"");
    }

    @Override
    protected String getTokenType() {
        return "Bearer";
    }
}

