/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.JRViewer;
import bitel.billing.module.common.TransferData;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.reports.client.AllModuleReportsComboBox;
import ru.bitel.bgbilling.modules.reports.client.ReportParams;
import ru.bitel.bgbilling.modules.reports.client.TextReportPanel;
import ru.bitel.bgbilling.modules.reports.client.ViewReportPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.CreatedReportEvent;
import ru.bitel.bgbilling.modules.reports.client.modules.Report;
import ru.bitel.common.Utils;

public class BGReportsPanel
extends ServiceConfigTabbedPanel
implements EventSubscriber<CreatedReportEvent> {
    private static final String MODE_JASPER = "jasper";
    private static final String MODE_CSV = "csv";
    private static final String MODE_TEXT = "text";
    private boolean inited = false;
    private JRViewer viewer;
    private JPanel rightPanel = null;
    private JPanel reportParamsPanel = null;
    private ViewReportPanel viewPanel = new ViewReportPanel(this);
    private TextReportPanel textPanel = new TextReportPanel(this);
    private AllModuleReportsComboBox allModuleReportsPanel = new AllModuleReportsComboBox(e -> this.changeReport((Report)e));

    public BGReportsPanel() {
        this.rightPanel = new JPanel(new CardLayout());
        this.rightPanel.add((Component)this.createPrintPanel(), MODE_JASPER);
        this.rightPanel.add((Component)((Object)this.viewPanel), MODE_CSV);
        this.rightPanel.add((Component)((Object)this.textPanel), MODE_TEXT);
        ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_JASPER);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.createSettingsPanel(), (Component)this.rightPanel, 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        EventBus.subscribe(CreatedReportEvent.class, (EventSubscriber)this);
    }

    public void onEvent(CreatedReportEvent event) {
        this.reportParamsPanel.removeAll();
    }

    private JPanel createPrintPanel() {
        JPanel printPanel = new JPanel(new BorderLayout());
        try {
            this.viewer = new JRViewer(null);
            this.viewer.addHyperlinkListener(new JRHyperlinkListener(){

                public void gotoHyperlink(JRPrintHyperlink hyperlink) throws JRException {
                    block10: {
                        if (!"Reference".equals(hyperlink.getLinkType())) {
                            return;
                        }
                        try {
                            URI uri;
                            String u = hyperlink.getHyperlinkReference();
                            if (!u.startsWith("bgbilling:") || !"reports".equals((uri = new URI(u.substring(10))).getScheme())) break block10;
                            if ("bitel.billing.module.services.reports.BGReportsPanel".equals(uri.getHost()) || "ru.bitel.bgbilling.modules.reports.client.BGReportsPanel".equals(uri.getHost())) {
                                String[] query = null;
                                Pattern p = Pattern.compile("&");
                                try {
                                    query = p.split(URLDecoder.decode(uri.getQuery(), "UTF-8"));
                                }
                                catch (UnsupportedEncodingException ex) {
                                    query = p.split(uri.getQuery());
                                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                                }
                                HashMap<String, String> params = new HashMap<String, String>();
                                for (String q : query) {
                                    int pos = q.indexOf(61);
                                    if (pos != -1) {
                                        params.put(q.substring(0, pos), q.substring(pos + 1));
                                        continue;
                                    }
                                    params.put(q, "");
                                }
                                Request request = new Request().setModule("reports").setModuleId(BGReportsPanel.this.getModuleId()).setAction("Report").setAttribute("contentType", "binary");
                                for (String key : params.keySet()) {
                                    request.setAttribute(key, (String)params.get(key));
                                }
                                BGReportsPanel.this.showReport(request, null);
                                break block10;
                            }
                            if ("ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor".equals(uri.getHost()) || "bitel.billing.module.contract.ContractEditor".equals(uri.getHost())) {
                                ClientUtils.openContract((int)Utils.parseInt((String)uri.getQuery()));
                            }
                        }
                        catch (URISyntaxException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                }
            });
            this.viewer.addToolbarButton("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0451\u0442\u0430 \u043d\u0430 email", (Icon)ClientUtils.getIcon((String)"mail.png"), e -> this.sendEmailReport());
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
        printPanel.add((Component)this.viewer, "Center");
        return printPanel;
    }

    private JPanel createSettingsPanel() {
        this.reportParamsPanel = new JPanel(new CardLayout());
        this.reportParamsPanel.setBorder((Border)new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        this.reportParamsPanel.setDebugGraphicsOptions(0);
        JButton genButton = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        genButton.addActionListener(e -> this.generateReport());
        JPanel settingPanel = new JPanel(new GridBagLayout());
        settingPanel.setMaximumSize(new Dimension(400, 500));
        settingPanel.setPreferredSize(new Dimension(400, 500));
        settingPanel.add((Component)((Object)this.allModuleReportsPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        settingPanel.add((Component)this.reportParamsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        settingPanel.add((Component)genButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        return settingPanel;
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.viewPanel.init(module, moduleId);
    }

    public void setData() {
        if (!this.inited) {
            this.inited = true;
            this.allModuleReportsPanel.setData();
        }
    }

    public void generateReport() {
        this.setCursor(new Cursor(3));
        try {
            Report report = this.allModuleReportsPanel.getReport();
            Request request = this.getRequest();
            this.showReport(request, report);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    public Request getRequest() {
        Report report = this.allModuleReportsPanel.getReport();
        ReportParams params = this.getReportParams();
        Request request = null;
        if (report != null & params != null && report.id != null) {
            String checkParams = params.checkParams();
            if (checkParams != null) {
                ClientUtils.showErrorMessageDialog((String)checkParams);
            } else {
                request = this.createRequest(report, params);
            }
        }
        return request;
    }

    private ReportParams getReportParams() {
        ReportParams selected = null;
        Component[] paramsPanes = this.reportParamsPanel.getComponents();
        for (int i = 0; i < paramsPanes.length; ++i) {
            if (!paramsPanes[i].isVisible()) continue;
            selected = (ReportParams)((Object)paramsPanes[i]);
            break;
        }
        return selected;
    }

    private Request createRequest(Report report, ReportParams params) {
        Request request = new Request().setModule("reports").setModuleId(this.getModuleId()).setAction("Report").setAttribute("contentType", "binary");
        request.setAttribute("report_id", report.id);
        Map<String, Object> paramsObj = params.getParams();
        for (String key : paramsObj.keySet()) {
            request.setAttribute(key, paramsObj.get(key));
        }
        return request;
    }

    private boolean showReport(Request request, Report report) {
        TransferData.HTTPDataSource source = TransferManager.getDataSource((Request)request);
        if (source != null && !source.isError()) {
            try {
                if (source.getContentType() == null || source.getContentType().equals(MODE_JASPER)) {
                    this.viewer.setReport((JasperPrint)JRLoader.loadObject((InputStream)source.getInputStream()));
                    this.repaint();
                    ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_JASPER);
                    return true;
                }
                if (source.getContentType().equals("error")) {
                    this.textPanel.showReport(source.getInputStream());
                    ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_TEXT);
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430");
                    return false;
                }
                if (source.getContentType().equals("json")) {
                    this.viewPanel.setDataInJson(true);
                    this.viewPanel.showReport(source.getInputStream());
                    ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_CSV);
                    return true;
                }
                this.viewPanel.setDataInJson(false);
                this.viewPanel.showReport(source.getInputStream());
                ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_CSV);
                return true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return false;
    }

    private void changeReport(Report report) {
        if (report != null) {
            this.reportParamsPanel.add((Component)((Object)report.reportParams), report.id);
            ((CardLayout)this.reportParamsPanel.getLayout()).show(this.reportParamsPanel, report.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEmailReport() {
        String email = this.getUserEmail(this.module);
        email = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 EMail", "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430", 3, UIManager.getIcon("OptionPane.questionIcon"), null, email);
        if (Utils.notBlankString((String)email)) {
            email = email.trim();
            this.saveUserEmail(this.module, email);
            Report report = this.allModuleReportsPanel.getReport();
            Request request = this.getRequest();
            request.setAttribute("maildest", String.valueOf(email));
            this.setCursor(new Cursor(3));
            try {
                if (this.showReport(request, report)) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                }
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
    }
}

