/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.task;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionType;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractOptionDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonOptionDao;
import ru.bitel.bgbilling.modules.megafon.server.utils.MegafonUtils;
import ru.bitel.common.model.Page;

public class MegafonContractProductProlongateTask
extends TaskBase {
    private MegafonContractService megafonContractService;
    private MegafonService megafonService;
    private MegafonApiClient megafonApiClient;
    private MegafonContractProductDao contractProductDao;

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        ServerContext context = (ServerContext)ServerContext.get();
        try {
            this.megafonContractService = (MegafonContractService)context.getService(MegafonContractService.class, this.getModuleId());
            this.megafonService = (MegafonService)context.getService(MegafonService.class, this.moduleId);
            this.megafonApiClient = new MegafonApiClient(this.moduleId);
            this.contractProductDao = new MegafonContractProductDao(context.getConnection(), context.getModuleId());
            this.getLogger().debug("\u041f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u0438 \u043e\u043f\u0446\u0438\u0439 \u041c\u0435\u0433\u0430\u0444\u043e\u043d");
            this.activateProducts(context);
            this.prolongateProducts(context);
            this.prolongateOptions(context);
        }
        catch (BGException e) {
            this.logError(e);
        }
    }

    private void activateProducts(ServerContext context) {
        this.getLogger().debug("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d");
        try {
            for (MegafonContractProduct contractProduct : this.getProductForActivate(context.getConnection())) {
                try {
                    this.getLogger().info("\u041f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u041c\u0435\u0433\u0430\u0444\u043e\u043d: cid={}, productId={}", (Object)contractProduct.getContractId(), (Object)contractProduct.getProductId());
                    this.megafonContractService.productActivateRequest(contractProduct);
                    this.megafonContractService.productActivate(contractProduct);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
        catch (Exception e) {
            String header = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432";
            MegafonUtils.sendAlarm(header, e.getMessage());
            this.getLogger().error(header, (Throwable)e);
        }
    }

    private List<MegafonContractProduct> getProductForActivate(Connection connection) throws SQLException {
        MegafonContractProductDao contractProductDao = new MegafonContractProductDao(connection, this.getModuleId());
        List forActivate = contractProductDao.list(new Page(), "status=?", "", MegafonContractProductStatus.INACTIVE).getList();
        LocalDate now = LocalDate.now();
        forActivate.removeIf(p -> !p.getStartTime().toLocalDate().isEqual(now));
        this.getLogger().info("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438: {}", (Object)forActivate.size());
        return forActivate;
    }

    private void prolongateProducts(ServerContext context) {
        this.getLogger().debug("\u041f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d");
        MegafonContractProductDao contractProductDao = new MegafonContractProductDao(context.getConnection(), context.getModuleId());
        try {
            for (MegafonContractProduct contractProduct : this.getProductForProlongate(context.getConnection())) {
                this.prolongateProduct(context, contractProductDao, contractProduct);
            }
        }
        catch (Exception e) {
            String header = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432";
            MegafonUtils.sendAlarm(header, e.getMessage());
            this.getLogger().error(header, (Throwable)e);
        }
    }

    private void prolongateProduct(ServerContext context, MegafonContractProductDao contractProductDao, MegafonContractProduct contractProduct) {
        MegafonProduct product = null;
        try {
            product = this.megafonService.getProduct(contractProduct.getProductId());
            if (product == null) {
                this.getLogger().error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = {}", (Object)contractProduct.getProductId());
                return;
            }
            this.getLogger().info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438: cid={}, msisdn={}, productOfferingId={}", new Object[]{contractProduct.getContractId(), contractProduct.getMsisdn(), product.getProductOfferingId()});
            MegafonUtils.addPaymentForActivateProduct(context, this.megafonApiClient, product, contractProduct);
            contractProduct.setEndTime(LocalDateTime.now().plusMonths(1L).withDayOfMonth(1));
            contractProductDao.update(contractProduct);
        }
        catch (Exception e) {
            String header = String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430: cid=%s, msisdn=%s, productOfferingId=%s", contractProduct.getContractId(), contractProduct.getMsisdn(), product != null ? product.getProductOfferingId() : "");
            MegafonUtils.sendAlarm(header, e.getMessage());
            this.getLogger().error(header, (Throwable)e);
        }
    }

    private List<MegafonContractProduct> getProductForProlongate(Connection connection) throws SQLException {
        MegafonContractProductDao contractProductDao = new MegafonContractProductDao(connection, this.getModuleId());
        List forProlongate = contractProductDao.list(new Page(), "status=?", "", MegafonContractProductStatus.ACTIVE).getList();
        LocalDate now = LocalDate.now();
        forProlongate.removeIf(p -> p.getEndTime() == null || p.getEndTime().toLocalDate().isAfter(now));
        this.getLogger().info("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438: {}", (Object)forProlongate.size());
        return forProlongate;
    }

    private void prolongateOptions(ServerContext context) {
        MegafonContractOptionDao contractOptionDao = new MegafonContractOptionDao(context.getConnection(), context.getModuleId());
        try {
            for (MegafonContractOption option : this.getOptionsForProlongate(context)) {
                try {
                    this.prolongateOption(context, contractOptionDao, option);
                }
                catch (Exception ex) {
                    String header = String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438 \u043e\u043f\u0446\u0438\u0438: cid=%s, optionId=%s", option.getContractId(), option.getOptionId());
                    MegafonUtils.sendAlarm(header, ex.getMessage());
                    this.getLogger().error(header, (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            String header = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438 \u0434\u043e\u043f.\u043e\u043f\u0446\u0438\u0439";
            MegafonUtils.sendAlarm(header, e.getMessage());
            this.getLogger().error(header, (Throwable)e);
        }
    }

    private void prolongateOption(ServerContext context, MegafonContractOptionDao contractOptionDao, MegafonContractOption contractOption) throws Exception {
        MegafonContractProduct contractProduct = (MegafonContractProduct)this.contractProductDao.get(contractOption.getContractProductId());
        if (contractProduct == null) {
            throw new BGException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u0434\u043b\u044f \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438 \u043e\u043f\u0446\u0438\u0438. cid=%s, contractOptionId=%s", contractOption.getContractId(), contractOption.getId()));
        }
        MegafonOption option = this.megafonService.getMegafonOption(contractOption.getOptionId());
        MegafonUtils.addPaymentForActivateOption(context, this.megafonApiClient, option, contractProduct);
        contractOption.setEndTime(contractProduct.getEndTime());
        contractOptionDao.update(contractOption);
    }

    private List<MegafonContractOption> getOptionsForProlongate(ServerContext context) throws SQLException {
        MegafonOptionDao optionDao = new MegafonOptionDao(context.getConnection(), context.getModuleId());
        MegafonContractOptionDao contractOptionDao = new MegafonContractOptionDao(context.getConnection(), context.getModuleId());
        LocalDate now = LocalDate.now();
        return contractOptionDao.list(new Page(), "status=?", "", MegafonContractProductStatus.ACTIVE).getList().stream().filter(co -> {
            try {
                MegafonOption option = (MegafonOption)optionDao.get(co.getOptionId());
                return option != null && option.getOptionType().equals((Object)MegafonOptionType.PROLONGATE) && co.getEndTime() != null && (co.getEndTime().toLocalDate().isEqual(now) || co.getEndTime().toLocalDate().isBefore(now));
            }
            catch (SQLException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    public String getDescription() {
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438 \u0438 \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432";
    }
}

