/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.config.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Date;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigDataDto;
import ru.bitel.common.model.IdTitle;

public class ConfigData
extends IdTitle {
    private int moduleId = 0;
    private int userId = 0;
    private Date lastEdited = new Date();
    private String userName = null;
    private String config = "";
    private boolean active = false;

    public String getConfig() {
        return this.config;
    }

    @XmlAttribute
    public int getUserId() {
        return this.userId;
    }

    @XmlAttribute
    public String getUserName() {
        return this.userName;
    }

    @XmlAttribute
    public int getModuleId() {
        return this.moduleId;
    }

    @XmlAttribute
    public boolean isActive() {
        return this.active;
    }

    @XmlAttribute
    public Date getLastEdited() {
        return this.lastEdited;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setLastEdited(Date lastEdited) {
        this.lastEdited = lastEdited;
    }

    public ConfigDataDto toConfigDataDto() {
        return new ConfigDataDto(this.id, this.title).setActive(this.active).setLastEdited(this.lastEdited).setUserName(this.userName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ConfigData data = new ConfigData();

        private Builder() {
        }

        public Builder setId(int id) {
            this.data.id = id;
            return this;
        }

        public Builder setTitle(String title) {
            this.data.title = title;
            return this;
        }

        public Builder setModuleId(int moduleId) {
            this.data.moduleId = moduleId;
            return this;
        }

        public Builder setActive(boolean active) {
            this.data.active = active;
            return this;
        }

        public Builder setConfig(String config) {
            this.data.config = config;
            return this;
        }

        public Builder setUserId(int userId) {
            this.data.userId = userId;
            return this;
        }

        public Builder setUserName(String userName) {
            this.data.userName = userName;
            return this;
        }

        public Builder setLastEdited(Date lastEdited) {
            this.data.lastEdited = lastEdited;
            return this;
        }

        public ConfigData build() {
            try {
                ConfigData configData = this.data;
                return configData;
            }
            finally {
                this.data = null;
            }
        }
    }
}

