/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server.searchimpl;

import jakarta.xml.ws.Holder;
import java.sql.Connection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractSearchableFilters;
import ru.bitel.bgbilling.kernel.contract.search.server.AbstractContractSearchable;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.common.model.Page;

public class SearchContractsByCustomerInn
extends AbstractContractSearchable {
    private final String CONTRACT_STATUS = "status";

    @Override
    public boolean check(String searchData) {
        if (!searchData.matches("[-+]?\\d+")) {
            return false;
        }
        return searchData.length() <= 12;
    }

    @Override
    public List<JSONObject> search(String searchData, int moduleId, ContractSearchableFilters filters, Holder<Page> pageHolder) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection con = serverContext.getConnection();
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        HashSet<Integer> cidsOfCustomer = new HashSet<Integer>();
        CustomerDao customerDao = new CustomerDao(con);
        String CUSTOMER_INN_KEY = "/customer/inn";
        if (filters.getTypeContract() == -1) {
            JSONObject customer;
            int x;
            JSONArray customers = customerDao.searchByKey(Customer.CustomerType.JUR_CUSTOMER, CUSTOMER_INN_KEY, searchData);
            for (x = 0; x < customers.length(); ++x) {
                customer = customers.optJSONObject(x);
                cidsOfCustomer.addAll(this.getCidsOfCustomer(customer.optInt("id"), customerDao));
            }
            customers = customerDao.searchByKey(Customer.CustomerType.FIZ_CUSTOMER, CUSTOMER_INN_KEY, searchData);
            for (x = 0; x < customers.length(); ++x) {
                customer = customers.optJSONObject(x);
                cidsOfCustomer.addAll(this.getCidsOfCustomer(customer.optInt("id"), customerDao));
            }
        } else {
            Customer.CustomerType type = filters.getTypeContract() == 0 ? Customer.CustomerType.FIZ_CUSTOMER : Customer.CustomerType.JUR_CUSTOMER;
            JSONArray customers = customerDao.searchByKey(type, CUSTOMER_INN_KEY, searchData);
            for (int x = 0; x < customers.length(); ++x) {
                JSONObject customer = customers.optJSONObject(x);
                cidsOfCustomer.addAll(this.getCidsOfCustomer(customer.optInt("id"), customerDao));
            }
        }
        try (ContractDao contractDao = new ContractDao(con, serverContext.getUserId());
             BalanceUtils balanceUtils = new BalanceUtils(con);){
            for (Integer cid : cidsOfCustomer) {
                Contract contract = (Contract)contractDao.get(cid);
                if (contract == null || !this.checkContractOnFilters(contract, filters)) continue;
                result.add(this.convertJSONFromContract(contract, balanceUtils));
            }
        }
        return result;
    }

    private Set<Integer> getCidsOfCustomer(int customerId, CustomerDao customerDao) throws Exception {
        if (customerId > 0) {
            return new HashSet<Integer>(customerDao.getCustomerContracts(customerId, LocalDateTime.now()).stream().map(CustomerContract::getContractId).toList());
        }
        return Collections.emptySet();
    }

    private boolean checkContractOnFilters(Contract contract, ContractSearchableFilters filters) {
        if (!filters.isShowSubContracts() && contract.isSub()) {
            return false;
        }
        return filters.isShowHidden() || !contract.isHidden();
    }

    private JSONObject convertJSONFromContract(Contract contract, BalanceUtils balanceUtils) {
        JSONObject object = new JSONObject();
        object.put("cid", contract.getId());
        object.put("contractTitle", (Object)contract.getTitle());
        object.put("status", (int)contract.getStatus());
        object.put("color", (Object)(contract.getStatus() > 0 ? "red" : ""));
        object.put("balance", (Object)balanceUtils.getBalance(LocalDate.now(), contract.getId()));
        return object;
    }

    @Override
    public JSONObject metadata() {
        JSONObject metadata = new JSONObject();
        JSONArray titles = new JSONArray();
        titles.put((Object)this.getTitleContractId("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        titles.put((Object)this.getTitleContractTitle("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"));
        titles.put((Object)this.getTitle("status", "\u0421\u0442\u0430\u0442\u0443\u0441"));
        titles.put((Object)this.getTitleContractBalance("\u0411\u0430\u043b\u0430\u043d\u0441"));
        metadata.put("titles", (Object)titles);
        return metadata;
    }

    @Override
    public String getTitle() {
        return "\u041f\u043e\u0438\u0441\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043f\u043e \u0418\u041d\u041d \u043a\u043b\u0438\u0435\u043d\u0442\u0430";
    }
}

