/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="FileStorageApi", urlPatterns={"/file/*"})
public class FileStorageApi
extends HttpServlet {
    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doHead(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String storageId = this.getStorageId(request);
        if (storageId == null) {
            response.setStatus(400);
            response.getWriter().write("storageId = null");
            return;
        }
        try {
            int fieldId = Utils.parseInt((String)this.getFileUID(request));
            Class<?> clazz = Class.forName("ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage.HelpdeskFileStorage");
            FileStorage fileStorage = (FileStorage)clazz.getConstructor(Connection.class).newInstance(Setup.getSetup().getDBConnectionFromPool(true));
            response.setContentType("text/plain");
            response.getWriter().write("fileUID = " + fieldId + "\nfileName = " + fileStorage.getFileName(fieldId));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getFileUID(HttpServletRequest request) {
        return this.getPathToken(request, 2);
    }

    private String getStorageId(HttpServletRequest request) {
        return this.getPathToken(request, 1);
    }

    private String getPathToken(HttpServletRequest request, int index) {
        String[] paths = request.getPathInfo().split("/");
        return paths.length > index ? paths[index] : null;
    }
}

