/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.treetable;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import ru.bitel.common.client.treetable.DefaultBGTreeTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.TreeNode;

public abstract class BGTreeTableModel<N extends TreeNode<N>>
extends DefaultBGTreeTableModel<N>
implements TreeModel {
    public BGTreeTableModel(String name) {
        super(name);
    }

    public BGTreeTableModel(String name, Class<N> clazz) {
        super(name, clazz);
    }

    @Override
    protected final List<N> getChildren(Object parent) {
        return ((TreeNode)parent).getChildren();
    }

    protected <I extends TreeNode<I>> I[] findPath(int id, I current) {
        ArrayList result = new ArrayList();
        this.findPath((I)id, (List<I>)result, current);
        Collections.reverse(result);
        TreeNode[] r = (TreeNode[])Array.newInstance(current.getClass(), result.size());
        r = result.toArray(r);
        return r;
    }

    private <I extends TreeNode<I>> boolean findPath(int id, List<I> path, I current) {
        if (((Id)((Object)current)).getId() == id) {
            path.add(current);
            return true;
        }
        List<I> children = current.getChildren();
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                TreeNode child = (TreeNode)children.get(i);
                if (!this.findPath((I)id, path, (I)child)) continue;
                path.add(current);
                return true;
            }
        }
        return false;
    }

    protected <I extends TreeNode<I>> I[] findPath(I id, I current) {
        ArrayList result = new ArrayList();
        this.findPath(id, result, current);
        Collections.reverse(result);
        TreeNode[] r = (TreeNode[])Array.newInstance(this.clazz, result.size());
        r = result.toArray(r);
        return r;
    }

    private <I extends TreeNode<I>> boolean findPath(I id, List<I> path, I current) {
        if (current.equals(id)) {
            path.add(current);
            return true;
        }
        List<I> children = current.getChildren();
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                TreeNode child = (TreeNode)children.get(i);
                if (!this.findPath(id, path, child)) continue;
                path.add(current);
                return true;
            }
        }
        return false;
    }

    public void setSelectedRow(N n) {
        this.setSelectedRows(Collections.singletonList(n));
    }

    public void setSelectedRow(Integer id) {
        this.setSelectedRows(Collections.singleton(id));
    }

    public void setSelectedRows(List<N> selected) {
        TreeSelectionModel selectionModel = this.getTree().getSelectionModel();
        selectionModel.clearSelection();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (TreeNode id : selected) {
            Object[] s = this.findPath(id, (TreeNode)this.root);
            if (s.length <= 0) continue;
            paths.add(new TreePath(s));
        }
        if (paths.size() > 0) {
            TreePath[] selectedPaths = paths.toArray(new TreePath[paths.size()]);
            selectionModel.setSelectionPaths(selectedPaths);
        }
    }

    public void setSelectedRows(Set<Integer> selected) {
        if (!Id.class.isAssignableFrom(this.clazz)) {
            throw new IllegalStateException();
        }
        TreeSelectionModel selectionModel = this.getTree().getSelectionModel();
        selectionModel.clearSelection();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (Integer id : selected) {
            Object[] s = this.findPath(id, (TreeNode)this.root);
            if (s.length <= 0) continue;
            paths.add(new TreePath(s));
        }
        if (paths.size() > 0) {
            TreePath[] selectedPaths = paths.toArray(new TreePath[paths.size()]);
            selectionModel.setSelectionPaths(selectedPaths);
        }
    }
}

