/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.json.JSONArray;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class CustomerParamHistoryDialog {
    private CustomerParamPanel customerParamPanel = null;

    public CustomerParamHistoryDialog(String title, String fieldKey, CustomerParamPanel customerParamPanel) {
        this.customerParamPanel = customerParamPanel;
        HistoryTableModel historyTableModel = new HistoryTableModel();
        BGUTable table = new BGUTable(historyTableModel);
        JTextField textField = new JTextField(title);
        textField.setHorizontalAlignment(0);
        textField.setFont(textField.getFont().deriveFont(1));
        Color bgColor = textField.getBackground();
        textField.setEditable(false);
        textField.setBackground(bgColor);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)textField, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        Dimension dimension = new Dimension(800, 300);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        try {
            JSONArray jsonArray = new JSONArray(customerParamPanel.getCustomerService().customerParameterHistory(((ClientContext)customerParamPanel.getContext()).getCustomerId(), fieldKey, 50));
            ArrayList<RowData> datas = new ArrayList<RowData>();
            for (int index = 0; index < jsonArray.length(); ++index) {
                datas.add(new RowData(jsonArray.getJSONObject(index)));
            }
            historyTableModel.setData(datas);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        ClientUtils.showDialog(panel, "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", -1);
    }

    class HistoryTableModel
    extends BGTableModel<RowData> {
        Directory<UserInfo> directory;

        public HistoryTableModel() {
            super(HistoryTableModel.class.getName());
            this.directory = null;
            try {
                this.directory = ((ClientContext)CustomerParamHistoryDialog.this.customerParamPanel.getContext()).getDirectory(UserInfo.class, 0);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", 180, 180, 180, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0418\u0437\u043c\u0435\u043d\u0438\u043b", 200, 200, 200, "user", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 100, -1, "value", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(RowData val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("user".equals(identifier)) {
                int userId = val.getJson().optInt("userId");
                UserInfo user = this.directory.get(userId);
                return user != null ? user.getName() : "#" + userId;
            }
            return val.getJson().opt(identifier);
        }
    }
}

