/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.template.jsp;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

class Session
implements HttpSession {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final long creationTime;
    private final String id;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private final ServletContext servletContext;

    public Session(ServletContext servletContext) {
        this.creationTime = System.currentTimeMillis();
        this.id = String.valueOf(idGenerator.incrementAndGet());
        this.servletContext = servletContext;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public void setAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return true;
    }
}

