/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class TimeRangeFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"clock");
    private Directory timeRangeDir;
    private JLabel view;
    private JPanel editorPanel;
    private String timeRangeTitle;
    private int timeRangeId;
    private BGComboBox<IdTitle> timeRangeCombo;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.timeRangeDir = this.getDirManager().getDirectory("time_range");
    }

    @Override
    protected JPanel getEditorPanel() throws Exception {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel();
            this.timeRangeCombo = new BGComboBox();
            this.buildDirectoryCombo(this.timeRangeDir, (JComboBox<IdTitle>)this.timeRangeCombo);
            this.editorPanel.add(new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d: "));
            this.editorPanel.add((Component)this.timeRangeCombo);
        }
        return this.editorPanel;
    }

    @Override
    public Component getView() throws Exception {
        this.extractData();
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0432\u0440\u0435\u043c\u0435\u043d\u0438: ");
        sb.append(this.timeRangeTitle);
        this.view.setText(sb.toString());
        return this.view;
    }

    @Override
    protected void loadData() throws Exception {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox<? extends IdTitle>)this.timeRangeCombo, this.timeRangeId);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        String timeRange = String.valueOf(this.getIdFromDirectoryCombo((JComboBox<? extends IdTitle>)this.timeRangeCombo));
        data.put("time_range", timeRange);
        this.setDataInHash(data);
    }

    private void extractData() throws Exception {
        Map<String, String> data = this.getDataInHash();
        this.timeRangeId = Utils.parseInt((String)data.get("time_range"));
        this.timeRangeTitle = Utils.maskNull((String)this.timeRangeDir.getValue(this.timeRangeId));
    }

    @Override
    public void serializeToXML(Element el) throws Exception {
        super.serializeToXML(el);
        this.extractData();
        if (Utils.notEmptyString((String)this.timeRangeTitle)) {
            el.setAttribute("title", this.timeRangeTitle);
        }
        el.setAttribute("id", String.valueOf(this.timeRangeId));
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>(3);
        String title = el.getAttribute("title");
        if (title.length() > 0) {
            int id = this.timeRangeDir.getCode(title);
            if (id < 0) {
                id = this.timeRangeDir.addValue(title);
            }
            data.put("time_range", String.valueOf(id));
        }
        this.setDataInHash(data);
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

